/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.predicate;

import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.AccessControlPredicate;

public class RolePredicates {
    public static final AccessControlPredicate<Object> ACADEMIC_ADMINISTRATIVE_OFFICE_PREDICATE = new AccessControlPredicate<Object>(){

        @Override
        public boolean evaluate(Object domainObject) {
            return RolePredicates.hasRole(RoleType.ACADEMIC_ADMINISTRATIVE_OFFICE);
        }
    };
    public static final AccessControlPredicate<Object> BOLONHA_MANAGER_PREDICATE = new AccessControlPredicate<Object>(){

        @Override
        public boolean evaluate(Object domainObject) {
            return RolePredicates.hasRole(RoleType.BOLONHA_MANAGER);
        }
    };
    public static final AccessControlPredicate<Object> DIRECTIVE_COUNCIL_PREDICATE = new AccessControlPredicate<Object>(){

        @Override
        public boolean evaluate(Object object) {
            return RolePredicates.hasRole(RoleType.DIRECTIVE_COUNCIL);
        }
    };
    public static final AccessControlPredicate<Object> GEP_PREDICATE = new AccessControlPredicate<Object>(){

        @Override
        public boolean evaluate(Object domainObject) {
            return RolePredicates.hasRole(RoleType.GEP);
        }
    };
    public static final AccessControlPredicate<Object> MANAGER_OR_ACADEMIC_ADMINISTRATIVE_OFFICE_PREDICATE = new AccessControlPredicate<Object>(){

        @Override
        public boolean evaluate(Object domainObject) {
            return MANAGER_PREDICATE.evaluate(domainObject) || ACADEMIC_ADMINISTRATIVE_OFFICE_PREDICATE.evaluate(domainObject);
        }
    };
    public static final AccessControlPredicate<Object> MANAGER_PREDICATE = new AccessControlPredicate<Object>(){

        @Override
        public boolean evaluate(Object domainObject) {
            return RolePredicates.hasRole(RoleType.MANAGER);
        }
    };
    public static final AccessControlPredicate<Object> MANAGER_OR_OPERATOR_PREDICATE = new AccessControlPredicate<Object>(){

        @Override
        public boolean evaluate(Object domainObject) {
            return MANAGER_PREDICATE.evaluate(domainObject) || OPERATOR_PREDICATE.evaluate(domainObject);
        }
    };
    public static final AccessControlPredicate<Object> MASTER_DEGREE_ADMINISTRATIVE_OFFICE_PREDICATE = new AccessControlPredicate<Object>(){

        @Override
        public boolean evaluate(Object domainObject) {
            return RolePredicates.hasRole(RoleType.MASTER_DEGREE_ADMINISTRATIVE_OFFICE);
        }
    };
    public static final AccessControlPredicate<Object> OPERATOR_PREDICATE = new AccessControlPredicate<Object>(){

        @Override
        public boolean evaluate(Object domainObject) {
            return RolePredicates.hasRole(RoleType.OPERATOR);
        }
    };
    public static final AccessControlPredicate<Object> RESOURCE_ALLOCATION_MANAGER_PREDICATE = new AccessControlPredicate<Object>(){

        @Override
        public boolean evaluate(Object domainObject) {
            return RolePredicates.hasRole(RoleType.RESOURCE_ALLOCATION_MANAGER);
        }
    };
    public static final AccessControlPredicate<Object> SCIENTIFIC_COUNCIL_PREDICATE = new AccessControlPredicate<Object>(){

        @Override
        public boolean evaluate(Object domainObject) {
            return RolePredicates.hasRole(RoleType.SCIENTIFIC_COUNCIL);
        }
    };
    public static final AccessControlPredicate<Object> STUDENT_PREDICATE = new AccessControlPredicate<Object>(){

        @Override
        public boolean evaluate(Object domainObject) {
            return RolePredicates.hasRole(RoleType.STUDENT);
        }
    };
    public static final AccessControlPredicate<Object> TEACHER_PREDICATE = new AccessControlPredicate<Object>(){

        @Override
        public boolean evaluate(Object domainObject) {
            return RolePredicates.isTeacher();
        }
    };
    public static final AccessControlPredicate<Object> STUDENT_AND_TEACHER_PREDICATE = new AccessControlPredicate<Object>(){

        @Override
        public boolean evaluate(Object domainObject) {
            return RolePredicates.isTeacher() || RolePredicates.hasRole(RoleType.STUDENT);
        }
    };

    private static boolean hasRole(RoleType roleType) {
        Person person = AccessControl.getPerson();
        return person != null && roleType.isMember(person.getUser());
    }

    private static boolean isTeacher() {
        return RolePredicates.hasRole(RoleType.TEACHER) || RolePredicates.hasActiveProfessorship();
    }

    private static boolean hasActiveProfessorship() {
        ExecutionSemester executionSemester = ExecutionSemester.readActualExecutionSemester();
        Person person = AccessControl.getPerson();
        for (Professorship professorship : person.getProfessorshipsSet()) {
            if (professorship.getExecutionCourse().getExecutionPeriod() != executionSemester) continue;
            return true;
        }
        return false;
    }
}

