/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.Calendar;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoRoomOccupation;
import org.fenixedu.academic.dto.InfoWrittenEvaluation;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.EvaluationType;
import org.fenixedu.academic.util.Season;

public class InfoExam
extends InfoWrittenEvaluation {
    protected Season season;
    private List infoExecutionCourses;
    private InfoExecutionCourse infoExecutionCourse;

    public InfoExam() {
    }

    public InfoExam(Calendar day, Calendar beginning, Calendar end, Season season) {
        this.setDay(day);
        this.setBeginning(beginning);
        this.setEnd(end);
        this.setSeason(season);
    }

    @Override
    public String toString() {
        return "[INFOEXAM: day= '" + this.getDay() + "'" + " beginning= '" + this.getBeginning() + "'" + " end= '" + this.getEnd() + "'" + " season= '" + this.getSeason() + "'" + "";
    }

    public Season getSeason() {
        return this.season;
    }

    public void setSeason(Season season) {
        this.season = season;
    }

    public InfoExecutionCourse getInfoExecutionCourse() {
        return this.infoExecutionCourse;
    }

    public void setInfoExecutionCourse(InfoExecutionCourse course) {
        this.infoExecutionCourse = course;
    }

    public List getAssociatedRooms() {
        return (List)CollectionUtils.collect(super.getWrittenEvaluationSpaceOccupations(), (Transformer)new Transformer(){

            public Object transform(Object arg0) {
                InfoRoomOccupation roomOccupation = (InfoRoomOccupation)arg0;
                return roomOccupation.getInfoRoom();
            }
        });
    }

    public String getDate() {
        if (this.getDay() == null) {
            return "0/0/0";
        }
        String result = String.valueOf(this.getDay().get(5));
        result = result + "/";
        result = result + String.valueOf(this.getDay().get(2) + 1);
        result = result + "/";
        result = result + String.valueOf(this.getDay().get(1));
        return result;
    }

    public String getBeginningHour() {
        if (this.getBeginning() == null) {
            return "00:00";
        }
        String result = this.format(String.valueOf(this.getBeginning().get(11)));
        result = result + ":";
        result = result + this.format(String.valueOf(this.getBeginning().get(12)));
        return result;
    }

    public String getEndHour() {
        if (this.getEnd() == null) {
            return "00:00";
        }
        String result = this.format(String.valueOf(this.getEnd().get(11)));
        result = result + ":";
        result = result + this.format(String.valueOf(this.getEnd().get(12)));
        return result;
    }

    private String format(String string) {
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    public String dateFormatter(Calendar calendar) {
        String result = "";
        if (calendar != null) {
            result = result + calendar.get(5);
            result = result + "/";
            result = result + (calendar.get(2) + 1);
            result = result + "/";
            result = result + calendar.get(1);
        }
        return result;
    }

    public String timeFormatter(Calendar calendar) {
        String result = "";
        if (calendar != null) {
            result = result + calendar.get(11);
            result = result + ":";
            if (calendar.get(12) < 10) {
                result = result + "0";
                result = result + calendar.get(12);
            } else {
                result = result + calendar.get(12);
            }
        }
        return result;
    }

    public String getEnrollmentBeginDayFormatted() {
        return this.dateFormatter(this.getEnrollmentBeginDay());
    }

    public String getEnrollmentEndDayFormatted() {
        return this.dateFormatter(this.getEnrollmentEndDay());
    }

    public String getEnrollmentBeginTimeFormatted() {
        return this.timeFormatter(this.getEnrollmentBeginTime());
    }

    public String getEnrollmentEndTimeFormatted() {
        return this.timeFormatter(this.getEnrollmentEndTime());
    }

    public boolean getEnrollmentAuthorization() {
        if (this.getEnrollmentEndDay() == null) {
            return false;
        }
        Calendar enrollmentEnd = Calendar.getInstance();
        enrollmentEnd.set(5, this.getEnrollmentEndDay().get(5));
        enrollmentEnd.set(2, this.getEnrollmentEndDay().get(2));
        enrollmentEnd.set(1, this.getEnrollmentEndDay().get(1));
        enrollmentEnd.set(11, this.getEnrollmentEndTime().get(11));
        enrollmentEnd.set(12, this.getEnrollmentEndTime().get(12));
        Calendar now = Calendar.getInstance();
        return enrollmentEnd.getTimeInMillis() > now.getTimeInMillis();
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof InfoExam) {
            InfoExam infoExam = (InfoExam)obj;
            result = this.getExternalId().equals(infoExam.getExternalId()) && this.getDate().equals(infoExam.getDate()) && this.getEnrollmentBeginDayFormatted().equals(infoExam.getEnrollmentBeginDayFormatted()) && this.getEnrollmentBeginTimeFormatted().equals(infoExam.getEnrollmentBeginTimeFormatted()) && this.getEnrollmentEndDayFormatted().equals(infoExam.getEnrollmentEndDayFormatted()) && this.getEnrollmentEndTimeFormatted().equals(infoExam.getEnrollmentEndTimeFormatted());
        }
        return result;
    }

    @Override
    public DiaSemana getDiaSemana() {
        Calendar day = this.getDay();
        return new DiaSemana(day.get(7));
    }

    public List getInfoExecutionCourses() {
        return this.infoExecutionCourses;
    }

    public void setInfoExecutionCourses(List infoExecutionCourses) {
        this.infoExecutionCourses = infoExecutionCourses;
    }

    public void copyFromDomain(Exam exam) {
        super.copyFromDomain((WrittenEvaluation)((Object)exam));
        if (exam != null) {
            this.setSeason(exam.getSeason());
            this.setEvaluationType(EvaluationType.EXAM_TYPE);
        }
    }

    public static InfoExam newInfoFromDomain(Exam exam) {
        InfoExam infoExam = null;
        if (exam != null) {
            infoExam = new InfoExam();
            infoExam.copyFromDomain(exam);
        }
        return infoExam;
    }
}

