/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.util.icalendar;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import java.util.Set;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;

public class EventBean {
    private DateTime begin;
    private DateTime end;
    private boolean allDay;
    private String title;
    private Set<Space> rooms;
    private String url;
    private String note;

    public EventBean(String title, DateTime begin, DateTime end, boolean allDay, Set<Space> rooms, String url, String note) {
        this.allDay = allDay;
        this.begin = begin;
        this.end = end;
        this.note = note;
        this.rooms = rooms;
        this.title = title;
        this.url = url;
    }

    public DateTime getBegin() {
        return this.begin;
    }

    public void setBegin(DateTime begin) {
        this.begin = begin;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public void setEnd(DateTime end) {
        this.end = end;
    }

    public boolean isAllDay() {
        return this.allDay;
    }

    public void setAllDay(boolean allDay) {
        this.allDay = allDay;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLocation() {
        return this.rooms == null ? "Fenix" : Joiner.on((String)"; ").join((Iterable)FluentIterable.from(this.rooms).transform((Function)new Function<Space, String>(){

            public String apply(Space input) {
                return input.getName();
            }
        }).toSet());
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Set<Space> getRooms() {
        return this.rooms;
    }

    public void setRoom(Set<Space> room) {
        this.rooms = room;
    }

    public String getOriginalTitle() {
        return this.getTitle();
    }
}

