/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class EmailAddressList
implements Serializable {
    private final String emailAddresses;

    public EmailAddressList(String emailAddresses) {
        this.emailAddresses = emailAddresses == null || emailAddresses.length() == 0 ? null : emailAddresses;
    }

    public EmailAddressList(Collection<String> emailAddressCollection) {
        StringBuilder emailAddresses = new StringBuilder();
        if (emailAddressCollection != null) {
            for (String emailAddress : emailAddressCollection) {
                if (emailAddress == null) continue;
                String emailAddressTrimmed = emailAddress.trim();
                if (emailAddresses.length() > 0) {
                    emailAddresses.append(", ");
                }
                emailAddresses.append(emailAddressTrimmed);
            }
        }
        this.emailAddresses = emailAddresses.length() == 0 ? null : emailAddresses.toString();
    }

    public String toString() {
        return this.emailAddresses;
    }

    public String[] toArray() {
        return this.emailAddresses == null ? new String[]{} : this.emailAddresses.split(", ");
    }

    public Collection<String> toCollection() {
        if (this.emailAddresses == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> collection = new ArrayList<String>();
        for (String emailAddress : this.toArray()) {
            collection.add(emailAddress);
        }
        return collection;
    }

    public boolean isEmpty() {
        return this.emailAddresses == null || this.emailAddresses.length() == 0;
    }

    public int size() {
        return this.toArray().length;
    }
}

