/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import java.util.Collection;
import java.util.HashSet;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.CertificateRequestEvent;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.EnrolmentCertificateRequest_Base;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;

public class EnrolmentCertificateRequest
extends EnrolmentCertificateRequest_Base {
    protected EnrolmentCertificateRequest() {
    }

    public EnrolmentCertificateRequest(DocumentRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
    }

    protected void checkParameters(DocumentRequestCreateBean bean) {
        if (bean.getDetailed() == null) {
            throw new DomainException("error.serviceRequests.documentRequests.EnrolmentCertificateRequest.detailed.cannot.be.null", new String[0]);
        }
        if (bean.getExecutionYear() == null) {
            throw new DomainException("error.serviceRequests.documentRequests.EnrolmentCertificateRequest.executionYear.cannot.be.null", new String[0]);
        }
        if (!bean.getRegistration().hasAnyEnrolmentsIn(bean.getExecutionYear())) {
            throw new DomainException("EnrolmentCertificateRequest.no.enrolments.for.registration.in.given.executionYear", new String[0]);
        }
    }

    public final DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.ENROLMENT_CERTIFICATE;
    }

    public final String getDocumentTemplateKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final void setDetailed(Boolean detailed) {
        throw new DomainException("error.serviceRequests.documentRequests.EnrolmentCertificateRequest.cannot.modify.detailed", new String[0]);
    }

    public final EventType getEventType() {
        return EventType.ENROLMENT_CERTIFICATE_REQUEST;
    }

    public final Integer getNumberOfUnits() {
        return this.getEntriesToReport().size() + this.getExtraCurricularEntriesToReport().size() + this.getPropaedeuticEntriesToReport().size();
    }

    public final Collection<Enrolment> getEntriesToReport() {
        return this.getRegistration().getLatestCurricularCoursesEnrolments(this.getExecutionYear());
    }

    public final Collection<Enrolment> getExtraCurricularEntriesToReport() {
        HashSet<Enrolment> extraCurricular = new HashSet<Enrolment>();
        for (Enrolment entry : this.getRegistration().getLatestCurricularCoursesEnrolments(this.getExecutionYear())) {
            if (!entry.isExtraCurricular() || !entry.getEnrolmentWrappersSet().isEmpty()) continue;
            extraCurricular.add(entry);
        }
        return extraCurricular;
    }

    public final Collection<Enrolment> getPropaedeuticEntriesToReport() {
        HashSet<Enrolment> propaedeutic = new HashSet<Enrolment>();
        for (Enrolment entry : this.getRegistration().getLatestCurricularCoursesEnrolments(this.getExecutionYear())) {
            if (entry.isExtraCurricular() && entry.getEnrolmentWrappersSet().isEmpty() || !entry.isPropaedeutic()) continue;
            propaedeutic.add(entry);
        }
        return propaedeutic;
    }

    public boolean isAvailableForTransitedRegistrations() {
        return true;
    }

    public boolean hasPersonalInfo() {
        return true;
    }

    public CertificateRequestEvent getEvent() {
        return (CertificateRequestEvent)((Object)super.getEvent());
    }
}

