/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.RootCourseGroup_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;

public class RootCourseGroup
extends RootCourseGroup_Base {
    public RootCourseGroup() {
    }

    public RootCourseGroup(DegreeCurricularPlan degreeCurricularPlan, String name, String nameEn) {
        if (degreeCurricularPlan == null) {
            throw new DomainException("error.degreeStructure.CourseGroup.degreeCurricularPlan.cannot.be.null", new String[0]);
        }
        this.init(name, nameEn);
        this.setParentDegreeCurricularPlan(degreeCurricularPlan);
        this.createCycleCourseGroups(degreeCurricularPlan.getDegreeType());
    }

    private void createCycleCourseGroups(DegreeType degreeType) {
        ExecutionSemester executionSemester = ExecutionSemester.readActualExecutionSemester();
        for (CycleType cycleType : degreeType.getCycleTypes()) {
            new CycleCourseGroup(this, cycleType.getDescription(Locale.getDefault()), cycleType.getDescription(Locale.ENGLISH), cycleType, executionSemester, null);
        }
    }

    public boolean isRoot() {
        return true;
    }

    public void delete() {
        if (!this.getCanBeDeleted().booleanValue()) {
            throw new DomainException("courseGroup.notEmptyCourseGroupContexts", new String[0]);
        }
        this.removeChildDegreeModules();
        this.setParentDegreeCurricularPlan(null);
        super.delete();
    }

    private void removeChildDegreeModules() {
        for (DegreeModule degreeModule : this.getChildDegreeModules()) {
            degreeModule.delete();
        }
    }

    public Boolean getCanBeDeleted() {
        return this.getCurriculumModulesSet().isEmpty() && this.childsCanBeDeleted();
    }

    private boolean childsCanBeDeleted() {
        for (Context context : this.getChildContextsSet()) {
            DegreeModule degreeModule = context.getChildDegreeModule();
            if (degreeModule.getCanBeDeleted().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static RootCourseGroup createRoot(DegreeCurricularPlan degreeCurricularPlan, String name, String nameEn) {
        return new RootCourseGroup(degreeCurricularPlan, name, nameEn);
    }

    public void addParentContexts(Context parentContexts) {
        throw new DomainException("error.degreeStructure.RootCourseGroup.cannot.have.parent.contexts", new String[0]);
    }

    public CycleCourseGroup getFirstCycleCourseGroup() {
        return this.getCycleCourseGroup(CycleType.FIRST_CYCLE);
    }

    public CycleCourseGroup getSecondCycleCourseGroup() {
        return this.getCycleCourseGroup(CycleType.SECOND_CYCLE);
    }

    public CycleCourseGroup getThirdCycleCourseGroup() {
        return this.getCycleCourseGroup(CycleType.THIRD_CYCLE);
    }

    public CycleCourseGroup getCycleCourseGroup(CycleType cycle) {
        for (Context context : this.getChildContextsSet()) {
            CycleCourseGroup cycleCourseGroup;
            if (!context.getChildDegreeModule().isCycleCourseGroup() || cycle != (cycleCourseGroup = (CycleCourseGroup)((Object)context.getChildDegreeModule())).getCycleType()) continue;
            return (CycleCourseGroup)((Object)context.getChildDegreeModule());
        }
        return null;
    }

    public Collection<CycleCourseGroup> getCycleCourseGroups() {
        HashSet<CycleCourseGroup> result = new HashSet<CycleCourseGroup>();
        for (Context context : this.getChildContextsSet()) {
            if (!context.getChildDegreeModule().isCycleCourseGroup()) continue;
            result.add((CycleCourseGroup)((Object)context.getChildDegreeModule()));
        }
        return result;
    }

    public boolean hasCycleGroups() {
        return !this.getCycleCourseGroups().isEmpty();
    }

    public Collection<CycleCourseGroup> getParentCycleCourseGroups() {
        return Collections.emptySet();
    }
}

