/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.InstitutionPrecedentDegreeInformation_Base;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.AverageType;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

@Deprecated
public class InstitutionPrecedentDegreeInformation
extends InstitutionPrecedentDegreeInformation_Base {
    private InstitutionPrecedentDegreeInformation() {
    }

    private InstitutionPrecedentDegreeInformation(IndividualCandidacy candidacy, StudentCurricularPlan studentCurricularPlan) {
        this(candidacy, studentCurricularPlan, null);
    }

    private InstitutionPrecedentDegreeInformation(IndividualCandidacy candidacy, StudentCurricularPlan studentCurricularPlan, CycleType cycleType) {
        this();
        this.checkParameters(candidacy, studentCurricularPlan, cycleType);
        this.setStudentCurricularPlan(studentCurricularPlan);
        this.setCycleType(cycleType);
    }

    private void checkParameters(IndividualCandidacy candidacy, StudentCurricularPlan studentCurricularPlan, CycleType cycleType) {
        if (candidacy == null) {
            throw new DomainException("error.InstitutionPrecedentDegreeInformation.invalid.candidacy", new String[0]);
        }
        if (studentCurricularPlan == null) {
            throw new DomainException("error.InstitutionPrecedentDegreeInformation.invalid.studentCurricularPlan", new String[0]);
        }
        if (studentCurricularPlan.isBolonhaDegree() && cycleType == null) {
            throw new DomainException("error.InstitutionPrecedentDegreeInformation.invalid.cycleType", new String[0]);
        }
    }

    private boolean isBolonha() {
        return this.getStudentCurricularPlan().isBolonhaDegree();
    }

    public LocalDate getConclusionDate() {
        YearMonthDay date = this.isBolonha() ? (this.getStudentCurricularPlan().getCycle(this.getCycleType()) != null ? this.getStudentCurricularPlan().getConclusionDate(this.getCycleType()) : null) : this.getRegistration().getConclusionDate();
        return date != null ? new LocalDate((Object)date) : null;
    }

    protected Integer getConclusionYear() {
        LocalDate localDate = this.getConclusionDate();
        return localDate != null ? Integer.valueOf(localDate.getYear()) : null;
    }

    public String getConclusionGrade() {
        Grade result = this.isBolonha() ? (this.getStudentCurricularPlan().getCycle(this.getCycleType()) != null ? this.getStudentCurricularPlan().getCycle(this.getCycleType()).getFinalGrade() : null) : this.getRegistration().getFinalGrade();
        return result == null ? null : result.getValue();
    }

    public String getDegreeDesignation() {
        return this.getStudentCurricularPlan().getName();
    }

    public Unit getInstitution() {
        return this.getRootDomainObject().getInstitutionUnit();
    }

    public Registration getRegistration() {
        return this.getStudentCurricularPlan().getRegistration();
    }

    public Integer getNumberOfEnroledCurricularCourses() {
        return this.getStudentCurricularPlan().getRoot().getNumberOfAllEnroledCurriculumLines();
    }

    public Integer getNumberOfApprovedCurricularCourses() {
        return this.getStudentCurricularPlan().getRoot().getNumberOfAllApprovedCurriculumLines();
    }

    public BigDecimal getGradeSum() {
        Curriculum curriculum = this.getStudentCurricularPlan().getRoot().getCurriculum();
        curriculum.setAverageType(AverageType.SIMPLE);
        return curriculum.getWeigthedGradeSum();
    }

    public BigDecimal getApprovedEcts() {
        return BigDecimal.valueOf(this.getStudentCurricularPlan().getRoot().getAprovedEctsCredits());
    }

    public BigDecimal getEnroledEcts() {
        return BigDecimal.valueOf(this.getStudentCurricularPlan().getRoot().getEctsCredits());
    }

    public boolean isInternal() {
        return true;
    }
}

