/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import java.util.Formatter;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.candidacyProcess.FormationBean;
import org.fenixedu.academic.domain.candidacyProcess.Formation_Base;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class Formation
extends Formation_Base {
    public Formation() {
    }

    public Formation(IndividualCandidacy individualCandidacy, FormationBean bean) {
        this();
        this.edit(bean);
        this.setIndividualCandidacy(individualCandidacy);
    }

    public void edit(FormationBean bean) {
        this.setBeginYear(bean.getFormationBeginYear());
        this.setBranch(null);
        this.setConcluded(bean.isConcluded());
        this.setCountry(null);
        this.setDateYearMonthDay(null);
        this.setDegree(null);
        this.setDegreeRecognition(null);
        this.setDesignation(bean.getDesignation());
        this.setEctsCredits(null);
        this.setEducationArea(null);
        this.setEquivalenceDateYearMonthDay(null);
        this.setEquivalenceSchool(null);
        this.setFormationHours(null);
        this.setFormationType(null);
        this.setInstitution(this.getOrCreateInstitution(bean));
        this.setMark(null);
        this.setPerson(null);
        this.setSchool(null);
        this.setSpecializationArea(null);
        this.setTitle(null);
        this.setType(null);
        this.setYear(bean.getFormationEndYear());
        this.setConclusionGrade(bean.getConclusionGrade());
        this.setConclusionExecutionYear(bean.getConclusionExecutionYear());
    }

    private Unit getOrCreateInstitution(FormationBean bean) {
        if (StringUtils.isEmpty((String)bean.getInstitutionName()) && bean.getInstitutionUnit() != null) {
            return bean.getInstitutionUnit();
        }
        if (bean.getInstitutionName() == null || bean.getInstitutionName().isEmpty()) {
            throw new DomainException("error.ExternalPrecedentDegreeCandidacy.invalid.institution.name", new String[0]);
        }
        Unit unit = Unit.findFirstExternalUnitByName(bean.getInstitutionName());
        return unit != null ? unit : Unit.createNewNoOfficialExternalInstitution(bean.getInstitutionName());
    }

    public void exportValues(StringBuilder result) {
        Formatter formatter = new Formatter(result);
        formatter.format("\n%s:\n", BundleUtil.getString((String)"resources.CandidateResources", (String)"title.other.academic.titles", (String[])new String[0]));
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.CandidateResources", (String)"label.other.academic.titles.program.name", (String[])new String[0]), this.getDesignation());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.CandidateResources", (String)"label.other.academic.titles.institution", (String[])new String[0]), this.getInstitution().getName());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.CandidateResources", (String)"label.other.academic.titles.conclusion.date", (String[])new String[0]), StringUtils.isEmpty((String)this.getYear()) ? "" : this.getYear());
        formatter.format("%s: %s\n", BundleUtil.getString((String)"resources.CandidateResources", (String)"label.other.academic.titles.conclusion.grade", (String[])new String[0]), StringUtils.isEmpty((String)this.getConclusionGrade()) ? "" : this.getConclusionGrade());
        formatter.close();
    }
}

