/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.util.PaymentCodeGenerator;

@Deprecated
public class PersonRotationPaymentCodeGenerator
extends PaymentCodeGenerator {
    public static Comparator<PaymentCode> COMPARATOR_BY_PAYMENT_CODE_CONTROL_DIGITS = new Comparator<PaymentCode>(){

        @Override
        public int compare(PaymentCode leftPaymentCode, PaymentCode rightPaymentCode) {
            String rightCodeControlDigits;
            String leftCodeControlDigits = leftPaymentCode.getCode().substring(leftPaymentCode.getCode().length() - 2);
            int comparationResult = leftCodeControlDigits.compareTo(rightCodeControlDigits = rightPaymentCode.getCode().substring(rightPaymentCode.getCode().length() - 2));
            return comparationResult == 0 ? leftPaymentCode.getExternalId().compareTo(rightPaymentCode.getExternalId()) : comparationResult;
        }
    };
    private static final int CONTROL_DIGITS_LENGTH = 2;
    private static final String CODE_FILLER = "0";
    private static final int PERSON_CODE_LENGTH = 6;
    private static final int CODE_LENGTH = 9;

    @Override
    public boolean canGenerateNewCode(PaymentCodeType paymentCodeType, Person person) {
        PaymentCode lastPaymentCode = this.findLastPaymentCode(paymentCodeType, person);
        return lastPaymentCode == null ? true : PersonRotationPaymentCodeGenerator.getSignificantNumberForCodeGeneration(lastPaymentCode) + 1 <= 99;
    }

    @Override
    public String generateNewCodeFor(PaymentCodeType paymentCodeType, Person person) {
        PaymentCode lastPaymentCode = this.findLastPaymentCode(paymentCodeType, person);
        return lastPaymentCode == null ? PersonRotationPaymentCodeGenerator.generateFirstCodeForType(paymentCodeType, person) : PersonRotationPaymentCodeGenerator.generateNewCodeBasedOnLastPaymentCode(lastPaymentCode);
    }

    private PaymentCode findLastPaymentCode(PaymentCodeType paymentCodeType, Person person) {
        ArrayList<PaymentCode> paymentCodes = new ArrayList<PaymentCode>();
        for (PaymentCode code : person.getPaymentCodesBy(paymentCodeType)) {
            if (!this.isCodeMadeByThisFactory(code)) continue;
            paymentCodes.add(code);
        }
        return paymentCodes.isEmpty() ? null : Collections.max(paymentCodes, COMPARATOR_BY_PAYMENT_CODE_CONTROL_DIGITS);
    }

    private static String generateFirstCodeForType(PaymentCodeType paymentCodeType, Person person) {
        return PersonRotationPaymentCodeGenerator.generateFinalCode(paymentCodeType, person, 0);
    }

    private static String generateNewCodeBasedOnLastPaymentCode(PaymentCode paymentCode) {
        return PersonRotationPaymentCodeGenerator.generateNewCodeBasedOnSignificantNumber(paymentCode.getType(), paymentCode.getPerson(), PersonRotationPaymentCodeGenerator.getSignificantNumberForCodeGeneration(paymentCode));
    }

    private static int getSignificantNumberForCodeGeneration(PaymentCode lastPaymentCode) {
        return Integer.valueOf(lastPaymentCode.getCode().substring(lastPaymentCode.getCode().length() - 2));
    }

    private static String generateNewCodeBasedOnSignificantNumber(PaymentCodeType paymentCodeType, Person person, int number) {
        return PersonRotationPaymentCodeGenerator.generateFinalCode(paymentCodeType, person, number + 1);
    }

    private static String generateFinalCode(PaymentCodeType paymentCodeType, Person person, int digits) {
        String finalCode = PersonRotationPaymentCodeGenerator.getCodePrefix(paymentCodeType, person) + StringUtils.leftPad((String)String.valueOf(digits), (int)2, (String)CODE_FILLER);
        if (finalCode.length() != 9) {
            throw new RuntimeException("Unexpected code length for generated code");
        }
        return finalCode;
    }

    private static String getCodePrefix(PaymentCodeType paymentCodeType, Person person) {
        return PersonRotationPaymentCodeGenerator.getPersonCodeDigits(person) + paymentCodeType.getTypeDigit();
    }

    private static String getPersonCodeDigits(Person person) {
        if (person.getUsername().length() > 9) {
            throw new RuntimeException("SIBS Payment Code: " + person.getUsername() + " exceeded maximun size accepted");
        }
        return StringUtils.leftPad((String)person.getUsername().replace("ist", ""), (int)6, (String)CODE_FILLER);
    }

    @Override
    public boolean isCodeMadeByThisFactory(PaymentCode paymentCode) {
        return paymentCode.getCode().startsWith(PersonRotationPaymentCodeGenerator.getPersonCodeDigits(paymentCode.getPerson()));
    }
}

