/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.installments;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.PaymentPlan;
import org.fenixedu.academic.domain.accounting.installments.InstallmentForFirstTimeStudents;
import org.fenixedu.academic.domain.accounting.installments.InstallmentWithMonthlyPenalty_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.accounting.paymentPlan.InstallmentBean;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;

public class InstallmentWithMonthlyPenalty
extends InstallmentWithMonthlyPenalty_Base {
    protected InstallmentWithMonthlyPenalty() {
    }

    public InstallmentWithMonthlyPenalty(PaymentPlan paymentPlan, Money amount, YearMonthDay startDate, YearMonthDay endDate, BigDecimal penaltyPercentage, YearMonthDay whenStartToApplyPenalty, Integer maxMonthsToApplyPenalty) {
        this();
        this.init(paymentPlan, amount, startDate, endDate, penaltyPercentage, whenStartToApplyPenalty, maxMonthsToApplyPenalty);
    }

    protected void init(PaymentPlan paymentPlan, Money amount, YearMonthDay startDate, YearMonthDay endDate, BigDecimal penaltyPercentage, YearMonthDay whenStartToApplyPenalty, Integer maxMonthsToApplyPenalty) {
        super.init(paymentPlan, amount, startDate, endDate, penaltyPercentage);
        this.checkParameters(whenStartToApplyPenalty, maxMonthsToApplyPenalty);
        super.setWhenStartToApplyPenalty(whenStartToApplyPenalty);
        super.setMaxMonthsToApplyPenalty(maxMonthsToApplyPenalty);
    }

    private void checkParameters(YearMonthDay whenStartToApplyPenalty, Integer maxMonthsToApplyPenalty) {
        if (!(this instanceof InstallmentForFirstTimeStudents) && whenStartToApplyPenalty == null) {
            throw new DomainException("error.accounting.installments.InstallmentWithMonthlyPenalty.whenStartToApplyPenalty.cannot.be.null", new String[0]);
        }
        if (maxMonthsToApplyPenalty == null) {
            throw new DomainException("error.accounting.installments.InstallmentWithMonthlyPenalty.maxMonthsToApplyPenalty.cannot.be.null", new String[0]);
        }
        if (maxMonthsToApplyPenalty <= 0) {
            throw new DomainException("error.accounting.installments.InstallmentWithMonthlyPenalty.maxMonthsToApplyPenalty.must.be.greater.than.zero", new String[0]);
        }
    }

    protected Money calculatePenaltyAmount(Event event, DateTime when, BigDecimal discountPercentage) {
        if (when.toDateMidnight().compareTo((ReadableInstant)this.getWhenStartToApplyPenalty().toDateMidnight()) >= 0) {
            return new Money(this.calculateMonthPenalty(event, discountPercentage).multiply(new BigDecimal(this.getNumberOfMonthsToChargePenalty(when))));
        }
        return Money.ZERO;
    }

    protected BigDecimal calculateMonthPenalty(Event event, BigDecimal discountPercentage) {
        BigDecimal amount = this.calculateAmountWithDiscount(event, discountPercentage).getAmount();
        amount.setScale(10);
        return amount.multiply(this.getPenaltyPercentage());
    }

    protected int getNumberOfMonthsToChargePenalty(DateTime when) {
        Period period = new Period((ReadableInstant)this.getWhenStartToApplyPenalty().withDayOfMonth(1).toDateMidnight(), (ReadableInstant)when.toDateMidnight());
        int numberOfMonths = period.getYears() * 12 + (period.getMonths() + 1);
        return numberOfMonths < this.getMaxMonthsToApplyPenalty() ? numberOfMonths : this.getMaxMonthsToApplyPenalty();
    }

    public boolean isWithMonthlyPenalty() {
        return true;
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel("resources.ApplicationResources", "label.InstallmentWithMonthlyPenalty.description", this.getInstallmentOrder().toString(), this.getStartDate().toString("dd/MM/yyyy"), this.getEndDate().toString("dd/MM/yyyy"), this.getPenaltyPercentage().multiply(BigDecimal.valueOf(100L)).toString(), this.getWhenStartToApplyPenalty().toString("dd/MM/yyyy"));
        return labelFormatter;
    }

    public void edit(InstallmentBean bean) {
        Integer maxMonthsToApplyPenalty = bean.getMaxMonthsToApplyPenalty();
        YearMonthDay whenStartToApplyPenalty = bean.getWhenToStartApplyPenalty();
        BigDecimal penaltyPercentage = bean.getMontlyPenaltyPercentage();
        this.checkParameters(whenStartToApplyPenalty, maxMonthsToApplyPenalty);
        super.setMaxMonthsToApplyPenalty(maxMonthsToApplyPenalty);
        if (!(this instanceof InstallmentForFirstTimeStudents)) {
            super.setWhenStartToApplyPenalty(whenStartToApplyPenalty);
        }
        super.setPenaltyPercentage(penaltyPercentage);
        super.edit(bean);
    }
}

