/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.ProjectSubmission;
import org.fenixedu.academic.domain.ProjectSubmissionLog;
import org.fenixedu.academic.domain.Project_Base;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.GroupEnrolment;
import org.fenixedu.academic.domain.util.icalendar.EvaluationEventBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.util.EvaluationType;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class Project
extends Project_Base {
    private static final Logger logger = LoggerFactory.getLogger(Project.class);

    private Project() {
    }

    public Project(String name, Date begin, Date end, String description, Boolean onlineSubmissionsAllowed, Integer maxSubmissionsToKeep, Grouping grouping, ExecutionCourse executionCourse) {
        this();
        if (name == null || begin == null || end == null || executionCourse == null) {
            throw new NullPointerException();
        }
        if (begin.after(end)) {
            throw new DomainException("error.evaluation.begin.sooner.end", new String[0]);
        }
        this.setName(name);
        this.setBegin(begin);
        this.setEnd(end);
        this.setDescription(description != null ? description : "");
        this.addAssociatedExecutionCourses(executionCourse);
        this.setGradeScale(GradeScale.TYPE20);
        this.setOnlineSubmissionProperties(onlineSubmissionsAllowed, maxSubmissionsToKeep, grouping);
    }

    public Project(String name, Date begin, Date end, String description, Boolean onlineSubmissionsAllowed, Integer maxSubmissionsToKeep, Grouping grouping, ExecutionCourse executionCourse, GradeScale gradeScale) {
        this(name, begin, end, description, onlineSubmissionsAllowed, maxSubmissionsToKeep, grouping, executionCourse);
        if (gradeScale != null) {
            this.setGradeScale(gradeScale);
        }
        this.logCreate();
    }

    public void edit(String name, Date begin, Date end, String description, Boolean onlineSubmissionsAllowed, Integer maxSubmissionsToKeep, Grouping grouping, GradeScale gradeScale, List<Department> departments) {
        if (name == null || begin == null || end == null) {
            throw new NullPointerException();
        }
        if (begin.after(end)) {
            throw new DomainException("error.evaluation.begin.sooner.end", new String[0]);
        }
        this.setName(name);
        this.setBegin(begin);
        this.setEnd(end);
        this.setGradeScale(gradeScale);
        this.setDescription(description != null ? description : "");
        if (!(this.getProjectSubmissionsSet().isEmpty() || this.getGrouping().equals((Object)grouping) && this.getOnlineSubmissionsAllowed().equals(onlineSubmissionsAllowed) && this.getMaxSubmissionsToKeep().equals(maxSubmissionsToKeep))) {
            throw new DomainException("error.project.onlineSubmissionOptionsCannotBeChangedBecauseSubmissionsAlreadyExist", new String[0]);
        }
        this.setOnlineSubmissionProperties(onlineSubmissionsAllowed, maxSubmissionsToKeep, grouping);
        Set departmentsList = this.getDeparmentsSet();
        departmentsList.clear();
        departmentsList.addAll(departments);
        this.logEdit();
    }

    private void setOnlineSubmissionProperties(Boolean onlineSubmissionsAllowed, Integer maxSubmissionsToKeep, Grouping grouping) {
        this.setOnlineSubmissionsAllowed(onlineSubmissionsAllowed);
        if (onlineSubmissionsAllowed.booleanValue()) {
            if (maxSubmissionsToKeep == null || maxSubmissionsToKeep == 0 || grouping == null) {
                throw new DomainException("error.project.maxSubmissionsAndGroupingRequiredForOnlineSubmissions", new String[0]);
            }
            this.setMaxSubmissionsToKeep(maxSubmissionsToKeep);
            this.setGrouping(grouping);
        } else {
            this.setMaxSubmissionsToKeep(null);
            this.setGrouping(null);
        }
    }

    public EvaluationType getEvaluationType() {
        return EvaluationType.PROJECT_TYPE;
    }

    @Deprecated
    public Date getBegin() {
        DateTime dt = this.getProjectBeginDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setBegin(Date date) {
        this.setProjectBeginDateTime(new DateTime(date.getTime()));
    }

    @Deprecated
    public Date getEnd() {
        DateTime dt = this.getProjectEndDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setEnd(Date date) {
        this.setProjectEndDateTime(new DateTime(date.getTime()));
    }

    public void setMaxSubmissionsToKeep(Integer maxSubmissionsToKeep) {
        if (maxSubmissionsToKeep != null && maxSubmissionsToKeep > 99) {
            throw new DomainException("error.project.maxSubmissionsToKeepMustBeLessThan", "99");
        }
        super.setMaxSubmissionsToKeep(maxSubmissionsToKeep);
    }

    public boolean canAddNewSubmissionWithoutExceedLimit(StudentGroup studentGroup) {
        return this.countProjectSubmissionsForStudentGroup(studentGroup) + 1 <= this.getMaxSubmissionsToKeep() && !studentGroup.wasDeleted();
    }

    public int countProjectSubmissionsForStudentGroup(StudentGroup studentGroup) {
        int count = 0;
        for (ProjectSubmission projectSubmission : this.getProjectSubmissionsSet()) {
            if (projectSubmission.getStudentGroup() != studentGroup) continue;
            ++count;
        }
        return count;
    }

    public boolean isSubmissionPeriodOpen() {
        DateTime currentDateTime = new DateTime();
        return currentDateTime.compareTo((ReadableInstant)this.getProjectBeginDateTime()) >= 0 && currentDateTime.compareTo((ReadableInstant)this.getProjectEndDateTime()) <= 0;
    }

    public boolean isCanComment() {
        for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
            Professorship professorship = executionCourse.getProfessorshipForCurrentUser();
            if (professorship == null) continue;
            return true;
        }
        return false;
    }

    public void delete() {
        if (!this.getProjectSubmissionsSet().isEmpty()) {
            throw new DomainException("error.project.cannotDeleteBecauseHasSubmissionsAssociated", new String[0]);
        }
        if (this.getProjectDepartmentGroup() != null) {
            throw new DomainException("error.project.cannotDeleteProjectUsedInAccessControl", new String[0]);
        }
        this.logRemove();
        this.setGrouping(null);
        this.getDeparmentsSet().clear();
        super.delete();
    }

    public List<ProjectSubmission> getProjectSubmissionsByStudentGroup(StudentGroup studentGroup) {
        ArrayList<ProjectSubmission> result = new ArrayList<ProjectSubmission>();
        for (ProjectSubmission projectSubmission : this.getProjectSubmissionsSet()) {
            if (projectSubmission.getStudentGroup() != studentGroup) continue;
            result.add(projectSubmission);
        }
        return result;
    }

    public ProjectSubmission getOldestProjectSubmissionForStudentGroup(StudentGroup studentGroup) {
        ProjectSubmission oldestProjectSubmission = null;
        for (ProjectSubmission projectSubmission : this.getProjectSubmissionsByStudentGroup(studentGroup)) {
            if (oldestProjectSubmission == null) {
                oldestProjectSubmission = projectSubmission;
                continue;
            }
            if (projectSubmission.getSubmissionDateTime().compareTo((ReadableInstant)oldestProjectSubmission.getSubmissionDateTime()) >= 0) continue;
            oldestProjectSubmission = projectSubmission;
        }
        return oldestProjectSubmission;
    }

    public Collection<ProjectSubmission> getLastProjectSubmissionForEachStudentGroup() {
        HashMap<StudentGroup, ProjectSubmission> lastProjectSubmissionByStudentGroup = new HashMap<StudentGroup, ProjectSubmission>();
        for (ProjectSubmission projectSubmission : this.getProjectSubmissionsSet()) {
            StudentGroup studentGroup = projectSubmission.getStudentGroup();
            if (studentGroup.wasDeleted()) continue;
            ProjectSubmission lastProjectSubmission = (ProjectSubmission)((Object)lastProjectSubmissionByStudentGroup.get((Object)studentGroup));
            if (lastProjectSubmission == null) {
                lastProjectSubmissionByStudentGroup.put(studentGroup, projectSubmission);
                continue;
            }
            if (projectSubmission.getSubmissionDateTime().compareTo((ReadableInstant)lastProjectSubmission.getSubmissionDateTime()) <= 0) continue;
            lastProjectSubmissionByStudentGroup.put(studentGroup, projectSubmission);
        }
        return lastProjectSubmissionByStudentGroup.values();
    }

    public Collection<ProjectSubmission> getLastProjectSubmissionForEachDeletedStudentGroup() {
        HashMap<StudentGroup, ProjectSubmission> lastProjectSubmissionByStudentGroup = new HashMap<StudentGroup, ProjectSubmission>();
        for (ProjectSubmission projectSubmission : this.getProjectSubmissionsSet()) {
            StudentGroup studentGroup = projectSubmission.getStudentGroup();
            if (!studentGroup.wasDeleted()) continue;
            ProjectSubmission lastProjectSubmission = (ProjectSubmission)((Object)lastProjectSubmissionByStudentGroup.get((Object)studentGroup));
            if (lastProjectSubmission == null) {
                lastProjectSubmissionByStudentGroup.put(studentGroup, projectSubmission);
                continue;
            }
            if (projectSubmission.getSubmissionDateTime().compareTo((ReadableInstant)lastProjectSubmission.getSubmissionDateTime()) <= 0) continue;
            lastProjectSubmissionByStudentGroup.put(studentGroup, projectSubmission);
        }
        return lastProjectSubmissionByStudentGroup.values();
    }

    public ProjectSubmission getLastProjectSubmissionForStudentGroup(StudentGroup group) {
        for (ProjectSubmission projectSubmission : this.getLastProjectSubmissionForEachStudentGroup()) {
            if (!projectSubmission.getStudentGroup().equals((Object)group)) continue;
            return projectSubmission;
        }
        return null;
    }

    public List<ProjectSubmissionLog> getProjectSubmissionLogsByStudentGroup(StudentGroup studentGroup) {
        ArrayList<ProjectSubmissionLog> result = new ArrayList<ProjectSubmissionLog>();
        for (ProjectSubmissionLog projectSubmissionLog : this.getProjectSubmissionLogsSet()) {
            if (projectSubmissionLog.getStudentGroup() != studentGroup) continue;
            result.add(projectSubmissionLog);
        }
        return result;
    }

    public List<EvaluationEventBean> getAllEvents(ExecutionCourse executionCourse) {
        ArrayList<EvaluationEventBean> result = new ArrayList<EvaluationEventBean>();
        result.add(new EvaluationEventBean("Inicio " + this.getName() + " : " + executionCourse.getNome(), this.getProjectBeginDateTime(), this.getProjectBeginDateTime().plusHours(1), false, null, null, this.getDescription(), Collections.singleton(executionCourse)));
        if (this.getOnlineSubmissionsAllowed().booleanValue()) {
            String url = CoreConfiguration.getConfiguration().applicationUrl() + "/login";
            result.add(new EvaluationEventBean("Fim " + this.getName() + " : " + executionCourse.getNome(), this.getProjectEndDateTime().minusHours(1), this.getProjectEndDateTime(), false, null, url, this.getDescription(), Collections.singleton(executionCourse)));
        } else {
            result.add(new EvaluationEventBean("Fim " + this.getName() + " : " + executionCourse.getNome(), this.getProjectEndDateTime().minusHours(1), this.getProjectEndDateTime(), false, null, null, this.getDescription(), Collections.singleton(executionCourse)));
        }
        return result;
    }

    @Deprecated
    public Date getProjectBegin() {
        DateTime dt = this.getProjectBeginDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setProjectBegin(Date date) {
        if (date == null) {
            this.setProjectBeginDateTime(null);
        } else {
            this.setProjectBeginDateTime(new DateTime(date.getTime()));
        }
    }

    @Deprecated
    public Date getProjectEnd() {
        DateTime dt = this.getProjectEndDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setProjectEnd(Date date) {
        if (date == null) {
            this.setProjectEndDateTime(null);
        } else {
            this.setProjectEndDateTime(new DateTime(date.getTime()));
        }
    }

    public String getPresentationName() {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.project", (String[])new String[0]) + " " + this.getName();
    }

    public Date getEvaluationDate() {
        return this.getBegin();
    }

    static {
        Project.getRelationProjectGrouping().addListener((RelationListener)new RelationAdapter<Project, Grouping>(){

            public void afterAdd(Project project, Grouping grouping) {
                if (project != null && grouping != null && grouping.getAutomaticEnrolment().booleanValue() && grouping.getStudentGroupsSet().isEmpty()) {
                    int groupCount = 0;
                    for (ExecutionCourse executionCourse : project.getAssociatedExecutionCoursesSet()) {
                        for (Attends attend : executionCourse.getAttendsSet()) {
                            try {
                                GroupEnrolment.run(grouping.getExternalId(), null, ++groupCount, new ArrayList<String>(), attend.getRegistration().getStudent().getPerson().getUsername());
                            }
                            catch (FenixServiceException e) {
                                logger.error(e.getMessage(), (Throwable)e);
                                --groupCount;
                            }
                        }
                    }
                    grouping.setGroupMaximumNumber(groupCount);
                }
            }
        });
    }
}

