/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.lang.annotation.Annotation;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Attends$callable$deleteShiftEnrolments;
import org.fenixedu.academic.domain.Attends_Base;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.FinalMark;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.Mark;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.GroupEnrolment;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.WeeklyWorkLoad;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Interval;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class Attends
extends Attends_Base {
    public static final Comparator<Attends> COMPARATOR_BY_STUDENT_NUMBER;
    public static final Comparator<Attends> ATTENDS_COMPARATOR;
    public static final Comparator<Attends> ATTENDS_COMPARATOR_BY_EXECUTION_COURSE_NAME;
    public static final Advice advice$deleteShiftEnrolments;

    public Attends() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Attends(Registration registration, ExecutionCourse executionCourse) {
        this();
        Student student = registration.getStudent();
        if (student.hasAttends(executionCourse)) {
            throw new DomainException("error.cannot.create.multiple.enrolments.for.student.in.execution.course", executionCourse.getNome(), executionCourse.getExecutionPeriod().getQualifiedName());
        }
        this.setRegistration(registration);
        this.setDisciplinaExecucao(executionCourse);
    }

    public void delete() throws DomainException {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        while (!this.getWeeklyWorkLoadsSet().isEmpty()) {
            ((WeeklyWorkLoad)this.getWeeklyWorkLoadsSet().iterator().next()).delete();
        }
        this.getProjectSubmissionLogsSet().clear();
        this.getGroupingsSet().clear();
        this.setAluno(null);
        this.setDisciplinaExecucao(null);
        this.setEnrolment(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public Collection<StudentGroup> getAllStudentGroups() {
        return super.getStudentGroupsSet();
    }

    public Set<StudentGroup> getStudentGroupsSet() {
        HashSet<StudentGroup> result = new HashSet<StudentGroup>();
        for (StudentGroup sg : super.getStudentGroupsSet()) {
            if (!sg.getValid().booleanValue()) continue;
            result.add(sg);
        }
        return Collections.unmodifiableSet(result);
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (this.hasAnyShiftEnrolments()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.attends.cant.delete", (String[])new String[0]));
        }
        if (!this.getStudentGroupsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.attends.cant.delete.has.student.groups", (String[])new String[0]));
        }
        if (!this.getAssociatedMarksSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.attends.cant.delete.has.associated.marks", (String[])new String[0]));
        }
        if (!this.getProjectSubmissionsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.attends.cant.delete.has.project.submissions", (String[])new String[0]));
        }
    }

    public boolean isAbleToBeRemoved() {
        try {
            this.getRegistration().checkIfHasEnrolmentFor(this);
            this.getRegistration().checkIfHasShiftsFor(this.getExecutionCourse());
        }
        catch (DomainException e) {
            return false;
        }
        return this.getDeletionBlockers().isEmpty();
    }

    public boolean hasAnyShiftEnrolments() {
        for (Shift shift : this.getExecutionCourse().getAssociatedShifts()) {
            if (!shift.getStudentsSet().contains((Object)this.getRegistration())) continue;
            return true;
        }
        return false;
    }

    public boolean hasAllShiftEnrolments() {
        if (this.getExecutionCourse().getAssociatedShifts().size() == 0) {
            return true;
        }
        Set<ShiftType> shiftTypes = this.getExecutionCourse().getShiftTypes();
        HashSet<ShiftType> foundShiftTypes = new HashSet<ShiftType>();
        for (Shift shift : this.getExecutionCourse().getAssociatedShifts()) {
            if (!shift.getStudentsSet().contains((Object)this.getRegistration())) continue;
            foundShiftTypes.addAll(shift.getTypes());
        }
        return foundShiftTypes.size() == shiftTypes.size();
    }

    public FinalMark getFinalMark() {
        for (Mark mark : this.getAssociatedMarksSet()) {
            if (!(mark instanceof FinalMark)) continue;
            return (FinalMark)((Object)mark);
        }
        return null;
    }

    public Mark getMarkByEvaluation(Evaluation evaluation) {
        for (Mark mark : this.getAssociatedMarksSet()) {
            if (!mark.getEvaluation().equals((Object)evaluation)) continue;
            return mark;
        }
        return null;
    }

    public List<Mark> getAssociatedMarksOrderedByEvaluationDate() {
        List<Evaluation> orderedEvaluations = this.getExecutionCourse().getOrderedAssociatedEvaluations();
        ArrayList<Mark> orderedMarks = new ArrayList<Mark>(orderedEvaluations.size());
        for (int i = 0; i < orderedEvaluations.size(); ++i) {
            orderedMarks.add(null);
        }
        for (Mark mark : this.getAssociatedMarksSet()) {
            Evaluation evaluation = mark.getEvaluation();
            orderedMarks.set(orderedEvaluations.indexOf((Object)evaluation), mark);
        }
        return orderedMarks;
    }

    public WeeklyWorkLoad createWeeklyWorkLoad(Integer contact, Integer autonomousStudy, Integer other) {
        WeeklyWorkLoad lastExistentWeeklyWorkLoad;
        if (contact < 0 || autonomousStudy < 0 || other < 0) {
            throw new DomainException("weekly.work.load.creation.invalid.data", new String[0]);
        }
        if (this.getEnrolment() == null) {
            throw new DomainException("weekly.work.load.creation.requires.enrolment", new String[0]);
        }
        int currentWeekOffset = this.calculateCurrentWeekOffset();
        if (currentWeekOffset < 1 || new YearMonthDay((Object)this.getEndOfExamsPeriod()).plusDays(Lesson.NUMBER_OF_DAYS_IN_WEEK).isBefore((ReadablePartial)new YearMonthDay())) {
            throw new DomainException("outside.weekly.work.load.response.period", new String[0]);
        }
        int previousWeekOffset = currentWeekOffset - 1;
        WeeklyWorkLoad weeklyWorkLoad = lastExistentWeeklyWorkLoad = this.getWeeklyWorkLoadsSet().isEmpty() ? null : (WeeklyWorkLoad)Collections.max(this.getWeeklyWorkLoadsSet());
        if (lastExistentWeeklyWorkLoad != null && lastExistentWeeklyWorkLoad.getWeekOffset() == previousWeekOffset) {
            throw new DomainException("weekly.work.load.for.previous.week.already.exists", new String[0]);
        }
        return new WeeklyWorkLoad(this, previousWeekOffset, contact, autonomousStudy, other);
    }

    public Interval getWeeklyWorkLoadInterval() {
        DateTime beginningOfSemester = new DateTime((Object)this.getBegginingOfLessonPeriod());
        DateTime firstMonday = beginningOfSemester.withField(DateTimeFieldType.dayOfWeek(), 1);
        DateTime endOfSemester = new DateTime((Object)this.getEndOfExamsPeriod());
        DateTime nextLastMonday = endOfSemester.withField(DateTimeFieldType.dayOfWeek(), 1).plusWeeks(1);
        return new Interval((ReadableInstant)firstMonday, (ReadableInstant)nextLastMonday);
    }

    public WeeklyWorkLoad getWeeklyWorkLoadOfPreviousWeek() {
        int currentWeekOffset = this.calculateCurrentWeekOffset();
        if (currentWeekOffset < 1 || new YearMonthDay((Object)this.getEndOfExamsPeriod()).plusDays(Lesson.NUMBER_OF_DAYS_IN_WEEK).isBefore((ReadablePartial)new YearMonthDay())) {
            throw new DomainException("outside.weekly.work.load.response.period", new String[0]);
        }
        int previousWeekOffset = currentWeekOffset - 1;
        for (WeeklyWorkLoad weeklyWorkLoad : this.getWeeklyWorkLoadsSet()) {
            if (weeklyWorkLoad.getWeekOffset() != previousWeekOffset) continue;
            return weeklyWorkLoad;
        }
        return null;
    }

    public Interval getCurrentWeek() {
        DateMidnight beginningOfSemester = new DateMidnight((Object)this.getBegginingOfLessonPeriod());
        DateMidnight firstMonday = beginningOfSemester.withField(DateTimeFieldType.dayOfWeek(), 1);
        int currentWeek = this.calculateCurrentWeekOffset();
        DateMidnight start = firstMonday.plusWeeks(currentWeek);
        return new Interval((ReadableInstant)start, (ReadableInstant)start.plusWeeks(1));
    }

    public Interval getPreviousWeek() {
        DateMidnight thisMonday = new DateMidnight().withField(DateTimeFieldType.dayOfWeek(), 1);
        DateMidnight previousMonday = thisMonday.minusWeeks(1);
        return new Interval((ReadableInstant)previousMonday, (ReadableInstant)thisMonday);
    }

    public Interval getResponseWeek() {
        DateMidnight beginningOfSemester = new DateMidnight((Object)this.getBegginingOfLessonPeriod());
        DateMidnight firstMonday = beginningOfSemester.withField(DateTimeFieldType.dayOfWeek(), 1);
        DateMidnight secondMonday = firstMonday.plusWeeks(1);
        DateMidnight endOfSemester = new DateMidnight((Object)this.getEndOfExamsPeriod());
        DateMidnight lastMonday = endOfSemester.withField(DateTimeFieldType.dayOfWeek(), 1);
        DateMidnight endOfResponsePeriod = lastMonday.plusWeeks(2);
        return (secondMonday.isEqualNow() || secondMonday.isBeforeNow()) && endOfResponsePeriod.isAfterNow() ? this.getPreviousWeek() : null;
    }

    public int getCalculatePreviousWeek() {
        return this.calculateCurrentWeekOffset();
    }

    public int calculateCurrentWeekOffset() {
        DateMidnight beginningOfLessonPeriod = new DateMidnight((Object)this.getBegginingOfLessonPeriod());
        DateMidnight firstMonday = beginningOfLessonPeriod.withField(DateTimeFieldType.dayOfWeek(), 1);
        DateMidnight thisMonday = new DateMidnight().withField(DateTimeFieldType.dayOfWeek(), 1);
        Interval interval = new Interval((ReadableInstant)firstMonday, (ReadableInstant)thisMonday);
        return interval.toPeriod(PeriodType.weeks()).getWeeks();
    }

    public Set<WeeklyWorkLoad> getSortedWeeklyWorkLoads() {
        return new TreeSet<WeeklyWorkLoad>(this.getWeeklyWorkLoadsSet());
    }

    public int getWeeklyWorkLoadContact() {
        int result = 0;
        for (WeeklyWorkLoad weeklyWorkLoad : this.getWeeklyWorkLoadsSet()) {
            int contact = weeklyWorkLoad.getContact() != null ? weeklyWorkLoad.getContact() : 0;
            result += contact;
        }
        return result;
    }

    public int getWeeklyWorkLoadAutonomousStudy() {
        int result = 0;
        for (WeeklyWorkLoad weeklyWorkLoad : this.getWeeklyWorkLoadsSet()) {
            int contact = weeklyWorkLoad.getAutonomousStudy() != null ? weeklyWorkLoad.getAutonomousStudy() : 0;
            result += contact;
        }
        return result;
    }

    public int getWeeklyWorkLoadOther() {
        int result = 0;
        for (WeeklyWorkLoad weeklyWorkLoad : this.getWeeklyWorkLoadsSet()) {
            int contact = weeklyWorkLoad.getOther() != null ? weeklyWorkLoad.getOther() : 0;
            result += contact;
        }
        return result;
    }

    public int getWeeklyWorkLoadTotal() {
        int result = 0;
        for (WeeklyWorkLoad weeklyWorkLoad : this.getWeeklyWorkLoadsSet()) {
            int contact = weeklyWorkLoad.getTotal();
            result += contact;
        }
        return result;
    }

    public Date getBegginingOfLessonPeriod() {
        ExecutionSemester executionSemester = this.getExecutionCourse().getExecutionPeriod();
        StudentCurricularPlan studentCurricularPlan = this.getEnrolment().getStudentCurricularPlan();
        ExecutionDegree executionDegree = studentCurricularPlan.getDegreeCurricularPlan().getExecutionDegreeByYear(executionSemester.getExecutionYear());
        if (executionSemester.getSemester() == 1) {
            return executionDegree.getPeriodLessonsFirstSemester().getStart();
        }
        if (executionSemester.getSemester() == 2) {
            return executionDegree.getPeriodLessonsSecondSemester().getStart();
        }
        throw new DomainException("unsupported.execution.period.semester", new String[0]);
    }

    public Date getEndOfExamsPeriod() {
        ExecutionSemester executionSemester = this.getExecutionCourse().getExecutionPeriod();
        StudentCurricularPlan studentCurricularPlan = this.getEnrolment().getStudentCurricularPlan();
        ExecutionDegree executionDegree = studentCurricularPlan.getDegreeCurricularPlan().getExecutionDegreeByYear(executionSemester.getExecutionYear());
        if (executionSemester.getSemester() == 1) {
            return executionDegree.getPeriodExamsFirstSemester().getEnd();
        }
        if (executionSemester.getSemester() == 2) {
            return executionDegree.getPeriodExamsSecondSemester().getEnd();
        }
        throw new DomainException("unsupported.execution.period.semester", new String[0]);
    }

    public boolean isFor(ExecutionSemester executionSemester) {
        return this.getExecutionCourse().getExecutionPeriod() == executionSemester;
    }

    public boolean isFor(ExecutionCourse executionCourse) {
        return this.getExecutionCourse() == executionCourse;
    }

    public boolean isFor(ExecutionYear executionYear) {
        return this.getExecutionCourse().getExecutionYear() == executionYear;
    }

    public boolean isFor(Shift shift) {
        return this.isFor(shift.getExecutionCourse());
    }

    public boolean isFor(Student student) {
        return this.getRegistration().getStudent().equals((Object)student);
    }

    public boolean isFor(Registration registration) {
        return this.getRegistration().equals((Object)registration);
    }

    @Deprecated
    public Registration getAluno() {
        return this.getRegistration();
    }

    public Registration getRegistration() {
        return super.getAluno();
    }

    @Deprecated
    public void setAluno(Registration registration) {
        this.setRegistration(registration);
    }

    public boolean hasRegistration() {
        return super.getAluno() != null;
    }

    public void setRegistration(Registration registration) {
        if (this.hasRegistration() && registration != null && this.getRegistration() != registration) {
            this.getRegistration().changeShifts(this, registration);
        }
        super.setAluno(registration);
    }

    @Deprecated
    public ExecutionCourse getDisciplinaExecucao() {
        return this.getExecutionCourse();
    }

    public ExecutionCourse getExecutionCourse() {
        return super.getDisciplinaExecucao();
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.getExecutionCourse().getExecutionPeriod();
    }

    public ExecutionYear getExecutionYear() {
        return this.getExecutionPeriod().getExecutionYear();
    }

    public void removeShifts() {
        for (Shift shift : this.getRegistration().getShiftsSet()) {
            if (shift.getExecutionCourse() != this.getExecutionCourse()) continue;
            this.getRegistration().removeShifts(shift);
        }
    }

    public boolean hasAnyAssociatedMarkSheetOrFinalGrade() {
        return this.getEnrolment().hasAnyAssociatedMarkSheetOrFinalGrade();
    }

    public StudentCurricularPlan getStudentCurricularPlanFromAttends() {
        Enrolment enrolment = this.getEnrolment();
        return enrolment == null ? this.getRegistration().getLastStudentCurricularPlan() : enrolment.getStudentCurricularPlan();
    }

    public StudentAttendsStateType getAttendsStateType() {
        if (this.getEnrolment() == null) {
            return StudentAttendsStateType.NOT_ENROLED;
        }
        if (!this.getEnrolment().getExecutionPeriod().equals(this.getExecutionPeriod()) && this.getEnrolment().hasImprovementFor(this.getExecutionPeriod())) {
            return StudentAttendsStateType.IMPROVEMENT;
        }
        if (this.getEnrolment().isValid(this.getExecutionPeriod())) {
            if (this.getEnrolment().hasSpecialSeason()) {
                return StudentAttendsStateType.SPECIAL_SEASON;
            }
            return StudentAttendsStateType.ENROLED;
        }
        return null;
    }

    public StudentGroup getStudentGroupByGrouping(Grouping grouping) {
        for (StudentGroup studentGroup : this.getStudentGroupsSet()) {
            if (!studentGroup.getGrouping().equals((Object)grouping)) continue;
            return studentGroup;
        }
        return null;
    }

    public boolean hasExecutionCourseTo(DegreeCurricularPlan degreeCurricularPlan) {
        for (CurricularCourse curricularCourse : this.getExecutionCourse().getAssociatedCurricularCoursesSet()) {
            if (!degreeCurricularPlan.hasDegreeModule((DegreeModule)((Object)curricularCourse))) continue;
            return true;
        }
        return false;
    }

    public boolean hasExecutionCourseTo(StudentCurricularPlan studentCurricularPlan) {
        return this.hasExecutionCourseTo(studentCurricularPlan.getDegreeCurricularPlan());
    }

    boolean canMove(StudentCurricularPlan from, StudentCurricularPlan to) {
        if (this.getEnrolment() != null) {
            return !from.hasEnrolments(this.getEnrolment()) && to.hasEnrolments(this.getEnrolment());
        }
        return !this.getExecutionPeriod().isBefore(to.getStartExecutionPeriod());
    }

    public void deleteShiftEnrolments() {
        Object object = advice$deleteShiftEnrolments.perform((Callable)new Attends$callable$deleteShiftEnrolments(this));
    }

    static /* synthetic */ void advised$deleteShiftEnrolments(Attends this_) {
        Registration registration = this_.getRegistration();
        ExecutionCourse executionCourse = this_.getExecutionCourse();
        for (Shift shift : executionCourse.getAssociatedShifts()) {
            shift.removeStudents(registration);
        }
    }

    static {
        advice$deleteShiftEnrolments = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        Attends.getRelationExecutionCourseAttends().addListener((RelationListener)new RelationAdapter<ExecutionCourse, Attends>(){

            public void afterAdd(ExecutionCourse executionCourse, Attends attends) {
                if (executionCourse != null && attends != null) {
                    for (Grouping grouping : executionCourse.getGroupings()) {
                        StudentGroup studentGroup;
                        if (!grouping.getAutomaticEnrolment().booleanValue() || grouping.getStudentGroupsSet().isEmpty()) continue;
                        grouping.addAttends(attends);
                        int groupNumber = 1;
                        ArrayList<StudentGroup> studentGroups = new ArrayList<StudentGroup>(grouping.getStudentGroupsSet());
                        Collections.sort(studentGroups, StudentGroup.COMPARATOR_BY_GROUP_NUMBER);
                        Iterator iterator = studentGroups.iterator();
                        while (iterator.hasNext() && (studentGroup = (StudentGroup)((Object)iterator.next())).getGroupNumber() <= groupNumber) {
                            groupNumber = studentGroup.getGroupNumber() + 1;
                        }
                        grouping.setGroupMaximumNumber(grouping.getStudentGroupsSet().size() + 1);
                        try {
                            GroupEnrolment.enrole(grouping.getExternalId(), null, groupNumber, new ArrayList<String>(), attends.getRegistration().getStudent().getPerson().getUsername());
                        }
                        catch (FenixServiceException e) {
                            throw new Error(e);
                        }
                    }
                }
            }
        });
        COMPARATOR_BY_STUDENT_NUMBER = new Comparator<Attends>(){

            @Override
            public int compare(Attends attends1, Attends attends2) {
                Integer n2;
                Integer n1 = attends1.getRegistration().getStudent().getNumber();
                int res = n1.compareTo(n2 = attends2.getRegistration().getStudent().getNumber());
                return res != 0 ? res : DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)attends1, (DomainObject)attends2);
            }
        };
        ATTENDS_COMPARATOR = new Comparator<Attends>(){

            @Override
            public int compare(Attends attends1, Attends attends2) {
                ExecutionSemester executionPeriod2;
                ExecutionCourse executionCourse2;
                ExecutionCourse executionCourse1 = attends1.getExecutionCourse();
                if (executionCourse1 == (executionCourse2 = attends2.getExecutionCourse())) {
                    Registration registration1 = attends1.getRegistration();
                    Registration registration2 = attends2.getRegistration();
                    return registration1.getNumber().compareTo(registration2.getNumber());
                }
                ExecutionSemester executionPeriod1 = executionCourse1.getExecutionPeriod();
                if (executionPeriod1 == (executionPeriod2 = executionCourse2.getExecutionPeriod())) {
                    return executionCourse1.getNome().compareTo(executionCourse2.getNome());
                }
                return executionPeriod1.compareTo(executionPeriod2);
            }
        };
        ATTENDS_COMPARATOR_BY_EXECUTION_COURSE_NAME = new Comparator<Attends>(){

            @Override
            public int compare(Attends o1, Attends o2) {
                ExecutionCourse executionCourse1 = o1.getExecutionCourse();
                ExecutionCourse executionCourse2 = o2.getExecutionCourse();
                int c = Collator.getInstance().compare(executionCourse1.getNome(), executionCourse2.getNome());
                return c == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : c;
            }
        };
    }

    public static enum StudentAttendsStateType {
        ENROLED,
        NOT_ENROLED,
        IMPROVEMENT,
        SPECIAL_SEASON;


        public String getQualifiedName() {
            return StudentAttendsStateType.class.getSimpleName() + "." + this.name();
        }
    }
}

