/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.AlumniIdentityCheckRequest_Base;
import org.fenixedu.academic.domain.AlumniRequestType;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class AlumniIdentityCheckRequest
extends AlumniIdentityCheckRequest_Base {
    public AlumniIdentityCheckRequest(String contactEmail, String documentIdNumber, String fullName, YearMonthDay dateOfBirthYearMonthDay, String districtOfBirth, String districtSubdivisionOfBirth, String parishOfBirth, String socialSecurityNumber, String nameOfFather, String nameOfMother, AlumniRequestType requestType) {
        this.checkParameters(contactEmail, documentIdNumber, fullName, dateOfBirthYearMonthDay, districtOfBirth, districtSubdivisionOfBirth, parishOfBirth, socialSecurityNumber, nameOfFather, nameOfMother, requestType);
        this.setContactEmail(contactEmail.trim());
        this.setDocumentIdNumber(documentIdNumber.trim());
        this.setFullName(fullName.trim());
        this.setDateOfBirthYearMonthDay(dateOfBirthYearMonthDay);
        this.setDistrictOfBirth(districtOfBirth.trim());
        this.setDistrictSubdivisionOfBirth(districtSubdivisionOfBirth.trim());
        this.setParishOfBirth(parishOfBirth.trim());
        this.setSocialSecurityNumber(socialSecurityNumber);
        this.setNameOfFather(nameOfFather.trim());
        this.setNameOfMother(nameOfMother.trim());
        this.setCreationDateTime(new DateTime());
        this.setRequestType(requestType);
        this.setRequestToken(UUID.randomUUID());
        this.setRootDomainObject(Bennu.getInstance());
    }

    private void checkParameters(String contactEmail, String documentIdNumber, String fullName, YearMonthDay dateOfBirthYearMonthDay, String districtOfBirth, String districtSubdivisionOfBirth, String parishOfBirth, String socialSecurityNumber, String nameOfFather, String nameOfMother, AlumniRequestType requestType) {
        if (StringUtils.isEmpty((String)contactEmail)) {
            throw new DomainException("alumni.identity.request.contactEmail.null", new String[0]);
        }
        if (StringUtils.isEmpty((String)documentIdNumber)) {
            throw new DomainException("alumni.identity.request.documentIdNumber.null", new String[0]);
        }
        if (requestType == null) {
            throw new DomainException("alumni.identity.request.requestType.null", new String[0]);
        }
    }

    public static boolean hasPendingRequestsForDocumentNumber(String documentIdNumber) {
        for (AlumniIdentityCheckRequest request : Bennu.getInstance().getAlumniIdentityRequestSet()) {
            if (!request.getDocumentIdNumber().equals(documentIdNumber)) continue;
            return true;
        }
        return false;
    }

    public static Collection<AlumniIdentityCheckRequest> readPendingRequests() {
        ArrayList<AlumniIdentityCheckRequest> pendingRequests = new ArrayList<AlumniIdentityCheckRequest>();
        Set requests = Bennu.getInstance().getAlumniIdentityRequestSet();
        for (AlumniIdentityCheckRequest request : requests) {
            if (request.getApproved() != null) continue;
            pendingRequests.add(request);
        }
        return pendingRequests;
    }

    public static Object readClosedRequests() {
        ArrayList<AlumniIdentityCheckRequest> pendingRequests = new ArrayList<AlumniIdentityCheckRequest>();
        for (AlumniIdentityCheckRequest request : Bennu.getInstance().getAlumniIdentityRequestSet()) {
            if (request.getApproved() == null) continue;
            pendingRequests.add(request);
        }
        return pendingRequests;
    }

    public boolean isValid() {
        Person person = this.getAlumni().getStudent().getPerson();
        return !StringUtils.isEmpty((String)person.getName()) && person.getName().equals(this.getFullName()) && person.getDateOfBirthYearMonthDay().equals((Object)this.getDateOfBirthYearMonthDay()) && !StringUtils.isEmpty((String)person.getDistrictOfBirth()) && person.getDistrictOfBirth().equals(this.getDistrictOfBirth()) && !StringUtils.isEmpty((String)person.getDistrictSubdivisionOfBirth()) && person.getDistrictSubdivisionOfBirth().equals(this.getDistrictSubdivisionOfBirth()) && !StringUtils.isEmpty((String)person.getParishOfBirth()) && person.getParishOfBirth().equals(this.getParishOfBirth()) && !StringUtils.isEmpty((String)person.getSocialSecurityNumber()) && person.getSocialSecurityNumber().equals(this.getSocialSecurityNumber()) && !StringUtils.isEmpty((String)person.getNameOfFather()) && person.getNameOfFather().equals(this.getNameOfFather()) && !StringUtils.isEmpty((String)person.getNameOfMother()) && person.getNameOfMother().equals(this.getNameOfMother());
    }

    public void validate(Boolean approval) {
        this.setApproved(approval);
        this.setDecisionDateTime(new DateTime());
    }

    public void validate(Boolean approval, Person operator) {
        this.validate(approval);
        this.setOperator(operator);
    }

    @Deprecated
    public Date getDateOfBirth() {
        YearMonthDay ymd = this.getDateOfBirthYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setDateOfBirth(Date date) {
        if (date == null) {
            this.setDateOfBirthYearMonthDay(null);
        } else {
            this.setDateOfBirthYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getCreation() {
        DateTime dt = this.getCreationDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setCreation(Date date) {
        if (date == null) {
            this.setCreationDateTime(null);
        } else {
            this.setCreationDateTime(new DateTime(date.getTime()));
        }
    }

    @Deprecated
    public Date getDecision() {
        DateTime dt = this.getDecisionDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setDecision(Date date) {
        if (date == null) {
            this.setDecisionDateTime(null);
        } else {
            this.setDecisionDateTime(new DateTime(date.getTime()));
        }
    }
}

