/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.teacher;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.ui.struts.action.base.FenixAction;
import org.fenixedu.academic.ui.struts.action.teacher.TeacherApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=TeacherApplication.TeacherTeachingApp.class, path="manage-execution-course", titleKey="link.manage.executionCourse")
@Mapping(module="teacher", path="/showProfessorships")
@Forwards(value={@Forward(name="list", path="/teacher/listProfessorships.jsp")})
public class ShowProfessorshipsDA
extends FenixAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String executionPeriodIDString = request.getParameter("executionPeriodID");
        Object selectedExecutionPeriod = executionPeriodIDString == null ? ExecutionSemester.readActualExecutionSemester() : (executionPeriodIDString.isEmpty() ? null : (ExecutionSemester)FenixFramework.getDomainObject((String)executionPeriodIDString));
        request.setAttribute("executionPeriod", selectedExecutionPeriod);
        ArrayList<ExecutionCourse> executionCourses = new ArrayList<ExecutionCourse>();
        request.setAttribute("executionCourses", executionCourses);
        Person person = AccessControl.getPerson();
        TreeSet<ExecutionSemester> executionSemesters = new TreeSet<ExecutionSemester>((Comparator<ExecutionSemester>)Ordering.from(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR).reverse());
        if (person != null) {
            for (Professorship professorship : person.getProfessorshipsSet()) {
                ExecutionCourse executionCourse = professorship.getExecutionCourse();
                ExecutionSemester executionSemester = executionCourse.getExecutionPeriod();
                executionSemesters.add(executionSemester);
                if (selectedExecutionPeriod != null && selectedExecutionPeriod != executionSemester) continue;
                executionCourses.add(executionCourse);
            }
        }
        executionSemesters.add(ExecutionSemester.readActualExecutionSemester());
        request.setAttribute("semesters", executionSemesters);
        return mapping.findForward("list");
    }
}

