/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.teacher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionCourseLog;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.dto.teacher.executionCourse.SearchExecutionCourseLogBean;
import org.fenixedu.academic.ui.struts.action.teacher.ManageExecutionCourseDA;
import org.fenixedu.academic.ui.struts.action.teacher.executionCourse.ExecutionCourseBaseAction;
import org.fenixedu.academic.util.CollectionPager;
import org.fenixedu.academic.util.Month;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="teacher", path="/searchECLog", functionality=ManageExecutionCourseDA.class)
@Forwards(value={@Forward(name="viewLogSearch", path="/teacher/viewLogSearch.jsp")})
public class SearchExecutionCourseLogAction
extends ExecutionCourseBaseAction {
    public ActionForward prepareInit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionCourse executionCourse = this.getExecutionCourse(request);
        SearchExecutionCourseLogBean seclb = new SearchExecutionCourseLogBean(executionCourse);
        seclb.setExecutionCourseLogTypes(new ArrayList<ExecutionCourseLog.ExecutionCourseLogTypes>());
        request.setAttribute("searchBean", (Object)seclb);
        request.setAttribute("executionCourse", (Object)seclb.getExecutionCourse());
        return mapping.findForward("viewLogSearch");
    }

    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionCourse executionCourse = this.getExecutionCourse(request);
        SearchExecutionCourseLogBean seclb = this.readSearchBean(request, executionCourse);
        this.searchLogs(seclb);
        request.setAttribute("searchBean", (Object)seclb);
        request.setAttribute("executionCourse", (Object)seclb.getExecutionCourse());
        this.prepareAttendsCollectionPages(request, seclb, seclb.getExecutionCourse());
        return mapping.findForward("viewLogSearch");
    }

    private SearchExecutionCourseLogBean readSearchBean(HttpServletRequest request, ExecutionCourse executionCourse) {
        ExecutionCourse course = this.getExecutionCourse(request);
        if (course != null) {
            String months;
            String professorships;
            SearchExecutionCourseLogBean seclb = new SearchExecutionCourseLogBean(course);
            String viewPhoto = request.getParameter("viewPhoto");
            if (viewPhoto != null && viewPhoto.equalsIgnoreCase("true")) {
                seclb.setViewPhoto(true);
            } else {
                seclb.setViewPhoto(false);
            }
            String logTypes = request.getParameter("executionCourseLogTypes");
            if (logTypes != null) {
                ArrayList<ExecutionCourseLog.ExecutionCourseLogTypes> list = new ArrayList<ExecutionCourseLog.ExecutionCourseLogTypes>();
                for (String logType : logTypes.split(":")) {
                    list.add(ExecutionCourseLog.ExecutionCourseLogTypes.valueOf(logType));
                }
                seclb.setExecutionCourseLogTypes(list);
            }
            if ((professorships = request.getParameter("professorships")) != null) {
                ArrayList<Professorship> list = new ArrayList<Professorship>();
                for (String professorship : professorships.split(":")) {
                    list.add((Professorship)FenixFramework.getDomainObject((String)professorship));
                }
                seclb.setProfessorships(list);
            }
            if ((months = request.getParameter("months")) != null) {
                ArrayList<Month> list = new ArrayList<Month>();
                for (String month : months.split(":")) {
                    list.add(Month.fromInt(Integer.valueOf(month)));
                }
                seclb.setMonths(list);
            }
            return seclb;
        }
        return new SearchExecutionCourseLogBean(executionCourse);
    }

    private void prepareAttendsCollectionPages(HttpServletRequest request, SearchExecutionCourseLogBean seclb, ExecutionCourse executionCourse) {
        Collection<ExecutionCourseLog> ecLogs = seclb.getExecutionCourseLogs();
        ArrayList<ExecutionCourseLog> listECLogs = new ArrayList<ExecutionCourseLog>(ecLogs);
        Collections.sort(listECLogs, ExecutionCourseLog.COMPARATOR_BY_WHEN_DATETIME);
        int entriesPerPage = 20;
        CollectionPager<ExecutionCourseLog> pager = new CollectionPager<ExecutionCourseLog>(listECLogs, entriesPerPage);
        request.setAttribute("numberOfPages", (Object)(listECLogs.size() / entriesPerPage + 1));
        String pageParameter = request.getParameter("pageNumber");
        Integer page = StringUtils.isEmpty((String)pageParameter) ? Integer.valueOf(1) : Integer.valueOf(pageParameter);
        request.setAttribute("pageNumber", (Object)page);
        SearchExecutionCourseLogBean logPagesBean = new SearchExecutionCourseLogBean(executionCourse);
        this.searchLogs(logPagesBean);
        logPagesBean.setExecutionCourseLogs(pager.getPage(page));
        if (seclb.getViewPhoto().booleanValue()) {
            logPagesBean.setViewPhoto(true);
        }
        request.setAttribute("logPagesBean", (Object)logPagesBean);
    }

    private void searchLogs(SearchExecutionCourseLogBean bean) {
        Predicate<ExecutionCourseLog> filter = bean.getFilters();
        HashSet<ExecutionCourseLog> validLogs = new HashSet<ExecutionCourseLog>();
        for (ExecutionCourseLog log : bean.getExecutionCourse().getExecutionCourseLogsSet()) {
            if (!filter.test(log)) continue;
            validLogs.add(log);
        }
        bean.setExecutionCourseLogs(validLogs);
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SearchExecutionCourseLogBean bean = (SearchExecutionCourseLogBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        this.searchLogs(bean);
        request.setAttribute("searchBean", (Object)bean);
        request.setAttribute("executionCourse", (Object)bean.getExecutionCourse());
        this.prepareAttendsCollectionPages(request, bean, bean.getExecutionCourse());
        return mapping.findForward("viewLogSearch");
    }
}

