/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.casehandling;

import java.util.Collection;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.service.services.caseHandling.CreateNewProcess;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;

public abstract class CaseHandlingDispatchAction
extends FenixDispatchAction {
    protected abstract Class getProcessType();

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setProcessName(request);
        this.setProcess(request);
        return super.execute(mapping, actionForm, request, response);
    }

    protected void setProcessName(HttpServletRequest request) {
        request.setAttribute("processName", (Object)this.getProcessType().getSimpleName());
    }

    protected Process readProcess(HttpServletRequest request) {
        return (Process)this.getDomainObject(request, "processId");
    }

    protected void setProcess(HttpServletRequest request) {
        Process process2 = this.readProcess(request);
        if (process2 != null) {
            request.setAttribute("process", (Object)process2);
        }
    }

    protected Collection<Process> getAllowedProcessInstances(User userView) {
        TreeSet<Process> result = new TreeSet<Process>();
        for (Process process2 : rootDomainObject.getProcessesSet()) {
            if (!process2.getClass().equals(this.getProcessType()) || !process2.canExecuteActivity(userView)) continue;
            result.add(process2);
        }
        return result;
    }

    protected Process getProcess(HttpServletRequest request) {
        return (Process)request.getAttribute("process");
    }

    protected boolean hasProcess(HttpServletRequest request) {
        return this.getProcess(request) != null;
    }

    public ActionForward listProcesses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
        request.setAttribute("processes", this.getAllowedProcessInstances(Authenticate.getUser()));
        return mapping.findForward("list-processes");
    }

    protected Object canCreateProcess(String name) {
        try {
            Activity<?> startActivity = Process.getStartActivity(name);
            startActivity.checkPreConditions(null, Authenticate.getUser());
        }
        catch (PreConditionNotValidException e) {
            return false;
        }
        return true;
    }

    public ActionForward listProcessAllowedActivities(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Process process2 = this.getProcess(request);
        request.setAttribute("activities", process2.getAllowedActivities(Authenticate.getUser()));
        return mapping.findForward("list-allowed-activities");
    }

    public abstract ActionForward prepareCreateNewProcess(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4);

    public ActionForward createNewProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        Process process2 = CreateNewProcess.run(this.getProcessType().getName(), this.getRenderedObject());
        request.setAttribute("process", (Object)process2);
        return this.listProcessAllowedActivities(mapping, form, request, response);
    }

    protected void executeActivity(Process process2, String activityId) throws FenixServiceException {
        this.executeActivity(process2, activityId, null);
    }

    protected Process executeActivity(Process process2, String activityId, Object object) throws FenixServiceException {
        return ExecuteProcessActivity.run(process2, activityId, object);
    }
}

