/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.util.LabelValueBean;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.InfoStudentCurricularPlan;
import org.fenixedu.academic.dto.student.ExecutionPeriodStatisticsBean;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.commons.student.ReadStudentCurricularPlan;
import org.fenixedu.academic.service.services.commons.student.ReadStudentCurriculum;
import org.fenixedu.academic.service.services.exceptions.ExistingServiceException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.ui.renderers.student.curriculum.StudentCurricularPlanRenderer;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.academic.ui.struts.action.exceptions.ExistingActionException;
import org.fenixedu.academic.util.StudentCurricularPlanIDDomainType;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/viewStudentCurriculum", module="academicAdministration", formBean="studentCurricularPlanAndEnrollmentsSelectionForm", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="ShowStudentCurriculum", path="/student/curriculum/displayStudentCurriculum_bd.jsp"), @Forward(name="ShowStudentCurriculumForCoordinator", path="/student/curriculum/displayStudentCurriculum_bd.jsp"), @Forward(name="NotAuthorized", path="/student/notAuthorized_bd.jsp")})
public class CurriculumDispatchAction
extends FenixDispatchAction {
    private static final Logger logger = LoggerFactory.getLogger(CurriculumDispatchAction.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        return super.execute(mapping, actionForm, request, response);
    }

    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RenderUtils.invalidateViewState();
        Registration registration = null;
        String registrationOID = this.getRegistrationOID(request);
        Student loggedStudent = CurriculumDispatchAction.getUserView(request).getPerson().getStudent();
        if (registrationOID != null) {
            registration = (Registration)FenixFramework.getDomainObject((String)registrationOID);
        } else if (loggedStudent != null) {
            request.setAttribute("student", (Object)loggedStudent);
            List<Registration> validRegistrations = this.getValidRegistrations(loggedStudent);
            request.setAttribute("validRegistrations", validRegistrations);
            return mapping.findForward("chooseRegistration");
        }
        if (registration == null) {
            return mapping.findForward("NotAuthorized");
        }
        return this.getStudentCP(registration, mapping, (DynaActionForm)form, request);
    }

    private List<Registration> getValidRegistrations(Student loggedStudent) {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : loggedStudent.getRegistrationsSet()) {
            if (registration.isCanceled()) continue;
            result.add(registration);
        }
        return result;
    }

    private String getRegistrationOID(HttpServletRequest request) {
        String registrationOID = request.getParameter("registrationOID");
        if (registrationOID == null) {
            registrationOID = (String)request.getAttribute("registrationOID");
        }
        return registrationOID == null || registrationOID.equals("") ? null : registrationOID;
    }

    public ActionForward prepareReadByStudentNumber(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RenderUtils.invalidateViewState();
        DynaActionForm actionForm = (DynaActionForm)form;
        Registration registration = null;
        String degreeCurricularPlanId = (String)actionForm.get("degreeCurricularPlanID");
        Student student = this.getStudent(actionForm);
        if (student != null) {
            if (!StringUtils.isEmpty((String)degreeCurricularPlanId)) {
                DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanId);
                registration = student.readRegistrationByDegreeCurricularPlan(degreeCurricularPlan);
            } else {
                Set<Registration> registrations = student.getRegistrationsSet();
                if (!registrations.isEmpty()) {
                    registration = (Registration)((Object)registrations.iterator().next());
                }
            }
        }
        if (registration == null) {
            return mapping.findForward("NotAuthorized");
        }
        return this.getStudentCP(registration, mapping, actionForm, request);
    }

    private Student getStudent(DynaActionForm form) {
        Integer studentNumber = Integer.valueOf((String)form.get("studentNumber"));
        Student student = Student.readStudentByNumber(studentNumber);
        return student;
    }

    protected ActionForward getStudentCPForSupervisor(Registration registration, ActionMapping mapping, DynaActionForm actionForm, HttpServletRequest request) {
        return this.getStudentCP(registration, mapping, actionForm, request);
    }

    private ActionForward getStudentCP(Registration registration, ActionMapping mapping, DynaActionForm actionForm, HttpServletRequest request) {
        request.setAttribute("registration", (Object)registration);
        String studentCPID = this.getStudentCPID(request, actionForm);
        if (StringUtils.isEmpty((String)studentCPID)) {
            studentCPID = this.getDefaultStudentCPID(registration).getId().toString();
            actionForm.set("studentCPID", (Object)studentCPID);
        }
        request.setAttribute("selectedStudentCurricularPlans", this.getSelectedStudentCurricularPlans(registration, studentCPID));
        request.setAttribute("scpsLabelValueBeanList", this.getSCPsLabelValueBeanList(registration.getStudentCurricularPlansSet()));
        if (StringUtils.isEmpty((String)actionForm.getString("viewType"))) {
            actionForm.set("viewType", (Object)StudentCurricularPlanRenderer.ViewType.ALL.name());
        }
        if (StringUtils.isEmpty((String)actionForm.getString("select"))) {
            actionForm.set("select", (Object)(AcademicPredicates.VIEW_FULL_STUDENT_CURRICULUM.evaluate((Object)AccessControl.getPerson()) ? StudentCurricularPlanRenderer.EnrolmentStateFilterType.ALL.name() : StudentCurricularPlanRenderer.EnrolmentStateFilterType.APPROVED_OR_ENROLED.name()));
        }
        if (StringUtils.isEmpty((String)actionForm.getString("organizedBy"))) {
            String organizedBy = registration.getDegreeType().isPreBolonhaMasterDegree() ? StudentCurricularPlanRenderer.OrganizationType.EXECUTION_YEARS.name() : StudentCurricularPlanRenderer.OrganizationType.GROUPS.name();
            actionForm.set("organizedBy", (Object)organizedBy);
        }
        CurriculumDispatchAction.computeCurricularInfo(request, registration);
        if (StringUtils.isEmpty((String)request.getParameter("degreeCurricularPlanID"))) {
            return mapping.findForward("ShowStudentCurriculum");
        }
        request.setAttribute("degreeCurricularPlanID", (Object)request.getParameter("degreeCurricularPlanID"));
        return mapping.findForward("ShowStudentCurriculumForCoordinator");
    }

    private List<StudentCurricularPlan> getSelectedStudentCurricularPlans(Registration registration, String studentCPID) {
        StudentCurricularPlanIDDomainType scpIdType = new StudentCurricularPlanIDDomainType(studentCPID);
        List<StudentCurricularPlan> result = scpIdType.isNewest() ? Collections.singletonList(registration.getLastStudentCurricularPlan()) : (scpIdType.isAll() ? CurriculumDispatchAction.getSortedStudentCurricularPlans(registration) : Collections.singletonList(this.getStudentCurricularPlan(registration, studentCPID)));
        return result;
    }

    private StudentCurricularPlanIDDomainType getDefaultStudentCPID(Registration registration) {
        return registration.isBolonha() ? StudentCurricularPlanIDDomainType.NEWEST : StudentCurricularPlanIDDomainType.ALL;
    }

    private String getStudentCPID(HttpServletRequest request, DynaActionForm actionForm) {
        String result = request.getParameter("studentCPID");
        if (result == null) {
            result = (String)request.getAttribute("studentCPID");
        }
        if (result == null) {
            result = (String)actionForm.get("studentCPID");
        }
        return result;
    }

    private static List<StudentCurricularPlan> getSortedStudentCurricularPlans(Registration registration) {
        ArrayList<StudentCurricularPlan> result = new ArrayList<StudentCurricularPlan>();
        result.addAll(registration.getStudentCurricularPlansSet());
        Collections.sort(result, new BeanComparator("startDateYearMonthDay"));
        return result;
    }

    private StudentCurricularPlan getStudentCurricularPlan(Registration registration, String scpId) {
        for (StudentCurricularPlan studentCurricularPlan : registration.getStudentCurricularPlansSet()) {
            if (!studentCurricularPlan.getExternalId().equals(scpId)) continue;
            return studentCurricularPlan;
        }
        return null;
    }

    private List<LabelValueBean> getSCPsLabelValueBeanList(Collection<StudentCurricularPlan> studentCurricularPlans) {
        ArrayList<LabelValueBean> result = new ArrayList<LabelValueBean>();
        result.add(new LabelValueBean("Plano curricular mais recente", StudentCurricularPlanIDDomainType.NEWEST.toString()));
        result.add(new LabelValueBean("Todos os planos curriculares", StudentCurricularPlanIDDomainType.ALL.toString()));
        for (StudentCurricularPlan studentCurricularPlan : studentCurricularPlans) {
            StringBuilder label = new StringBuilder();
            label.append(studentCurricularPlan.getRegistration().getDegreeNameWithDescription());
            label.append(", ").append(studentCurricularPlan.getDegreeCurricularPlan().getName());
            if (studentCurricularPlan.getSpecialization() != null) {
                label.append(" - ").append(BundleUtil.getString((String)"resources.EnumerationResources", (String)studentCurricularPlan.getSpecialization().name(), (String[])new String[0]));
            }
            label.append(" - ").append(studentCurricularPlan.getStartDateYearMonthDay());
            result.add(new LabelValueBean(label.toString(), String.valueOf(studentCurricularPlan.getExternalId())));
        }
        return result;
    }

    public ActionForward getCurriculumForCoordinator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ExistingActionException, FenixServiceException {
        String degreeCurricularPlanID = null;
        if (request.getParameter("degreeCurricularPlanID") != null) {
            degreeCurricularPlanID = request.getParameter("degreeCurricularPlanID");
            request.setAttribute("degreeCurricularPlanID", (Object)degreeCurricularPlanID);
        }
        String studentCurricularPlanID = this.getStudentCPID(request, (DynaActionForm)form);
        String executionDegreeID = this.getExecutionDegree(request);
        List result = null;
        try {
            result = ReadStudentCurriculum.runReadStudentCurriculum(executionDegreeID, studentCurricularPlanID);
        }
        catch (NotAuthorizedException e) {
            return mapping.findForward("NotAuthorized");
        }
        catch (Exception exp) {
            logger.error(exp.getMessage(), (Throwable)exp);
            return null;
        }
        BeanComparator courseName = new BeanComparator("infoCurricularCourse.name");
        BeanComparator executionYear = new BeanComparator("infoExecutionPeriod.infoExecutionYear.year");
        ComparatorChain chainComparator = new ComparatorChain();
        chainComparator.addComparator((Comparator)courseName);
        chainComparator.addComparator((Comparator)executionYear);
        Collections.sort(result, chainComparator);
        InfoStudentCurricularPlan infoStudentCurricularPlan = null;
        try {
            infoStudentCurricularPlan = ReadStudentCurricularPlan.run(studentCurricularPlanID);
        }
        catch (ExistingServiceException e) {
            throw new ExistingActionException(e);
        }
        request.setAttribute("curriculum", (Object)result);
        request.setAttribute("student_curricular_plan", (Object)infoStudentCurricularPlan);
        return mapping.findForward("ShowStudentCurriculum");
    }

    private String getExecutionDegree(HttpServletRequest request) {
        String executionDegreeIdString = request.getParameter("executionDegreeId");
        if (executionDegreeIdString == null) {
            executionDegreeIdString = (String)request.getAttribute("executionDegreeId");
        }
        request.setAttribute("executionDegreeId", (Object)executionDegreeIdString);
        return executionDegreeIdString;
    }

    public static JsonObject computeCurricularInfo(HttpServletRequest request, Registration registration) {
        ArrayList studentStatistics = new ArrayList();
        HashMap<ExecutionSemester, ExecutionPeriodStatisticsBean> enrolmentsByExecutionPeriod = new HashMap<ExecutionSemester, ExecutionPeriodStatisticsBean>();
        for (StudentCurricularPlan studentCurricularPlan : CurriculumDispatchAction.getSortedStudentCurricularPlans(registration)) {
            for (ExecutionSemester executionSemester : studentCurricularPlan.getEnrolmentsExecutionPeriods()) {
                ExecutionPeriodStatisticsBean executionPeriodStatisticsBean;
                if (enrolmentsByExecutionPeriod.containsKey(executionSemester)) {
                    executionPeriodStatisticsBean = (ExecutionPeriodStatisticsBean)enrolmentsByExecutionPeriod.get(executionSemester);
                    executionPeriodStatisticsBean.addEnrolmentsWithinExecutionPeriod(studentCurricularPlan.getEnrolmentsByExecutionPeriod(executionSemester));
                    enrolmentsByExecutionPeriod.put(executionSemester, executionPeriodStatisticsBean);
                    continue;
                }
                executionPeriodStatisticsBean = new ExecutionPeriodStatisticsBean(executionSemester);
                executionPeriodStatisticsBean.addEnrolmentsWithinExecutionPeriod(studentCurricularPlan.getEnrolmentsByExecutionPeriod(executionSemester));
                enrolmentsByExecutionPeriod.put(executionSemester, executionPeriodStatisticsBean);
            }
        }
        studentStatistics.addAll(enrolmentsByExecutionPeriod.values());
        Collections.sort(studentStatistics, new BeanComparator("executionPeriod"));
        JsonObject curricularInfoJSONObject = new JsonObject();
        JsonArray periodsJSONArray = new JsonArray();
        for (ExecutionPeriodStatisticsBean executionPeriodStatisticsBean : studentStatistics) {
            JsonArray jsonArray = new JsonArray();
            jsonArray.add((JsonElement)new JsonPrimitive(executionPeriodStatisticsBean.getExecutionPeriod().getExecutionYear().getYear() + " - " + executionPeriodStatisticsBean.getExecutionPeriod().getSemester().toString() + "\u00ba sem"));
            jsonArray.add((JsonElement)new JsonPrimitive((Number)executionPeriodStatisticsBean.getTotalEnrolmentsNumber()));
            jsonArray.add((JsonElement)new JsonPrimitive((Number)executionPeriodStatisticsBean.getApprovedEnrolmentsNumber()));
            periodsJSONArray.add((JsonElement)jsonArray);
        }
        curricularInfoJSONObject.add("periods", (JsonElement)periodsJSONArray);
        request.setAttribute("registrationApprovalRateJSON", (Object)curricularInfoJSONObject);
        return curricularInfoJSONObject;
    }
}

