/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller.configuration;

import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.ui.spring.ControllerHelper;
import org.fenixedu.academic.ui.spring.controller.AcademicAdministrationSpringApplication;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.fenixframework.FenixFramework;

@SpringFunctionality(app=AcademicAdministrationSpringApplication.class, title="label.title.StatuteTypeManagement", accessGroup="#managers")
@RequestMapping(value={"/academic/configuration/statutes"})
public class StatuteTypeController {
    @RequestMapping
    public String list(Model model) {
        model.addAttribute("statutes", StatuteType.readAll(new Predicate[0]).sorted(StatuteType.COMPARATOR_BY_NAME).collect(Collectors.toList()));
        return "fenixedu-academic/configuration/statutes/search";
    }

    @RequestMapping(value={"/{statuteType}"})
    public String read(@PathVariable StatuteType statuteType, Model model) {
        model.addAttribute("statuteType", (Object)statuteType);
        return "fenixedu-academic/configuration/statutes/read";
    }

    @RequestMapping(value={"/{statuteType}/delete"}, method={RequestMethod.POST})
    public String delete(@PathVariable StatuteType statuteType, Model model, RedirectAttributes redirectAttributes) {
        try {
            FenixFramework.atomic(() -> statuteType.delete());
        }
        catch (DomainException ex) {
            ControllerHelper.addErrorMessage(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.studentStatute.delete", (String[])new String[0]) + ex.getMessage(), model);
            return "/academic/configuration/statutes/";
        }
        ControllerHelper.addInfoMessage(BundleUtil.getString((String)"resources.ApplicationResources", (String)"success.studentStatute.delete", (String[])new String[0]), model);
        return ControllerHelper.redirect("/academic/configuration/statutes/", model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        return "fenixedu-academic/configuration/statutes/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam String code, @RequestParam LocalizedString name, @RequestParam(required=false) boolean active, @RequestParam(required=false) boolean visible, @RequestParam(required=false) boolean specialSeasonGranted, @RequestParam(required=false) boolean explicitCreation, @RequestParam(required=false) boolean workingStudentStatute, @RequestParam(required=false) boolean associativeLeaderStatute, @RequestParam(required=false) boolean specialSeasonGrantedByRequest, @RequestParam(required=false) boolean grantOwnerStatute, @RequestParam(required=false) boolean seniorStatute, @RequestParam(required=false) boolean handicappedStatute, @RequestParam(required=false) boolean appliedOnRegistration, Model model) throws Exception {
        try {
            StatuteType statuteType = (StatuteType)((Object)FenixFramework.atomic(() -> new StatuteType(code, name, workingStudentStatute, associativeLeaderStatute, specialSeasonGrantedByRequest, grantOwnerStatute, seniorStatute, handicappedStatute, active, explicitCreation, visible, specialSeasonGranted, appliedOnRegistration)));
            return "redirect:/academic/configuration/statutes/" + statuteType.getExternalId();
        }
        catch (DomainException ex) {
            ControllerHelper.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.create(model);
        }
    }

    @RequestMapping(value={"/{statuteType}/edit"}, method={RequestMethod.GET})
    public String edit(@PathVariable StatuteType statuteType, Model model) {
        model.addAttribute("statuteType", (Object)statuteType);
        return "fenixedu-academic/configuration/statutes/update";
    }

    @RequestMapping(value={"/{statuteType}/edit"}, method={RequestMethod.POST})
    public String edit(@PathVariable StatuteType statuteType, @RequestParam String code, @RequestParam LocalizedString name, @RequestParam(required=false) boolean active, @RequestParam(required=false) boolean visible, @RequestParam(required=false) boolean specialSeasonGranted, @RequestParam(required=false) boolean explicitCreation, @RequestParam(required=false) boolean workingStudentStatute, @RequestParam(required=false) boolean associativeLeaderStatute, @RequestParam(required=false) boolean specialSeasonGrantedByRequest, @RequestParam(required=false) boolean grantOwnerStatute, @RequestParam(required=false) boolean seniorStatute, @RequestParam(required=false) boolean handicappedStatute, @RequestParam(required=false) boolean appliedOnRegistration, Model model, RedirectAttributes redirectAttributes) {
        try {
            FenixFramework.atomic(() -> {
                statuteType.setCode(code);
                statuteType.setName(name);
                statuteType.setActive(active);
                statuteType.setVisible(visible);
                statuteType.setSpecialSeasonGranted(specialSeasonGranted);
                statuteType.setExplicitCreation(explicitCreation);
                statuteType.setWorkingStudentStatute(workingStudentStatute);
                statuteType.setAssociativeLeaderStatute(associativeLeaderStatute);
                statuteType.setSpecialSeasonGrantedByRequest(specialSeasonGrantedByRequest);
                statuteType.setGrantOwnerStatute(grantOwnerStatute);
                statuteType.setSeniorStatute(seniorStatute);
                statuteType.setHandicappedStatute(handicappedStatute);
                statuteType.setAppliedOnRegistration(appliedOnRegistration);
            });
            return "redirect:/academic/configuration/statutes/" + statuteType.getExternalId();
        }
        catch (DomainException ex) {
            ControllerHelper.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.edit(statuteType, model);
        }
    }
}

