/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers;

import java.util.TreeSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degreeStructure.CurricularCourseFunctor;
import org.fenixedu.academic.domain.interfaces.HasExecutionYear;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class ExecutionDegreesWithDissertationByExecutionYearProvider
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        HasExecutionYear hasExecutionYear = (HasExecutionYear)source;
        TreeSet<ExecutionDegree> executionDegrees = new TreeSet<ExecutionDegree>(ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_DEGREE_TYPE_AND_NAME);
        ExecutionYear executionYear = hasExecutionYear.getExecutionYear();
        if (executionYear != null) {
            for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesSet()) {
                if (executionDegree.getDegreeCurricularPlan().isEmpty() || !this.hasDissertation(executionDegree)) continue;
                executionDegrees.add(executionDegree);
            }
        }
        return executionDegrees;
    }

    private boolean hasDissertation(ExecutionDegree executionDegree) {
        DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
        HasDissertationPredicate hasDissertationPredicate = new HasDissertationPredicate();
        degreeCurricularPlan.doForAllCurricularCourses(hasDissertationPredicate);
        return hasDissertationPredicate.hasDissertation;
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }

    private static class HasDissertationPredicate
    implements CurricularCourseFunctor {
        boolean hasDissertation = false;

        private HasDissertationPredicate() {
        }

        @Override
        public void doWith(CurricularCourse curricularCourse) {
            if (curricularCourse.isDissertation()) {
                this.hasDissertation = true;
            }
        }

        @Override
        public boolean keepDoing() {
            return !this.hasDissertation;
        }
    }
}

