/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.thesis;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisFile;
import org.fenixedu.academic.service.filter.student.thesis.ScientificCouncilOrStudentThesisAuthorizationFilter;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.thesis.CreateThesisDissertationFile$callable$runCreateThesisDissertationFile;
import org.fenixedu.academic.service.services.thesis.CreateThesisFile;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreateThesisDissertationFile
extends CreateThesisFile {
    private static final CreateThesisDissertationFile serviceInstance;
    public static final Advice advice$runCreateThesisDissertationFile;

    @Override
    protected void removePreviousFile(Thesis thesis) {
        ThesisFile dissertation = thesis.getDissertation();
        if (dissertation != null) {
            if (RoleType.SCIENTIFIC_COUNCIL.isMember(Authenticate.getUser().getPerson().getUser())) {
                dissertation.deleteWithoutStateCheck();
            } else {
                dissertation.delete();
            }
        }
    }

    @Override
    protected void updateThesis(Thesis thesis, ThesisFile file, String title, String subTitle, Locale language, String fileName, byte[] bytes) throws FenixServiceException, IOException {
        if (title == null) {
            throw new DomainException("thesis.files.dissertation.title.required", new String[0]);
        }
        file.setTitle(title);
        file.setSubTitle(subTitle == null ? "" : subTitle);
        file.setLanguage(language);
        thesis.setDissertation(file);
    }

    public static ThesisFile runCreateThesisDissertationFile(Thesis thesis, byte[] byArray, String string, String string2, String string3, Locale locale) throws FenixServiceException, IOException {
        return (ThesisFile)((Object)advice$runCreateThesisDissertationFile.perform((Callable)new CreateThesisDissertationFile$callable$runCreateThesisDissertationFile(thesis, byArray, string, string2, string3, locale)));
    }

    static /* synthetic */ ThesisFile advised$runCreateThesisDissertationFile(Thesis thesis, byte[] bytes, String fileName, String title, String subTitle, Locale language) throws FenixServiceException, IOException {
        ScientificCouncilOrStudentThesisAuthorizationFilter.instance.execute(thesis);
        return serviceInstance.run(thesis, bytes, fileName, title, subTitle, language);
    }

    static {
        advice$runCreateThesisDissertationFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new CreateThesisDissertationFile();
    }
}

