/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.resourceAllocationManager.exams;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ExamDateCertificateRequest;
import org.fenixedu.academic.service.filter.EditWrittenEvaluationAuthorization;
import org.fenixedu.academic.service.filter.ExecutionCourseCoordinatorAuthorizationFilter;
import org.fenixedu.academic.service.filter.ExecutionCourseLecturingTeacherAuthorizationFilter;
import org.fenixedu.academic.service.filter.ResourceAllocationManagerAuthorizationFilter;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.resourceAllocationManager.exams.DeleteWrittenEvaluation$callable$runDeleteWrittenEvaluation;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DeleteWrittenEvaluation {
    private static final DeleteWrittenEvaluation serviceInstance;
    public static final Advice advice$runDeleteWrittenEvaluation;

    protected void run(String executionCourseOID, String writtenEvaluationOID) throws FenixServiceException {
        WrittenEvaluation writtenEvaluationToDelete = (WrittenEvaluation)FenixFramework.getDomainObject((String)writtenEvaluationOID);
        if (writtenEvaluationToDelete == null) {
            throw new FenixServiceException("error.noWrittenEvaluation");
        }
        if (writtenEvaluationToDelete instanceof Exam) {
            this.disconnectExamCertificateRequests(writtenEvaluationToDelete);
        }
        Signal.emit((String)"academic.writtenevaluation.deleted", (Object)new DomainObjectEvent((DomainObject)writtenEvaluationToDelete));
        writtenEvaluationToDelete.delete();
    }

    private void disconnectExamCertificateRequests(WrittenEvaluation writtenEvaluationToDelete) {
        Exam examToDelete = (Exam)((Object)writtenEvaluationToDelete);
        for (ExamDateCertificateRequest examDateCertificateRequest : examToDelete.getExamDateCertificateRequestsSet()) {
            examDateCertificateRequest.removeExams(examToDelete);
        }
    }

    public static void runDeleteWrittenEvaluation(String string, String string2) throws FenixServiceException, NotAuthorizedException {
        Object object = advice$runDeleteWrittenEvaluation.perform((Callable)new DeleteWrittenEvaluation$callable$runDeleteWrittenEvaluation(string, string2));
    }

    static /* synthetic */ void advised$runDeleteWrittenEvaluation(String executionCourseOID, String writtenEvaluationOID) throws FenixServiceException, NotAuthorizedException {
        EditWrittenEvaluationAuthorization.instance.execute(writtenEvaluationOID);
        try {
            ResourceAllocationManagerAuthorizationFilter.instance.execute();
            serviceInstance.run(executionCourseOID, writtenEvaluationOID);
        }
        catch (NotAuthorizedException ex1) {
            try {
                ExecutionCourseLecturingTeacherAuthorizationFilter.instance.execute(executionCourseOID);
                serviceInstance.run(executionCourseOID, writtenEvaluationOID);
            }
            catch (NotAuthorizedException ex2) {
                ExecutionCourseCoordinatorAuthorizationFilter.instance.execute(executionCourseOID);
                serviceInstance.run(executionCourseOID, writtenEvaluationOID);
            }
        }
    }

    static {
        advice$runDeleteWrittenEvaluation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new DeleteWrittenEvaluation();
    }
}

