/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.person;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.UserProfile;
import org.fenixedu.bennu.core.domain.UserProfile_Base;
import org.fenixedu.bennu.core.domain.User_Base;

public class PersonSearcher {
    private String name;
    private String username;
    private String query;
    private String documentIdNumber;
    private IDDocumentType idDocumentType;

    public PersonSearcher name(String name) {
        this.name = name;
        return this;
    }

    public PersonSearcher username(String username) {
        this.username = username;
        return this;
    }

    public PersonSearcher bestEffortQuery(String query) {
        this.query = query;
        return this;
    }

    public PersonSearcher documentIdNumber(String documentIdNumber) {
        this.documentIdNumber = documentIdNumber;
        return this;
    }

    public PersonSearcher documentIdType(IDDocumentType idDocumentType) {
        this.idDocumentType = idDocumentType;
        return this;
    }

    public Stream<Person> search(int maxHits) {
        Stream<UserProfile> stream = !Strings.isNullOrEmpty((String)this.query) ? Stream.concat(Stream.of(User.findByUsername((String)this.query)).filter(Objects::nonNull).map(User_Base::getProfile), UserProfile.searchByName((String)this.query, (int)Integer.MAX_VALUE)).limit(maxHits) : (!Strings.isNullOrEmpty((String)this.username) ? Stream.of(User.findByUsername((String)this.query)).filter(Objects::nonNull).map(User_Base::getProfile) : (!Strings.isNullOrEmpty((String)this.name) ? UserProfile.searchByName((String)this.name, (int)maxHits) : Bennu.getInstance().getUserSet().stream().map(User_Base::getProfile)));
        return stream.filter(Objects::nonNull).map(UserProfile_Base::getPerson).filter(Objects::nonNull);
    }

    public Stream<Person> search() {
        return this.search(Integer.MAX_VALUE);
    }
}

