/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.TreeSet;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Locality;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.StandaloneEnrolmentCertificateRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.FenixStringTools;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class StandaloneEnrolmentCertificateRequestDocument
extends AdministrativeOfficeDocument {
    private static final long serialVersionUID = 1L;

    protected StandaloneEnrolmentCertificateRequestDocument(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    protected StandaloneEnrolmentCertificateRequest getDocumentRequest() {
        return (StandaloneEnrolmentCertificateRequest)((Object)super.getDocumentRequest());
    }

    @Override
    protected void fillReport() {
        super.fillReport();
        this.addParameter("enrolmentsInfo", this.getEnrolmentsInfo());
    }

    @Override
    protected String getDegreeDescription() {
        return this.getDocumentRequest().getRegistration().getDegreeDescription(null, this.getLocale());
    }

    @Override
    protected void newFillReport() {
        Registration registration = this.getDocumentRequest().getRegistration();
        this.fillFirstParagraph();
        this.fillSecondParagraph();
        this.fillSeventhParagraph();
        this.fillTrailer(registration);
        this.fillPriceTags();
    }

    protected void fillFirstParagraph() {
        Person coordinator = this.getAdministrativeOffice().getCoordinator().getPerson();
        String adminOfficeName = this.getI18NText(this.getAdministrativeOffice().getName());
        String institutionName = this.getInstitutionName();
        String universityName = this.getUniversityName(new DateTime());
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.firstParagraph", (String[])new String[0]);
        String coordinatorTitle = this.getCoordinatorGender(coordinator);
        this.addParameter("firstParagraph", "     " + MessageFormat.format(stringTemplate, coordinator.getName(), coordinatorTitle, adminOfficeName.toUpperCase(this.getLocale()), institutionName.toUpperCase(this.getLocale()), universityName.toUpperCase(this.getLocale())));
    }

    protected void fillSecondParagraph() {
        this.addParameter("secondParagraph", "      " + BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.standaloneEnrolmentCertificate.secondParagraph", (String[])new String[0]));
    }

    protected void fillSeventhParagraph() {
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.standaloneEnrolmentCertificate.seventhParagraph", (String[])new String[0]);
        this.addParameter("seventhParagraph", MessageFormat.format(stringTemplate, this.getDegreeDescription()));
    }

    private final String getEnrolmentsInfo() {
        StringBuilder result = new StringBuilder();
        StandaloneEnrolmentCertificateRequest request = this.getDocumentRequest();
        TreeSet enrolments = new TreeSet(Enrolment.COMPARATOR_BY_EXECUTION_YEAR_AND_NAME_AND_ID);
        enrolments.addAll(request.getEnrolmentsSet());
        for (Enrolment enrolment : enrolments) {
            result.append(FenixStringTools.multipleLineRightPadWithSuffix(this.getPresentationNameFor(enrolment).toUpperCase(), 64, '-', this.getCreditsAndGradeInfo(enrolment, enrolment.getExecutionYear()))).append("\n");
        }
        result.append(this.generateEndLine());
        return result.toString();
    }

    protected void fillTrailer(Registration registration) {
        Person coordinator = this.getAdministrativeOffice().getCoordinator().getPerson();
        String adminOfficeName = this.getI18NText(this.getAdministrativeOffice().getName());
        String institutionName = this.getInstitutionName();
        Locality locality = this.getAdministrativeOffice().getCampus().getLocality();
        String location = locality != null ? locality.getName() : null;
        String dateDD = new LocalDate().toString("dd", this.getLocale());
        String dateMMMM = new LocalDate().toString("MMMM", this.getLocale());
        String dateYYYY = new LocalDate().toString("yyyy", this.getLocale());
        String student = registration.getStudent().getPerson().isMale() ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.maleStudent", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.femaleStudent", (String[])new String[0]);
        String coordinatorTitle = this.getCoordinatorGender(coordinator);
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.signer", (String[])new String[0]);
        this.addParameter("signer", MessageFormat.format(stringTemplate, coordinatorTitle, adminOfficeName));
        stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.signerLocation", (String[])new String[0]);
        this.addParameter("signerLocation", MessageFormat.format(stringTemplate, institutionName, location, dateDD, dateMMMM, dateYYYY));
        stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.footer.studentNumber", (String[])new String[0]);
        this.addParameter("studentNumber", MessageFormat.format(stringTemplate, student, registration.getNumber().toString()));
        stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.footer.documentNumber", (String[])new String[0]);
        this.addParameter("documentNumber", MessageFormat.format(stringTemplate, this.getDocumentRequest().getServiceRequestNumber().toString().trim()));
        this.addParameter("page", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.footer.page", (String[])new String[0]));
        this.addParameter("pageOf", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.footer.pageOf", (String[])new String[0]));
        this.addParameter("checkedBy", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.standaloneEnrolmentCertificate.checkedBy", (String[])new String[0]));
    }

    protected void fillPriceTags() {
        this.addParameter("priceTagsPrinting", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.certificate.printingPriceLabel", (String[])new String[0]));
        this.addParameter("priceTagsIssuing", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.certificate.issuingPriceLabel", (String[])new String[0]));
        this.addParameter("priceTagsFastDelivery", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.certificate.fastDeliveryPriceLabel", (String[])new String[0]));
        this.addParameter("priceTagsTotal", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.certificate.totalsPriceLabel", (String[])new String[0]));
    }
}

