/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.predicate;

import java.util.stream.Collectors;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.AccessControlPredicate;

public class StudentCurricularPlanPredicates {
    public static final AccessControlPredicate<StudentCurricularPlan> ENROL = new AccessControlPredicate<StudentCurricularPlan>(){

        @Override
        public boolean evaluate(StudentCurricularPlan studentCurricularPlan) {
            Person person = AccessControl.getPerson();
            return RoleType.STUDENT.isMember(person.getUser()) || StudentCurricularPlanPredicates.hasAuthorization(person, AcademicOperationType.STUDENT_ENROLMENTS, (AcademicProgram)((Object)studentCurricularPlan.getDegree())) || RoleType.MANAGER.isMember(person.getUser()) || RoleType.INTERNATIONAL_RELATION_OFFICE.isMember(person.getUser()) || person.isCoordinatorFor(studentCurricularPlan.getDegreeCurricularPlan(), ExecutionYear.readCurrentExecutionYear());
        }
    };
    public static final AccessControlPredicate<StudentCurricularPlan> ENROL_IN_AFFINITY_CYCLE = new AccessControlPredicate<StudentCurricularPlan>(){

        @Override
        public boolean evaluate(StudentCurricularPlan studentCurricularPlan) {
            Person person = AccessControl.getPerson();
            if (RoleType.MANAGER.isMember(person.getUser())) {
                return true;
            }
            if (!studentCurricularPlan.isConclusionProcessed()) {
                return RoleType.STUDENT.isMember(person.getUser()) || StudentCurricularPlanPredicates.hasAuthorization(person, AcademicOperationType.STUDENT_ENROLMENTS, (AcademicProgram)((Object)studentCurricularPlan.getDegree())) || RoleType.INTERNATIONAL_RELATION_OFFICE.isMember(person.getUser());
            }
            if (studentCurricularPlan.isEmptyDegree()) {
                return true;
            }
            return StudentCurricularPlanPredicates.hasAuthorization(person, AcademicOperationType.UPDATE_REGISTRATION_AFTER_CONCLUSION, (AcademicProgram)((Object)studentCurricularPlan.getDegree()));
        }
    };
    public static final AccessControlPredicate<StudentCurricularPlan> MOVE_CURRICULUM_LINES = new AccessControlPredicate<StudentCurricularPlan>(){

        @Override
        public boolean evaluate(StudentCurricularPlan studentCurricularPlan) {
            Person person = AccessControl.getPerson();
            return StudentCurricularPlanPredicates.hasAuthorization(person, AcademicOperationType.STUDENT_ENROLMENTS, (AcademicProgram)((Object)studentCurricularPlan.getDegree())) || RoleType.MANAGER.isMember(person.getUser());
        }
    };
    public static AccessControlPredicate<StudentCurricularPlan> MOVE_CURRICULUM_LINES_WITHOUT_RULES = new AccessControlPredicate<StudentCurricularPlan>(){

        @Override
        public boolean evaluate(StudentCurricularPlan studentCurricularPlan) {
            Person person = AccessControl.getPerson();
            if (RoleType.MANAGER.isMember(person.getUser())) {
                return true;
            }
            return StudentCurricularPlanPredicates.hasAuthorization(person, AcademicOperationType.MOVE_CURRICULUM_LINES_WITHOUT_RULES, (AcademicProgram)((Object)studentCurricularPlan.getDegree()));
        }
    };

    private static boolean hasAuthorization(Person person, AcademicOperationType operation, AcademicProgram program) {
        return AcademicAccessRule.getProgramsAccessibleToFunction(operation, person.getUser()).collect(Collectors.toSet()).contains((Object)program);
    }
}

