/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.ImprovementOfApprovedEnrolment;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolment;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.joda.time.LocalDate;

public class StudentCurricularPlanImprovementOfApprovedEnrolmentManager
extends StudentCurricularPlanEnrolment {
    public StudentCurricularPlanImprovementOfApprovedEnrolmentManager(EnrolmentContext enrolmentContext) {
        super(enrolmentContext);
    }

    @Override
    protected void assertEnrolmentPreConditions() {
        if (this.isResponsiblePersonManager()) {
            return;
        }
        if (!this.hasRegistrationInValidState()) {
            throw new DomainException("error.StudentCurricularPlan.cannot.enrol.with.registration.inactive", new String[0]);
        }
        if (TreasuryBridgeAPIFactory.implementation().isAcademicalActsBlocked(this.getPerson(), new LocalDate())) {
            throw new DomainException("error.StudentCurricularPlan.cannot.enrol.with.debts.for.previous.execution.years", new String[0]);
        }
        if (this.areModifiedCyclesConcluded()) {
            this.checkUpdateRegistrationAfterConclusion();
        }
    }

    private boolean hasRegistrationInValidState() {
        return this.getRegistration().isRegistered(this.getExecutionYear()) || this.getRegistration().isRegistered(this.getExecutionYear().getPreviousExecutionYear());
    }

    @Override
    protected void unEnrol() {
        for (CurriculumModule curriculumModule : this.enrolmentContext.getToRemove()) {
            if (curriculumModule instanceof Enrolment) {
                Enrolment enrolment = (Enrolment)((Object)curriculumModule);
                enrolment.deleteTemporaryEvaluationForImprovement(this.getEvaluationSeason(), this.getExecutionSemester());
                continue;
            }
            throw new DomainException("StudentCurricularPlanImprovementOfApprovedEnrolmentManager.can.only.manage.enrolment.evaluations.of.enrolments", new String[0]);
        }
    }

    @Override
    protected void addEnroled() {
    }

    @Override
    protected Map<IDegreeModuleToEvaluate, Set<ICurricularRule>> getRulesToEvaluate() {
        HashMap<IDegreeModuleToEvaluate, Set<ICurricularRule>> result = new HashMap<IDegreeModuleToEvaluate, Set<ICurricularRule>>();
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : this.enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isEnroled() || !degreeModuleToEvaluate.canCollectRules()) continue;
            EnroledCurriculumModuleWrapper moduleEnroledWrapper = (EnroledCurriculumModuleWrapper)degreeModuleToEvaluate;
            if (moduleEnroledWrapper.getCurriculumModule() instanceof Enrolment) {
                Enrolment enrolment = (Enrolment)((Object)moduleEnroledWrapper.getCurriculumModule());
                result.put(degreeModuleToEvaluate, Collections.singleton(new ImprovementOfApprovedEnrolment(enrolment, this.getEvaluationSeason())));
                continue;
            }
            throw new DomainException("StudentCurricularPlanImprovementOfApprovedEnrolmentManager.can.only.manage.enrolment.evaluations.of.enrolments", new String[0]);
        }
        return result;
    }

    @Override
    protected void performEnrolments(Map<EnrolmentResultType, List<IDegreeModuleToEvaluate>> degreeModulesToEvaluate) {
        HashSet<Enrolment> toCreate = new HashSet<Enrolment>();
        for (Map.Entry<EnrolmentResultType, List<IDegreeModuleToEvaluate>> entry : degreeModulesToEvaluate.entrySet()) {
            for (IDegreeModuleToEvaluate degreeModuleToEvaluate : entry.getValue()) {
                if (!degreeModuleToEvaluate.isEnroled()) continue;
                EnroledCurriculumModuleWrapper moduleEnroledWrapper = (EnroledCurriculumModuleWrapper)degreeModuleToEvaluate;
                if (moduleEnroledWrapper.getCurriculumModule() instanceof Enrolment) {
                    Enrolment enrolment = (Enrolment)((Object)moduleEnroledWrapper.getCurriculumModule());
                    toCreate.add(enrolment);
                    continue;
                }
                throw new DomainException("StudentCurricularPlanImprovementOfApprovedEnrolmentManager.can.only.manage.enrolment.evaluations.of.enrolments", new String[0]);
            }
        }
        if (!toCreate.isEmpty()) {
            this.getStudentCurricularPlan().createEnrolmentEvaluationForImprovement(toCreate, this.getResponsiblePerson(), this.getExecutionSemester(), this.getEvaluationSeason());
        }
    }

    public EnrolmentContext getEnrolmentContext() {
        return this.enrolmentContext;
    }

    public EvaluationSeason getEvaluationSeason() {
        return this.getEnrolmentContext().getEvaluationSeason();
    }

    @Override
    protected boolean isEnrolingInCycle(CycleCurriculumGroup cycle) {
        for (IDegreeModuleToEvaluate dmte : this.enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!dmte.isEnroled() || !cycle.hasCurriculumModule((CurriculumModule)((Object)dmte.getCurriculumGroup()))) continue;
            return true;
        }
        return false;
    }
}

