/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.studentCurriculum.BranchCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule_Base;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.RootCurriculumGroup;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.academic.util.predicates.ResultCollection;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.DomainObject;

public abstract class CurriculumModule
extends CurriculumModule_Base {
    public static final Comparator<CurriculumModule> COMPARATOR_BY_NAME_AND_ID = new Comparator<CurriculumModule>(){

        @Override
        public int compare(CurriculumModule o1, CurriculumModule o2) {
            int result = o1.getName().compareTo(o2.getName());
            return result == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : result;
        }
    };
    public static final Comparator<CurriculumModule> COMPARATOR_BY_FULL_PATH_NAME_AND_ID = new Comparator<CurriculumModule>(){

        @Override
        public int compare(CurriculumModule o1, CurriculumModule o2) {
            int result = o1.getFullPath().compareTo(o2.getFullPath());
            return result == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : result;
        }
    };
    public static final Comparator<CurriculumModule> COMPARATOR_BY_CREATION_DATE = new Comparator<CurriculumModule>(){

        @Override
        public int compare(CurriculumModule o1, CurriculumModule o2) {
            return o1.getCreationDateDateTime().compareTo((ReadableInstant)o2.getCreationDateDateTime());
        }
    };

    public CurriculumModule() {
        this.setCreationDateDateTime(new DateTime());
    }

    public void deleteRecursive() {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        this.delete();
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        this.setDegreeModule(null);
        this.setCurriculumGroup(null);
        super.deleteDomainObject();
    }

    public RootCurriculumGroup getRootCurriculumGroup() {
        return this.getCurriculumGroup() != null ? this.getCurriculumGroup().getRootCurriculumGroup() : (RootCurriculumGroup)((Object)this);
    }

    public CycleCurriculumGroup getParentCycleCurriculumGroup() {
        return this.getCurriculumGroup() != null ? this.getCurriculumGroup().getParentCycleCurriculumGroup() : null;
    }

    public boolean isCycleCurriculumGroup() {
        return false;
    }

    public BranchCurriculumGroup getParentBranchCurriculumGroup() {
        return this.getCurriculumGroup() != null ? this.getCurriculumGroup().getParentBranchCurriculumGroup() : null;
    }

    public boolean isBranchCurriculumGroup() {
        return false;
    }

    public boolean isNoCourseGroupCurriculumGroup() {
        return false;
    }

    public boolean isEnrolment() {
        return false;
    }

    public boolean isDismissal() {
        return false;
    }

    public boolean isCreditsDismissal() {
        return false;
    }

    public boolean isCurriculumLine() {
        return this.isLeaf();
    }

    public abstract boolean isLeaf();

    public abstract boolean isRoot();

    public abstract StringBuilder print(String var1);

    public abstract List<Enrolment> getEnrolments();

    public abstract StudentCurricularPlan getStudentCurricularPlan();

    public final boolean isBolonhaDegree() {
        return this.getStudentCurricularPlan().isBolonhaDegree();
    }

    public DegreeCurricularPlan getDegreeCurricularPlanOfStudent() {
        return this.getStudentCurricularPlan().getDegreeCurricularPlan();
    }

    public DegreeCurricularPlan getDegreeCurricularPlanOfDegreeModule() {
        if (this.getDegreeModule() != null) {
            return this.getDegreeModule().getParentDegreeCurricularPlan();
        }
        return null;
    }

    public MultiLanguageString getName() {
        MultiLanguageString multiLanguageString = new MultiLanguageString();
        if (this.getDegreeModule().getName() != null && this.getDegreeModule().getName().length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.pt, this.getDegreeModule().getName());
        }
        if (this.getDegreeModule().getNameEn() != null && this.getDegreeModule().getNameEn().length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.en, this.getDegreeModule().getNameEn());
        }
        return multiLanguageString;
    }

    public MultiLanguageString getPresentationName() {
        return this.getName();
    }

    public boolean isApproved(CurricularCourse curricularCourse) {
        return this.isApproved(curricularCourse, null);
    }

    public boolean hasDegreeModule(DegreeModule degreeModule) {
        return this.getDegreeModule().equals((Object)degreeModule);
    }

    public boolean hasCurriculumModule(CurriculumModule curriculumModule) {
        return this.equals((Object)curriculumModule);
    }

    public boolean parentCurriculumGroupIsNoCourseGroupCurriculumGroup() {
        return this.getCurriculumGroup() != null && this.getCurriculumGroup().isNoCourseGroupCurriculumGroup();
    }

    public boolean parentAllowAccumulatedEctsCredits() {
        return !this.parentCurriculumGroupIsNoCourseGroupCurriculumGroup() || ((NoCourseGroupCurriculumGroup)((Object)this.getCurriculumGroup())).allowAccumulatedEctsCredits();
    }

    public Set<ICurricularRule> getCurricularRules(ExecutionSemester executionSemester) {
        Set<ICurricularRule> result = this.getCurriculumGroup() != null ? this.getCurriculumGroup().getCurricularRules(executionSemester) : new HashSet();
        result.addAll(this.getDegreeModule().getCurricularRules(executionSemester));
        return result;
    }

    public ICurricularRule getMostRecentActiveCurricularRule(CurricularRuleType ruleType, ExecutionYear executionYear) {
        return this.getDegreeModule().getMostRecentActiveCurricularRule(ruleType, this.getCurriculumGroup().getDegreeModule(), executionYear);
    }

    public ICurricularRule getMostRecentActiveCurricularRule(CurricularRuleType ruleType, ExecutionSemester executionSemester) {
        return this.getDegreeModule().getMostRecentActiveCurricularRule(ruleType, this.getCurriculumGroup().getDegreeModule(), executionSemester);
    }

    public String getFullPath() {
        if (this.isRoot()) {
            return this.getName().getContent();
        }
        return this.getCurriculumGroup().getFullPath() + " > " + this.getName().getContent();
    }

    public boolean isFor(DegreeCurricularPlan degreeCurricularPlan) {
        return this.getDegreeModule().getParentDegreeCurricularPlan() == degreeCurricularPlan;
    }

    public boolean isFor(Registration registration) {
        return this.getRegistration() == registration;
    }

    public final Registration getRegistration() {
        return this.getStudentCurricularPlan().getRegistration();
    }

    public final Student getStudent() {
        return this.getRegistration().getStudent();
    }

    public final Person getPerson() {
        return this.getStudent().getPerson();
    }

    public boolean isConcluded() {
        return this.isConcluded(this.getApprovedCurriculumLinesLastExecutionYear()).value();
    }

    public ExecutionYear getApprovedCurriculumLinesLastExecutionYear() {
        TreeSet<ExecutionYear> executionYears = new TreeSet<ExecutionYear>(ExecutionYear.COMPARATOR_BY_YEAR);
        for (CurriculumLine curriculumLine : this.getApprovedCurriculumLines()) {
            if (!curriculumLine.hasExecutionPeriod()) continue;
            executionYears.add(curriculumLine.getExecutionPeriod().getExecutionYear());
        }
        return executionYears.isEmpty() ? ExecutionYear.readCurrentExecutionYear() : (ExecutionYear)executionYears.last();
    }

    public final Collection<CurriculumLine> getApprovedCurriculumLines() {
        HashSet<CurriculumLine> result = new HashSet<CurriculumLine>();
        this.addApprovedCurriculumLines(result);
        return result;
    }

    public final CurriculumLine getLastApprovement() {
        TreeSet<CurriculumLine> curriculumLines = new TreeSet<CurriculumLine>(CurriculumLine.COMPARATOR_BY_APPROVEMENT_DATE_AND_ID);
        curriculumLines.addAll(this.getApprovedCurriculumLines());
        if (curriculumLines.isEmpty()) {
            throw new DomainException("error.curriculum.group.has.no.approved.curriculum.lines", this.getName().getContent());
        }
        return (CurriculumLine)((Object)curriculumLines.last());
    }

    public final YearMonthDay getLastApprovementDate() {
        return this.getLastApprovement().getApprovementDate();
    }

    public final ExecutionYear getLastApprovementExecutionYear() {
        return this.getLastApprovement().getExecutionYear();
    }

    public final boolean wasCreated(DateTime when) {
        return this.getCreationDateDateTime() == null || this.getCreationDateDateTime().isBefore((ReadableInstant)when);
    }

    public final Curriculum getCurriculum() {
        return this.getCurriculum(new DateTime(), null);
    }

    public final Curriculum getCurriculum(DateTime when) {
        return this.wasCreated(when) ? this.getCurriculum(when, null) : Curriculum.createEmpty(this, null);
    }

    public final Curriculum getCurriculum(ExecutionYear executionYear) {
        return this.getCurriculum(new DateTime(), executionYear);
    }

    public Grade calculateRawGrade() {
        return this.getCurriculum().getRawGrade();
    }

    public Grade calculateFinalGrade() {
        return this.getCurriculum().getFinalGrade();
    }

    public Double getCreditsConcluded() {
        return this.getCreditsConcluded(this.getApprovedCurriculumLinesLastExecutionYear());
    }

    public boolean hasEnrolmentWithEnroledState(CurricularCourse curricularCourse, ExecutionYear executionYear) {
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            if (!this.hasEnrolmentWithEnroledState(curricularCourse, executionSemester)) continue;
            return true;
        }
        return false;
    }

    public abstract Double getEctsCredits();

    public abstract Double getAprovedEctsCredits();

    public abstract Double getEnroledEctsCredits(ExecutionSemester var1);

    public abstract Double getEnroledEctsCredits(ExecutionYear var1);

    public abstract boolean isApproved(CurricularCourse var1, ExecutionSemester var2);

    public abstract boolean isEnroledInExecutionPeriod(CurricularCourse var1, ExecutionSemester var2);

    public abstract boolean hasAnyEnrolments();

    public abstract void addApprovedCurriculumLines(Collection<CurriculumLine> var1);

    public abstract boolean hasAnyApprovedCurriculumLines();

    public abstract boolean hasEnrolmentWithEnroledState(CurricularCourse var1, ExecutionSemester var2);

    public abstract ExecutionYear getIEnrolmentsLastExecutionYear();

    public abstract Enrolment findEnrolmentFor(CurricularCourse var1, ExecutionSemester var2);

    public abstract Set<IDegreeModuleToEvaluate> getDegreeModulesToEvaluate(ExecutionSemester var1);

    public abstract Enrolment getApprovedEnrolment(CurricularCourse var1);

    public abstract CurriculumLine getApprovedCurriculumLine(CurricularCourse var1);

    public abstract Dismissal getDismissal(CurricularCourse var1);

    public abstract void collectDismissals(List<Dismissal> var1);

    public abstract void getAllDegreeModules(Collection<DegreeModule> var1);

    public abstract Set<CurriculumLine> getAllCurriculumLines();

    public abstract ConclusionValue isConcluded(ExecutionYear var1);

    public abstract boolean hasConcluded(DegreeModule var1, ExecutionYear var2);

    public abstract YearMonthDay calculateConclusionDate();

    public abstract Curriculum getCurriculum(DateTime var1, ExecutionYear var2);

    public abstract Double getCreditsConcluded(ExecutionYear var1);

    public abstract boolean isPropaedeutic();

    public abstract boolean hasEnrolment(ExecutionYear var1);

    public abstract boolean hasEnrolment(ExecutionSemester var1);

    public abstract boolean isEnroledInSpecialSeason(ExecutionSemester var1);

    public abstract boolean isEnroledInSpecialSeason(ExecutionYear var1);

    public abstract int getNumberOfAllApprovedEnrolments(ExecutionSemester var1);

    public abstract void getCurriculumModules(ResultCollection<CurriculumModule> var1);

    public boolean hasAnyCurriculumModules(Predicate<CurriculumModule> predicate) {
        return predicate.test(this);
    }

    public boolean hasAnyCurriculumLines() {
        return this.hasAnyCurriculumModules(new CurriculumModulePredicateByType(CurriculumLine.class));
    }

    public abstract Set<CurriculumGroup> getAllCurriculumGroups();

    public abstract Set<CurriculumGroup> getAllCurriculumGroupsWithoutNoCourseGroupCurriculumGroups();

    @Deprecated
    public Date getCreationDate() {
        DateTime dt = this.getCreationDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setCreationDate(Date date) {
        if (date == null) {
            this.setCreationDateDateTime(null);
        } else {
            this.setCreationDateDateTime(new DateTime(date.getTime()));
        }
    }

    public static class CurriculumModulePredicateByApproval
    implements Predicate<CurriculumModule> {
        @Override
        public boolean test(CurriculumModule curriculumModule) {
            CurriculumLine curriculumLine;
            return curriculumModule.isCurriculumLine() && (curriculumLine = (CurriculumLine)((Object)curriculumModule)).isApproved();
        }
    }

    public static class CurriculumModulePredicateByExecutionYear
    implements Predicate<CurriculumModule> {
        private final ExecutionYear executionYear;

        public CurriculumModulePredicateByExecutionYear(ExecutionYear executionYear) {
            this.executionYear = executionYear;
        }

        @Override
        public boolean test(CurriculumModule curriculumModule) {
            CurriculumLine curriculumLine;
            return curriculumModule.isCurriculumLine() && (curriculumLine = (CurriculumLine)((Object)curriculumModule)).getExecutionYear().equals(this.executionYear);
        }
    }

    public static class CurriculumModulePredicateByExecutionSemester
    implements Predicate<CurriculumModule> {
        private final ExecutionSemester executionSemester;

        public CurriculumModulePredicateByExecutionSemester(ExecutionSemester executionSemester) {
            this.executionSemester = executionSemester;
        }

        @Override
        public boolean test(CurriculumModule curriculumModule) {
            CurriculumLine curriculumLine;
            return curriculumModule.isCurriculumLine() && (curriculumLine = (CurriculumLine)((Object)curriculumModule)).getExecutionPeriod().equals(this.executionSemester);
        }
    }

    public static class CurriculumModulePredicateByType
    implements Predicate<CurriculumModule> {
        private final Class<? extends CurriculumModule> clazz;

        public CurriculumModulePredicateByType(Class<? extends CurriculumModule> clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean test(CurriculumModule curriculumModule) {
            return this.clazz.isAssignableFrom(((Object)((Object)curriculumModule)).getClass());
        }
    }

    public static enum ConclusionValue {
        CONCLUDED(true){

            @Override
            public boolean isValid() {
                return true;
            }
        }
        ,
        NOT_CONCLUDED(false){

            @Override
            public boolean isValid() {
                return false;
            }
        }
        ,
        UNKNOWN(false){

            @Override
            public boolean isValid() {
                return true;
            }
        };

        private boolean value;

        private ConclusionValue(boolean value) {
            this.value = value;
        }

        public boolean value() {
            return this.value;
        }

        public abstract boolean isValid();

        public static ConclusionValue create(boolean value) {
            return value ? CONCLUDED : NOT_CONCLUDED;
        }

        public String getLocalizedName() {
            return BundleUtil.getString((String)"resources.EnumerationResources", (String)(ConclusionValue.class.getSimpleName() + "." + this.name()), (String[])new String[0]);
        }
    }
}

