/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import java.util.Collection;
import java.util.TreeSet;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;

public class EnrolmentSet
extends TreeSet<Enrolment> {
    private final ExecutionYear executionYear;

    public EnrolmentSet(ExecutionYear executionYear) {
        super(Enrolment.REVERSE_COMPARATOR_BY_EXECUTION_PERIOD_AND_ID);
        this.executionYear = executionYear;
    }

    @Override
    public boolean add(Enrolment enrolment) {
        ExecutionYear enrolmentExecutionYear = enrolment.getExecutionPeriod().getExecutionYear();
        return this.executionYear == null || this.executionYear.compareTo(enrolmentExecutionYear) > 0 ? super.add(enrolment) : false;
    }

    @Override
    public boolean addAll(Collection<? extends Enrolment> enrolments) {
        boolean changed = false;
        for (Enrolment enrolment : enrolments) {
            changed &= this.add(enrolment);
        }
        return changed;
    }

    @Override
    public EnrolmentSet clone() {
        EnrolmentSet clone = new EnrolmentSet(this.executionYear);
        clone.addAll(this);
        return clone;
    }
}

