/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.residence;

import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.ResidenceEvent;
import org.fenixedu.academic.domain.organizationalStructure.ResidenceManagementUnit;
import org.fenixedu.academic.domain.residence.ResidenceMonth_Base;
import org.fenixedu.academic.domain.residence.ResidenceYear;
import org.fenixedu.academic.util.Month;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class ResidenceMonth
extends ResidenceMonth_Base {
    protected ResidenceMonth() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public ResidenceMonth(Month month, ResidenceYear residenceYear) {
        this();
        this.setMonth(month);
        this.setYear(residenceYear);
    }

    public ResidenceManagementUnit getManagementUnit() {
        return this.getYear().getUnit();
    }

    public boolean isEventPresent(Person person) {
        for (ResidenceEvent event : this.getEventsSet()) {
            if (event.getPerson() != person || !event.isOpen() && !event.isPayed()) continue;
            return true;
        }
        return false;
    }

    public DateTime getPaymentStartDate() {
        LocalDate date = new LocalDate(this.getYear().getYear().intValue(), this.getMonth().getNumberOfMonth(), 1);
        return date.toDateTimeAtStartOfDay();
    }

    public DateTime getPaymentLimitDateTime() {
        ResidenceYear residenceYear = this.getYear();
        LocalDate date = new LocalDate(residenceYear.getYear().intValue(), this.getMonth().getNumberOfMonth(), this.getManagementUnit().getCurrentPaymentLimitDay().intValue());
        return date.toDateTimeAtStartOfDay();
    }

    public boolean isAbleToEditPaymentLimitDate() {
        return this.getEventsSet().size() == 0;
    }

    public Set<ResidenceEvent> getEventsWithPaymentCodes() {
        HashSet<ResidenceEvent> eventsWithCodes = new HashSet<ResidenceEvent>();
        for (ResidenceEvent event : this.getEventsSet()) {
            if (event.getAllPaymentCodes().size() <= 0 || event.isCancelled()) continue;
            eventsWithCodes.add(event);
        }
        return eventsWithCodes;
    }

    public Set<ResidenceEvent> getEventsWithoutPaymentCodes() {
        HashSet<ResidenceEvent> eventsWithoutCodes = new HashSet<ResidenceEvent>();
        for (ResidenceEvent event : this.getEventsSet()) {
            if (event.getAllPaymentCodes().size() != 0 || event.isCancelled()) continue;
            eventsWithoutCodes.add(event);
        }
        return eventsWithoutCodes;
    }

    public boolean isFor(int year) {
        return this.getYear().isFor(year);
    }
}

