/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CreditsLimitInExternalCycle;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.ExternalCurriculumGroup;

public class CreditsLimitInExternalCycleExecutor
extends CurricularRuleExecutor {
    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        CreditsLimitInExternalCycle creditsLimitInExternalCycle = (CreditsLimitInExternalCycle)curricularRule;
        ExternalCurriculumGroup externalCurriculumGroup = creditsLimitInExternalCycle.getExternalCurriculumGroup();
        if (!this.isToApply(sourceDegreeModuleToEvaluate, enrolmentContext, externalCurriculumGroup)) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (this.isEnrolingDissertation(enrolmentContext, externalCurriculumGroup)) {
            return this.createRuleResultForEnrolingDissertation(sourceDegreeModuleToEvaluate, creditsLimitInExternalCycle);
        }
        CycleCurriculumGroup previousCycleCurriclumGroup = creditsLimitInExternalCycle.getPreviousCycleCurriculumGroup();
        Double totalCreditsInPreviousCycle = previousCycleCurriclumGroup.getAprovedEctsCredits();
        if (!creditsLimitInExternalCycle.creditsInPreviousCycleSufficient(totalCreditsInPreviousCycle)) {
            return this.createRuleResultForNotSatisfiedCreditsForPreviousCycle(sourceDegreeModuleToEvaluate, creditsLimitInExternalCycle, previousCycleCurriclumGroup);
        }
        Double totalCredits = this.calculateApprovedAndEnrollingTotalCredits(enrolmentContext, externalCurriculumGroup);
        if (creditsLimitInExternalCycle.creditsExceedMaximumInExternalCycle(totalCredits, totalCreditsInPreviousCycle)) {
            return this.createRuleResultForMaxCreditsExceededInExternalCycle(sourceDegreeModuleToEvaluate, creditsLimitInExternalCycle, totalCredits, totalCreditsInPreviousCycle);
        }
        Double previousPeriodEnroledEcts = enrolmentContext.isToEvaluateRulesByYear() ? externalCurriculumGroup.getEnroledEctsCredits(enrolmentContext.getExecutionYear().getPreviousExecutionYear()) : externalCurriculumGroup.getEnroledEctsCredits(enrolmentContext.getExecutionPeriod().getPreviousExecutionPeriod());
        Double totalEctsWithEnroledEctsCreditsFromPreviousPeriod = totalCredits + previousPeriodEnroledEcts;
        if (creditsLimitInExternalCycle.creditsExceedMaximumInExternalCycle(totalEctsWithEnroledEctsCreditsFromPreviousPeriod, totalCreditsInPreviousCycle)) {
            return RuleResult.createTrue(EnrolmentResultType.TEMPORARY, sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.CreditsLimitInExternalCycleExecutor.external.cycle.limit.exceeded", creditsLimitInExternalCycle.getExternalCurriculumGroup().getName().getContent(), totalEctsWithEnroledEctsCreditsFromPreviousPeriod.toString(), creditsLimitInExternalCycle.getMaxCreditsInExternalCycle(totalCreditsInPreviousCycle).toString(), totalCreditsInPreviousCycle.toString());
        }
        return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    private RuleResult createRuleResultForNotSatisfiedCreditsForPreviousCycle(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, CreditsLimitInExternalCycle creditsLimitInExternalCycle, CycleCurriculumGroup previousCycleCurriclumGroup) {
        if (sourceDegreeModuleToEvaluate.isEnroled() && sourceDegreeModuleToEvaluate.isLeaf()) {
            return RuleResult.createImpossible(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.CreditsLimitInExternalCycleExecutor.previous.cycle.minimum.credits.not.fulfilled", creditsLimitInExternalCycle.getExternalCurriculumGroup().getName().getContent(), creditsLimitInExternalCycle.getMinCreditsInPreviousCycle().toString(), previousCycleCurriclumGroup.getName().getContent());
        }
        return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.CreditsLimitInExternalCycleExecutor.previous.cycle.minimum.credits.not.fulfilled", creditsLimitInExternalCycle.getExternalCurriculumGroup().getName().getContent(), creditsLimitInExternalCycle.getMinCreditsInPreviousCycle().toString(), previousCycleCurriclumGroup.getName().getContent());
    }

    private boolean isToApply(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext, ExternalCurriculumGroup externalCurriculumGroup) {
        if (!sourceDegreeModuleToEvaluate.isLeaf()) {
            return false;
        }
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!externalCurriculumGroup.hasCurriculumModule((CurriculumModule)((Object)degreeModuleToEvaluate.getCurriculumGroup())) || !this.isEnrolingOrIsEnroled(enrolmentContext, degreeModuleToEvaluate)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnroledIn(IDegreeModuleToEvaluate degreeModuleToEvaluate, ExecutionSemester executionSemester) {
        if (degreeModuleToEvaluate.isLeaf()) {
            EnroledCurriculumModuleWrapper curriculumModuleEnroledWrapper = (EnroledCurriculumModuleWrapper)degreeModuleToEvaluate;
            CurriculumLine curriculumLine = (CurriculumLine)((Object)curriculumModuleEnroledWrapper.getCurriculumModule());
            if (curriculumLine.isEnrolment()) {
                return curriculumLine.getExecutionPeriod() == executionSemester;
            }
            return false;
        }
        return false;
    }

    private Double calculateApprovedAndEnrollingTotalCredits(EnrolmentContext enrolmentContext, ExternalCurriculumGroup externalCurriculumGroup) {
        double result = 0.0;
        ExecutionSemester executionSemester = enrolmentContext.getExecutionPeriod();
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isLeaf() || !externalCurriculumGroup.hasCurriculumModule((CurriculumModule)((Object)degreeModuleToEvaluate.getCurriculumGroup()))) continue;
            result += degreeModuleToEvaluate.getEctsCredits(executionSemester).doubleValue();
        }
        return result += externalCurriculumGroup.getAprovedEctsCredits().doubleValue();
    }

    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        CreditsLimitInExternalCycle creditsLimitInExternalCycle = (CreditsLimitInExternalCycle)curricularRule;
        ExternalCurriculumGroup externalCurriculumGroup = creditsLimitInExternalCycle.getExternalCurriculumGroup();
        if (!this.isToApply(sourceDegreeModuleToEvaluate, enrolmentContext, externalCurriculumGroup)) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (this.isEnrolingDissertation(enrolmentContext, externalCurriculumGroup)) {
            return this.createRuleResultForEnrolingDissertation(sourceDegreeModuleToEvaluate, creditsLimitInExternalCycle);
        }
        CycleCurriculumGroup previousCycleCurriclumGroup = creditsLimitInExternalCycle.getPreviousCycleCurriculumGroup();
        Double totalCreditsInPreviousCycle = previousCycleCurriclumGroup.getAprovedEctsCredits();
        if (!creditsLimitInExternalCycle.creditsInPreviousCycleSufficient(totalCreditsInPreviousCycle)) {
            return this.createRuleResultForNotSatisfiedCreditsForPreviousCycle(sourceDegreeModuleToEvaluate, creditsLimitInExternalCycle, previousCycleCurriclumGroup);
        }
        Double totalCreditsInExternalCycle = this.calculateApprovedAndEnrollingTotalCredits(enrolmentContext, externalCurriculumGroup);
        if (creditsLimitInExternalCycle.creditsExceedMaximumInExternalCycle(totalCreditsInExternalCycle, totalCreditsInPreviousCycle)) {
            return this.createRuleResultForMaxCreditsExceededInExternalCycle(sourceDegreeModuleToEvaluate, creditsLimitInExternalCycle, totalCreditsInExternalCycle, totalCreditsInPreviousCycle);
        }
        return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    private RuleResult createRuleResultForEnrolingDissertation(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, CreditsLimitInExternalCycle creditsLimitInExternalCycle) {
        if (sourceDegreeModuleToEvaluate.isEnroled() && sourceDegreeModuleToEvaluate.isLeaf()) {
            return RuleResult.createImpossible(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.CreditsLimitInExternalCycleExecutor.enroling.dissertation", new String[0]);
        }
        return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.CreditsLimitInExternalCycleExecutor.enroling.dissertation", new String[0]);
    }

    private boolean isEnrolingDissertation(EnrolmentContext enrolmentContext, ExternalCurriculumGroup externalCurriculumGroup) {
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isDissertation() || !externalCurriculumGroup.hasCurriculumModule((CurriculumModule)((Object)degreeModuleToEvaluate.getCurriculumGroup())) || !this.isEnrolingOrIsEnroled(enrolmentContext, degreeModuleToEvaluate)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnrolingOrIsEnroled(EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate degreeModuleToEvaluate) {
        if (degreeModuleToEvaluate.isEnroling()) {
            return true;
        }
        for (ExecutionSemester executionSemester : enrolmentContext.getExecutionSemestersToEvaluate()) {
            if (!this.isEnroledIn(degreeModuleToEvaluate, executionSemester)) continue;
            return true;
        }
        return false;
    }

    private RuleResult createRuleResultForMaxCreditsExceededInExternalCycle(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, CreditsLimitInExternalCycle creditsLimitInExternalCycle, Double totalCreditsInExternalCycle, Double totalCreditsInPreviousCycle) {
        if (sourceDegreeModuleToEvaluate.isEnroled() && sourceDegreeModuleToEvaluate.isLeaf()) {
            return RuleResult.createImpossible(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.CreditsLimitInExternalCycleExecutor.external.cycle.limit.exceeded", creditsLimitInExternalCycle.getExternalCurriculumGroup().getName().getContent(), totalCreditsInExternalCycle.toString(), creditsLimitInExternalCycle.getMaxCreditsInExternalCycle(totalCreditsInPreviousCycle).toString(), totalCreditsInPreviousCycle.toString());
        }
        return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.CreditsLimitInExternalCycleExecutor.external.cycle.limit.exceeded", creditsLimitInExternalCycle.getExternalCurriculumGroup().getName().getContent(), totalCreditsInExternalCycle.toString(), creditsLimitInExternalCycle.getMaxCreditsInExternalCycle(totalCreditsInPreviousCycle).toString(), totalCreditsInPreviousCycle.toString());
    }

    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }
}

