/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.CandidacySituationType;
import org.fenixedu.academic.domain.candidacy.DFACandidacy;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacy.RegisteredCandidacySituation_Base;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.util.workflow.IState;
import org.fenixedu.academic.domain.util.workflow.StateBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.joda.time.YearMonthDay;

public class RegisteredCandidacySituation
extends RegisteredCandidacySituation_Base {
    public RegisteredCandidacySituation(Candidacy candidacy) {
        this(candidacy, null);
    }

    public RegisteredCandidacySituation(Candidacy candidacy, Person person) {
        this(candidacy, person, null, null);
    }

    public RegisteredCandidacySituation(Candidacy candidacy, RegistrationProtocol registrationProtocol, CycleType cycleType, IngressionType ingressionType, EntryPhase entryPhase, Integer studentNumber) {
        this.init(candidacy, AccessControl.getPerson());
        this.registerCandidacy(registrationProtocol, cycleType, studentNumber);
        ((StudentCandidacy)((Object)candidacy)).setIngressionType(ingressionType);
        ((StudentCandidacy)((Object)candidacy)).setEntryPhase(entryPhase);
    }

    private RegisteredCandidacySituation(Candidacy candidacy, Person person, RegistrationProtocol registrationProtocol, CycleType cycleType) {
        this.init(candidacy, person == null ? AccessControl.getPerson() : person);
        this.registerCandidacy(registrationProtocol, cycleType, null);
    }

    private void registerCandidacy(RegistrationProtocol registrationProtocol, CycleType cycleType, Integer studentNumber) {
        Person person = this.getCandidacy().getPerson();
        Registration registration = null;
        if (this.getCandidacy() instanceof DFACandidacy) {
            DFACandidacy dfaCandidacy = (DFACandidacy)((Object)this.getCandidacy());
            registration = new Registration(person, dfaCandidacy.getExecutionDegree().getDegreeCurricularPlan(), (StudentCandidacy)((Object)dfaCandidacy), registrationProtocol, cycleType, dfaCandidacy.getExecutionDegree().getExecutionYear());
            dfaCandidacy.setRegistration(registration);
            this.createQualification();
        }
        if (person.getStudent() == null && studentNumber == null) {
            new Student(person);
        } else if (person.getStudent() == null && studentNumber != null) {
            Student.createStudentWithCustomNumber(person, studentNumber);
        }
    }

    private void createQualification() {
        DFACandidacy dfaCandidacy = (DFACandidacy)((Object)this.getCandidacy());
        if (dfaCandidacy.getPrecedentDegreeInformation() != null) {
            Qualification qualification = new Qualification();
            qualification.setPerson(dfaCandidacy.getPerson());
            qualification.setMark(dfaCandidacy.getPrecedentDegreeInformation().getConclusionGrade());
            qualification.setSchool(dfaCandidacy.getPrecedentDegreeInformation().getInstitutionName());
            qualification.setDegree(dfaCandidacy.getPrecedentDegreeInformation().getDegreeDesignation());
            if (dfaCandidacy.getPrecedentDegreeInformation().getConclusionYear() != null) {
                qualification.setDateYearMonthDay(new YearMonthDay(dfaCandidacy.getPrecedentDegreeInformation().getConclusionYear().intValue(), 1, 1));
            }
            qualification.setCountry(dfaCandidacy.getPrecedentDegreeInformation().getCountry());
        }
    }

    public CandidacySituationType getCandidacySituationType() {
        return CandidacySituationType.REGISTERED;
    }

    public boolean canExecuteOperationAutomatically() {
        return false;
    }

    public IState nextState() {
        return null;
    }

    public IState nextState(StateBean bean) {
        return null;
    }
}

