/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import org.fenixedu.academic.domain.Holiday_Base;
import org.fenixedu.academic.domain.Locality;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.LocalDate;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;

public class Holiday
extends Holiday_Base {
    public Holiday() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Holiday(Partial date, Locality locality) {
        this();
        this.setDate(date);
        this.setLocality(locality);
    }

    public void delete() {
        this.setLocality(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public static boolean isHoliday(LocalDate date) {
        return Holiday.isHoliday(date, null);
    }

    public static boolean isHoliday(LocalDate date, Space campus) {
        for (Holiday holiday : Bennu.getInstance().getHolidaysSet()) {
            if (holiday.getLocality() != null && (campus == null || holiday.getLocality() != campus.getLocality()) || !holiday.getDate().isMatch((ReadablePartial)date)) continue;
            return true;
        }
        return false;
    }
}

