/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.collections.CollectionUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularCourseEquivalence_Base;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.domain.Bennu;

public class CurricularCourseEquivalence
extends CurricularCourseEquivalence_Base {
    public static final Comparator<CurricularCourseEquivalence> COMPARATOR_BY_EQUIVALENT_COURSE_NAME = new Comparator<CurricularCourseEquivalence>(){

        @Override
        public int compare(CurricularCourseEquivalence o1, CurricularCourseEquivalence o2) {
            String name1 = o1.getEquivalentCurricularCourse().getName();
            String name2 = o2.getEquivalentCurricularCourse().getName();
            return String.CASE_INSENSITIVE_ORDER.compare(name1, name2);
        }
    };
    public static final Comparator<CurricularCourseEquivalence> COMPARATOR_BY_EQUIVALENT_COURSE_CODE = new Comparator<CurricularCourseEquivalence>(){

        @Override
        public int compare(CurricularCourseEquivalence o1, CurricularCourseEquivalence o2) {
            String code1 = o1.getEquivalentCurricularCourse().getCode();
            String code2 = o2.getEquivalentCurricularCourse().getCode();
            if (code1 == null) {
                return -1;
            }
            if (code2 == null) {
                return 1;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(code1, code2);
        }
    };

    public CurricularCourseEquivalence() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public CurricularCourseEquivalence(DegreeCurricularPlan degreeCurricularPlan, CurricularCourse equivalentCurricularCourse, Collection<CurricularCourse> oldCurricularCourses) {
        this();
        this.checkIfEquivalenceAlreadyExists(equivalentCurricularCourse, oldCurricularCourses);
        this.setDegreeCurricularPlan(degreeCurricularPlan);
        this.setEquivalentCurricularCourse(equivalentCurricularCourse);
        this.getOldCurricularCoursesSet().addAll(oldCurricularCourses);
    }

    private void checkIfEquivalenceAlreadyExists(CurricularCourse curricularCourse, Collection<CurricularCourse> oldCurricularCourses) {
        int size = oldCurricularCourses.size();
        for (CurricularCourseEquivalence curricularCourseEquivalence : curricularCourse.getCurricularCourseEquivalencesSet()) {
            int sizeOld = curricularCourseEquivalence.getOldCurricularCoursesSet().size();
            if (size != sizeOld || CollectionUtils.intersection(oldCurricularCourses, (Collection)curricularCourseEquivalence.getOldCurricularCoursesSet()).size() != size) continue;
            throw new DomainException("error.exists.curricular.course.equivalency", new String[0]);
        }
    }

    public void delete() {
        this.setDegreeCurricularPlan(null);
        this.setEquivalentCurricularCourse(null);
        this.getOldCurricularCoursesSet().clear();
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public boolean isSatisfied(Registration registration) {
        boolean result = true;
        Collection<CurricularCourse> curricularCoursesApprovedByEnrolment = registration.getCurricularCoursesApprovedByEnrolment();
        for (CurricularCourse oldCurricularCourse : this.getOldCurricularCoursesSet()) {
            result &= curricularCoursesApprovedByEnrolment.contains((Object)oldCurricularCourse);
        }
        return result;
    }

    public boolean isFrom(DegreeCurricularPlan degreeCurricularPlan) {
        return this.getDegreeCurricularPlan() == degreeCurricularPlan;
    }
}

