/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.SearchPhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.alert.PhdAlertMessage;
import org.fenixedu.academic.domain.phd.guidance.PhdGuidanceDocument;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteGuidanceDocument;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ExemptPublicPresentationSeminarComission;
import org.fenixedu.academic.domain.phd.individualProcess.activities.RequestPublicPresentationSeminarComission;
import org.fenixedu.academic.domain.phd.individualProcess.activities.UploadGuidanceDocument;
import org.fenixedu.academic.domain.phd.seminar.PublicPresentationSeminarProcessBean;
import org.fenixedu.academic.dto.phd.YearMonth;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.ui.struts.action.phd.PhdCurriculumFilterOptions;
import org.fenixedu.academic.ui.struts.action.phd.PhdDocumentsZip;
import org.fenixedu.academic.ui.struts.action.phd.PhdInactivePredicateContainer;
import org.fenixedu.academic.ui.struts.action.phd.PhdProcessDA;
import org.fenixedu.academic.ui.struts.action.phd.academicAdminOffice.PhdRegistrationConclusionBean;
import org.fenixedu.academic.util.Month;
import org.fenixedu.academic.util.predicates.PredicateContainer;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public abstract class CommonPhdIndividualProgramProcessDA
extends PhdProcessDA {
    private static final int FIRST_YEAR_TO_SHOW_ARCHIVE_MESSAGES_FROM = 2002;
    private static final int NUMBER_OF_LAST_MESSAGES = 100;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        this.loadProcessAlertMessagesToNotify(request, process2);
        return super.execute(mapping, actionForm, request, response);
    }

    private void loadProcessAlertMessagesToNotify(HttpServletRequest request, PhdIndividualProgramProcess process2) {
        if (process2 != null) {
            request.setAttribute("processAlertMessagesToNotify", process2.getUnreadedAlertMessagesFor(this.getLoggedPerson(request)));
        }
    }

    public ActionForward manageProcesses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SearchPhdIndividualProgramProcessBean searchBean = this.getOrCreateSearchBean(request);
        RenderUtils.invalidateViewState();
        return this.forwardToManageProcesses(mapping, request, searchBean);
    }

    private SearchPhdIndividualProgramProcessBean getOrCreateSearchBean(HttpServletRequest request) {
        SearchPhdIndividualProgramProcessBean searchBean = (SearchPhdIndividualProgramProcessBean)this.getObjectFromViewState("searchProcessBean");
        if (searchBean == null) {
            searchBean = this.initializeSearchBean(request);
        }
        return searchBean;
    }

    protected ActionForward forwardToManageProcesses(ActionMapping mapping, HttpServletRequest request, SearchPhdIndividualProgramProcessBean searchBean) {
        request.setAttribute("searchProcessBean", (Object)searchBean);
        request.setAttribute("candidacyCategory", this.getCandidacyCategory());
        request.setAttribute("seminarCategory", this.getSeminarCategory());
        request.setAttribute("thesisCategory", this.getThesisCategory());
        request.setAttribute("concludedThisYearContainer", (Object)this.getConcludedContainer());
        return mapping.findForward("manageProcesses");
    }

    protected abstract PhdInactivePredicateContainer getConcludedContainer();

    protected abstract List<PredicateContainer<?>> getThesisCategory();

    protected abstract List<PredicateContainer<?>> getSeminarCategory();

    protected abstract List<PredicateContainer<?>> getCandidacyCategory();

    protected abstract SearchPhdIndividualProgramProcessBean initializeSearchBean(HttpServletRequest var1);

    public ActionForward viewInactiveProcesses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SearchPhdIndividualProgramProcessBean searchBean = this.getOrCreateSearchBean(request);
        RenderUtils.invalidateViewState();
        request.setAttribute("searchProcessBean", (Object)searchBean);
        request.setAttribute("suspendedContainer", (Object)PhdInactivePredicateContainer.SUSPENDED);
        request.setAttribute("concludedContainer", (Object)PhdInactivePredicateContainer.CONCLUDED);
        request.setAttribute("abolishedContainer", (Object)PhdInactivePredicateContainer.ABOLISHED);
        return mapping.findForward("viewInactiveProcesses");
    }

    public ActionForward searchAllProcesses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        List<PhdIndividualProgramProcess> processes;
        SearchPhdIndividualProgramProcessBean searchBean = this.getOrCreateSearchBean(request);
        RenderUtils.invalidateViewState();
        try {
            processes = PhdIndividualProgramProcess.search(searchBean.getPredicates());
        }
        catch (NumberFormatException ex) {
            this.addActionMessage("searchError", request, "error.invalidFormat");
            return this.forwardToManageProcesses(mapping, request, searchBean);
        }
        if (processes.isEmpty()) {
            this.addActionMessage("searchResults", request, "message.noResults");
            return this.forwardToManageProcesses(mapping, request, searchBean);
        }
        if (processes.size() == 1) {
            request.setAttribute("process", (Object)processes.iterator().next());
            this.loadProcessAlertMessagesToNotify(request, processes.iterator().next());
            Set guidingsList = processes.iterator().next().getGuidingsSet();
            Set assistantGuidingsList = processes.iterator().next().getAssistantGuidingsSet();
            request.setAttribute("guidingsList", (Object)guidingsList);
            request.setAttribute("assistantGuidingsList", (Object)assistantGuidingsList);
            return mapping.findForward("viewProcess");
        }
        request.setAttribute("searchProcessBean", (Object)searchBean);
        request.setAttribute("processes", processes);
        return mapping.findForward("searchResults");
    }

    @EntryPoint
    public ActionForward viewProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RenderUtils.invalidateViewState();
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        if (process2 != null && process2.getRegistration() != null) {
            request.setAttribute("registrationConclusionBean", (Object)new PhdRegistrationConclusionBean(process2.getRegistration()));
        }
        Set guidingsList = process2.getGuidingsSet();
        Set assistantGuidingsList = process2.getAssistantGuidingsSet();
        request.setAttribute("guidingsList", (Object)guidingsList);
        request.setAttribute("assistantGuidingsList", (Object)assistantGuidingsList);
        return this.forwardToViewProcess(mapping, request);
    }

    protected ActionForward forwardToViewProcess(ActionMapping mapping, HttpServletRequest request) {
        request.setAttribute("backMethod", this.getFromRequest(request, "backMethod"));
        return mapping.findForward("viewProcess");
    }

    protected PhdIndividualProgramProcess getProcess(HttpServletRequest request) {
        return (PhdIndividualProgramProcess)((Object)super.getProcess(request));
    }

    protected DegreeCurricularPlan getDegreeCurricularPlan(HttpServletRequest request) {
        return (DegreeCurricularPlan)((Object)this.getDomainObject(request, "degreeCurricularPlanID"));
    }

    public ActionForward viewAlertMessages(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        TreeSet<PhdAlertMessage> orderedMessages = new TreeSet<PhdAlertMessage>(Collections.reverseOrder(PhdAlertMessage.COMPARATOR_BY_WHEN_CREATED_AND_ID));
        orderedMessages.addAll(this.getLoggedPerson(request).getPhdAlertMessagesSet());
        ArrayList<PhdAlertMessage> lastMessages = new ArrayList<PhdAlertMessage>();
        lastMessages.addAll(orderedMessages);
        request.setAttribute("unread", (Object)"false");
        request.setAttribute("alertMessages", lastMessages.subList(0, Math.min(lastMessages.size(), 100)));
        request.setAttribute("tooManyMessages", (Object)(lastMessages.size() > 100 ? "true" : "false"));
        return mapping.findForward("viewAlertMessages");
    }

    public ActionForward viewUnreadAlertMessages(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        TreeSet<PhdAlertMessage> orderedMessages = new TreeSet<PhdAlertMessage>(Collections.reverseOrder(PhdAlertMessage.COMPARATOR_BY_WHEN_CREATED_AND_ID));
        orderedMessages.addAll(this.getLoggedPerson(request).getUnreadedPhdAlertMessages());
        request.setAttribute("unread", (Object)"true");
        request.setAttribute("alertMessages", orderedMessages);
        return mapping.findForward("viewAlertMessages");
    }

    public ActionForward viewAlertMessageArchive(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        YearMonth yearMonthBean = this.getOrCreateBean(request);
        return this.forwardToAlertMessageArchive(mapping, request, yearMonthBean);
    }

    private ActionForward forwardToAlertMessageArchive(ActionMapping mapping, HttpServletRequest request, YearMonth yearMonthBean) {
        Integer year = yearMonthBean.getYear();
        if (year == null) {
            year = Integer.valueOf(ExecutionYear.readCurrentExecutionYear().getYear());
        }
        Month month = yearMonthBean.getMonth();
        TreeSet<PhdAlertMessage> orderedMessages = new TreeSet<PhdAlertMessage>(Collections.reverseOrder(PhdAlertMessage.COMPARATOR_BY_WHEN_CREATED_AND_ID));
        if (month == null) {
            for (PhdAlertMessage message : this.getLoggedPerson(request).getPhdAlertMessagesSet()) {
                if (year.intValue() != message.getWhenCreated().getYear()) continue;
                orderedMessages.add(message);
            }
        } else {
            for (PhdAlertMessage message : this.getLoggedPerson(request).getPhdAlertMessagesSet()) {
                if (year.intValue() != message.getWhenCreated().getYear() || month.getNumberOfMonth() != message.getWhenCreated().getMonthOfYear()) continue;
                orderedMessages.add(message);
            }
        }
        request.setAttribute("yearMonthBean", (Object)yearMonthBean);
        request.setAttribute("alertMessages", orderedMessages);
        return mapping.findForward("viewAlertMessageArchive");
    }

    public YearMonth getOrCreateBean(HttpServletRequest request) {
        YearMonth yearMonthBean = (YearMonth)this.getRenderedObject("yearMonthBean");
        RenderUtils.invalidateViewState();
        if (yearMonthBean == null) {
            yearMonthBean = this.createBeanFromRequest(request);
        }
        return yearMonthBean;
    }

    public YearMonth createBeanFromRequest(HttpServletRequest request) {
        String year = (String)this.getFromRequest(request, "year");
        String month = (String)this.getFromRequest(request, "month");
        YearMonth yearMonthBean = StringUtils.isEmpty((String)year) ? new YearMonth((Integer)Calendar.getInstance().get(1), null) : (StringUtils.isEmpty((String)month) ? new YearMonth(Integer.valueOf(year), null) : new YearMonth((int)Integer.valueOf(year), Integer.valueOf(month)));
        yearMonthBean.setFirstYear(2002);
        return yearMonthBean;
    }

    public ActionForward viewProcessAlertMessages(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        TreeSet<PhdAlertMessage> orderedMessages = new TreeSet<PhdAlertMessage>(Collections.reverseOrder(PhdAlertMessage.COMPARATOR_BY_WHEN_CREATED_AND_ID));
        orderedMessages.addAll(this.getProcess(request).getAlertMessagesForLoggedPerson());
        ArrayList<PhdAlertMessage> lastMessages = new ArrayList<PhdAlertMessage>();
        lastMessages.addAll(orderedMessages);
        request.setAttribute("unread", (Object)"false");
        request.setAttribute("alertMessages", lastMessages.subList(0, Math.min(lastMessages.size(), 100)));
        request.setAttribute("tooManyMessages", (Object)(lastMessages.size() > 100 ? "true" : "false"));
        return mapping.findForward("viewProcessAlertMessages");
    }

    public ActionForward viewUnreadProcessAlertMessages(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        TreeSet<PhdAlertMessage> orderedMessages = new TreeSet<PhdAlertMessage>(Collections.reverseOrder(PhdAlertMessage.COMPARATOR_BY_WHEN_CREATED_AND_ID));
        orderedMessages.addAll(this.getProcess(request).getUnreadAlertMessagesForLoggedPerson());
        request.setAttribute("unread", (Object)"true");
        request.setAttribute("alertMessages", orderedMessages);
        return mapping.findForward("viewProcessAlertMessages");
    }

    public ActionForward viewProcessAlertMessageArchive(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        YearMonth yearMonthBean = this.getOrCreateBean(request);
        return this.forwardToProcessAlertMessageArchive(mapping, request, yearMonthBean);
    }

    private ActionForward forwardToProcessAlertMessageArchive(ActionMapping mapping, HttpServletRequest request, YearMonth yearMonthBean) throws NumberFormatException {
        Integer year = yearMonthBean.getYear();
        if (year == null) {
            year = Integer.valueOf(ExecutionYear.readCurrentExecutionYear().getYear());
        }
        Month month = yearMonthBean.getMonth();
        TreeSet<PhdAlertMessage> orderedMessages = new TreeSet<PhdAlertMessage>(Collections.reverseOrder(PhdAlertMessage.COMPARATOR_BY_WHEN_CREATED_AND_ID));
        if (month == null) {
            for (PhdAlertMessage message : this.getProcess(request).getAlertMessagesForLoggedPerson()) {
                if (year.intValue() != message.getWhenCreated().getYear()) continue;
                orderedMessages.add(message);
            }
        } else {
            for (PhdAlertMessage message : this.getProcess(request).getAlertMessagesForLoggedPerson()) {
                if (year.intValue() != message.getWhenCreated().getYear() || month.getNumberOfMonth() != message.getWhenCreated().getMonthOfYear()) continue;
                orderedMessages.add(message);
            }
        }
        request.setAttribute("yearMonthBean", (Object)yearMonthBean);
        request.setAttribute("alertMessages", orderedMessages);
        return mapping.findForward("viewProcessAlertMessageArchive");
    }

    public ActionForward readAlertMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdAlertMessage alertMessage = this.getAlertMessage(request);
        alertMessage.markAsReaded(this.getLoggedPerson(request));
        String unread = (String)this.getFromRequest(request, "unread");
        String global = (String)this.getFromRequest(request, "global");
        String archive = (String)this.getFromRequest(request, "archive");
        String year = (String)this.getFromRequest(request, "year");
        String month = (String)this.getFromRequest(request, "month");
        request.setAttribute("unread", (Object)(unread != null ? unread : "false"));
        request.setAttribute("global", (Object)(global != null ? global : "true"));
        request.setAttribute("archive", (Object)(archive != null ? archive : "false"));
        request.setAttribute("year", (Object)(year != null ? year : String.valueOf(Calendar.getInstance().get(1))));
        request.setAttribute("month", (Object)(month != null ? month : ""));
        request.setAttribute("alertMessage", (Object)alertMessage);
        return mapping.findForward("viewAlertMessage");
    }

    public ActionForward markAlertMessageAsUnread(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PhdAlertMessage alertMessage = this.getAlertMessage(request);
        alertMessage.markAsUnread();
        Person loggedPerson = AccessControl.getPerson();
        boolean global = Boolean.valueOf((String)this.getFromRequest(request, "global"));
        boolean unread = Boolean.valueOf((String)this.getFromRequest(request, "unread"));
        boolean archive = Boolean.valueOf((String)this.getFromRequest(request, "archive"));
        request.setAttribute("global", (Object)global);
        if (global) {
            request.setAttribute("alertMessagesToNotify", loggedPerson.getUnreadedPhdAlertMessages());
            if (unread) {
                return this.viewUnreadAlertMessages(mapping, form, request, response);
            }
            if (archive) {
                return this.forwardToAlertMessageArchive(mapping, request, this.createBeanFromRequest(request));
            }
            return this.viewAlertMessages(mapping, form, request, response);
        }
        request.setAttribute("processAlertMessagesToNotify", this.getProcess(request).getUnreadedAlertMessagesFor(this.getLoggedPerson(request)));
        if (unread) {
            return this.viewUnreadProcessAlertMessages(mapping, form, request, response);
        }
        if (archive) {
            return this.forwardToProcessAlertMessageArchive(mapping, request, this.createBeanFromRequest(request));
        }
        return this.viewProcessAlertMessages(mapping, form, request, response);
    }

    private PhdAlertMessage getAlertMessage(HttpServletRequest request) {
        return (PhdAlertMessage)((Object)this.getDomainObject(request, "alertMessageId"));
    }

    public ActionForward prepareRequestPublicPresentationSeminarComission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        request.setAttribute("requestPublicPresentationSeminarComissionBean", (Object)new PublicPresentationSeminarProcessBean(process2));
        return mapping.findForward("requestPublicPresentationSeminarComission");
    }

    public ActionForward prepareRequestPublicPresentationSeminarComissionPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("requestPublicPresentationSeminarComissionBean", this.getRenderedObject("requestPublicPresentationSeminarComissionBean"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("requestPublicPresentationSeminarComission");
    }

    public ActionForward prepareRequestPublicPresentationSeminarComissionInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("requestPublicPresentationSeminarComissionBean", this.getRenderedObject("requestPublicPresentationSeminarComissionBean"));
        return mapping.findForward("requestPublicPresentationSeminarComission");
    }

    public ActionForward requestPublicPresentationSeminarComission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PublicPresentationSeminarProcessBean bean = (PublicPresentationSeminarProcessBean)this.getRenderedObject("requestPublicPresentationSeminarComissionBean");
        request.setAttribute("requestPublicPresentationSeminarComissionBean", (Object)bean);
        return this.executeActivity(RequestPublicPresentationSeminarComission.class, bean, request, mapping, "requestPublicPresentationSeminarComission", "viewProcess");
    }

    public ActionForward prepareExemptPublicPresentationSeminarComission(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("exemptPublicPresentationSeminarComission");
    }

    public ActionForward exemptPublicPresentationSeminarComission(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), ExemptPublicPresentationSeminarComission.class, (Object)new PublicPresentationSeminarProcessBean());
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.prepareExemptPublicPresentationSeminarComission(mapping, actionForm, request, response);
        }
        return this.viewProcess(mapping, actionForm, request, response);
    }

    public ActionForward viewCurriculum(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("curriculumFilter", (Object)new PhdCurriculumFilterOptions(this.getProcess(request).getRegistration()));
        return mapping.findForward("viewCurriculum");
    }

    public ActionForward changeViewCurriculumFilterOptions(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("curriculumFilter", this.getRenderedObject("curriculumFilter"));
        return mapping.findForward("viewCurriculum");
    }

    public ActionForward manageGuidanceDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("manageGuidanceDocuments");
    }

    public ActionForward prepareUploadGuidanceDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramDocumentUploadBean bean = new PhdProgramDocumentUploadBean();
        request.setAttribute("documentBean", (Object)bean);
        return mapping.findForward("uploadGuidanceDocument");
    }

    public ActionForward uploadGuidanceDocumentInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramDocumentUploadBean bean = (PhdProgramDocumentUploadBean)this.getRenderedObject("documentBean");
        request.setAttribute("documentBean", (Object)bean);
        return mapping.findForward("uploadGuidanceDocument");
    }

    public ActionForward uploadGuidanceDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramDocumentUploadBean bean = (PhdProgramDocumentUploadBean)this.getRenderedObject("documentBean");
        ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), UploadGuidanceDocument.class, (Object)bean);
        return this.manageGuidanceDocuments(mapping, form, request, response);
    }

    public ActionForward deleteGuidanceDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdGuidanceDocument document = (PhdGuidanceDocument)((Object)this.getDomainObject(request, "phdDocument"));
        ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), DeleteGuidanceDocument.class, (Object)document);
        return this.manageGuidanceDocuments(mapping, form, request, response);
    }

    public ActionForward downloadGuidanceDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.writeFile(response, this.getGuidanceDocumentsFilename(request), PhdDocumentsZip.ZIP_MIME_TYPE, this.createGuidanceDocumentsZip(request));
        return null;
    }

    protected String getGuidanceDocumentsFilename(HttpServletRequest request) {
        PhdIndividualProgramProcess process2 = this.getProcess(request);
        return String.format("%s-%s.zip", process2.getProcessNumber().replace("/", "-"), this.getMessageFromResource("label.phd.guidance.documents", new String[0]).replace(" ", "_"));
    }
}

