/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.student.enrollment.bolonha;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroupType;
import org.fenixedu.academic.dto.student.enrollment.bolonha.BolonhaStudentEnrollmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.ErasmusBolonhaStudentEnrollmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumGroupBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.ui.renderers.student.enrollment.bolonha.BolonhaStudentEnrolmentLayout;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixWebFramework.rendererExtensions.controllers.CopyCheckBoxValuesController;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyArrayConverter;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.components.HtmlActionLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlCheckBox;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlMultipleHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class ErasmusBolonhaStudentEnrolmentLayout
extends BolonhaStudentEnrolmentLayout {
    public CopyCheckBoxValuesController controller = new CopyCheckBoxValuesController();

    protected boolean isAcademicRelationsOfficeMember() {
        Person person = AccessControl.getPerson();
        return RoleType.INTERNATIONAL_RELATION_OFFICE.isMember(person.getUser()) || this.canPerformStudentEnrolments;
    }

    private boolean contains(List<CurricularCourse> curricularCourseList, final IDegreeModuleToEvaluate degreeModule) {
        if (!CurricularCourse.class.isAssignableFrom(degreeModule.getClass())) {
            return false;
        }
        return CollectionUtils.find(curricularCourseList, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((CurricularCourse)((Object)degreeModule)).isEquivalent((CurricularCourse)((Object)arg0));
            }
        }) != null;
    }

    @Override
    protected void generateCurricularCoursesToEnrol(HtmlTable groupTable, StudentCurriculumGroupBean studentCurriculumGroupBean) {
        List<IDegreeModuleToEvaluate> coursesToEvaluate = studentCurriculumGroupBean.getSortedDegreeModulesToEvaluate();
        this.generateCurricularCoursesToEnrol(groupTable, coursesToEvaluate);
    }

    private void generateCurricularCoursesToEnrol(HtmlTable groupTable, List<IDegreeModuleToEvaluate> coursesToEvaluate) {
        ErasmusBolonhaStudentEnrollmentBean bean = (ErasmusBolonhaStudentEnrollmentBean)this.getBolonhaStudentEnrollmentBean();
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : coursesToEvaluate) {
            if (!bean.getCandidacy().getCurricularCoursesSet().contains((Object)degreeModuleToEvaluate.getDegreeModule())) continue;
            HtmlTableRow htmlTableRow = groupTable.createRow();
            HtmlTableCell cellName = htmlTableRow.createCell();
            cellName.setClasses(this.getRenderer().getCurricularCourseToEnrolNameClasses());
            String degreeName = degreeModuleToEvaluate.getName();
            if (this.isAcademicRelationsOfficeMember() && degreeModuleToEvaluate.getDegreeModule() instanceof CurricularCourse) {
                if (!StringUtils.isEmpty((String)degreeModuleToEvaluate.getDegreeModule().getCode())) {
                    degreeName = degreeModuleToEvaluate.getDegreeModule().getCode() + " - " + degreeName;
                }
                CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModuleToEvaluate.getDegreeModule());
                degreeName = degreeName + " (" + BundleUtil.getString((String)"resources.StudentResources", (String)"label.grade.scale", (String[])new String[0]) + " - " + curricularCourse.getGradeScaleChain().getDescription() + ") ";
            }
            cellName.setBody((HtmlComponent)new HtmlText(degreeName));
            HtmlTableCell yearCell = htmlTableRow.createCell();
            yearCell.setClasses(this.getRenderer().getCurricularCourseToEnrolYearClasses());
            yearCell.setColspan(Integer.valueOf(2));
            yearCell.setBody((HtmlComponent)new HtmlText(degreeModuleToEvaluate.getYearFullLabel()));
            if (!degreeModuleToEvaluate.isOptionalCurricularCourse()) {
                HtmlTableCell ectsCell = htmlTableRow.createCell();
                ectsCell.setClasses(this.getRenderer().getCurricularCourseToEnrolEctsClasses());
                StringBuilder ects = new StringBuilder();
                ects.append(degreeModuleToEvaluate.getEctsCredits()).append(" ").append(BundleUtil.getString((String)"resources.StudentResources", (String)"label.credits.abbreviation", (String[])new String[0]));
                ectsCell.setBody((HtmlComponent)new HtmlText(ects.toString()));
                HtmlTableCell checkBoxCell = htmlTableRow.createCell();
                checkBoxCell.setClasses(this.getRenderer().getCurricularCourseToEnrolCheckBoxClasses());
                HtmlCheckBox checkBox = new HtmlCheckBox(false);
                checkBox.setName("degreeModuleToEnrolCheckBox" + degreeModuleToEvaluate.getKey());
                checkBox.setUserValue(degreeModuleToEvaluate.getKey());
                this.getDegreeModulesToEvaluateController().addCheckBox(checkBox);
                checkBoxCell.setBody((HtmlComponent)checkBox);
            } else {
                HtmlTableCell cell = htmlTableRow.createCell();
                cell.setClasses(this.getRenderer().getCurricularCourseToEnrolEctsClasses());
                cell.setBody((HtmlComponent)new HtmlText(""));
                HtmlTableCell linkTableCell = htmlTableRow.createCell();
                linkTableCell.setClasses(this.getRenderer().getCurricularCourseToEnrolCheckBoxClasses());
                HtmlActionLink actionLink = new HtmlActionLink();
                actionLink.setText(BundleUtil.getString((String)"resources.StudentResources", (String)"label.chooseOptionalCurricularCourse", (String[])new String[0]));
                actionLink.setController((HtmlController)new BolonhaStudentEnrolmentLayout.OptionalCurricularCourseLinkController(degreeModuleToEvaluate));
                actionLink.setOnClick("$(\\\"form[name='org.fenixedu.academic.ui.struts.FenixActionForm']\\\").method.value='prepareChooseOptionalCurricularCourseToEnrol';");
                actionLink.setName("optionalCurricularCourseLink" + degreeModuleToEvaluate.getCurriculumGroup().getExternalId() + "_" + degreeModuleToEvaluate.getContext().getExternalId());
                linkTableCell.setBody((HtmlComponent)actionLink);
            }
            if (!this.getRenderer().isEncodeCurricularRules()) continue;
            this.encodeCurricularRules(groupTable, degreeModuleToEvaluate);
        }
    }

    public boolean isContextValid(CurricularCourse curricularCourse) {
        Set parentContexts = curricularCourse.getParentContextsSet();
        for (Context context : parentContexts) {
            if (!context.isValid(this.getBolonhaStudentEnrollmentBean().getExecutionPeriod())) continue;
            return true;
        }
        return false;
    }

    @Override
    public HtmlComponent createComponent(Object object, Class type) {
        this.setBolonhaStudentEnrollmentBean((BolonhaStudentEnrollmentBean)object);
        if (this.getBolonhaStudentEnrollmentBean() == null) {
            return new HtmlText();
        }
        HtmlBlockContainer container = new HtmlBlockContainer();
        HtmlMultipleHiddenField hiddenEnrollments = new HtmlMultipleHiddenField();
        hiddenEnrollments.bind(this.getRenderer().getInputContext().getMetaObject(), "curriculumModulesToRemove");
        hiddenEnrollments.setConverter((Converter)new DomainObjectKeyArrayConverter());
        hiddenEnrollments.setController((HtmlController)this.getEnrollmentsController());
        HtmlMultipleHiddenField hiddenDegreeModulesToEvaluate = new HtmlMultipleHiddenField();
        hiddenDegreeModulesToEvaluate.bind(this.getRenderer().getInputContext().getMetaObject(), "degreeModulesToEvaluate");
        hiddenDegreeModulesToEvaluate.setConverter(this.getBolonhaStudentEnrollmentBean().getDegreeModulesToEvaluateConverter());
        hiddenDegreeModulesToEvaluate.setController((HtmlController)this.getDegreeModulesToEvaluateController());
        HtmlMultipleHiddenField hiddenExtraCurricularEnrollments = new HtmlMultipleHiddenField();
        hiddenExtraCurricularEnrollments.bind(this.getRenderer().getInputContext().getMetaObject(), "extraCurricularEnrolments");
        hiddenExtraCurricularEnrollments.setConverter((Converter)new ErasmusExtraCurricularEnrolmentConverter());
        hiddenExtraCurricularEnrollments.setController((HtmlController)this.controller);
        container.addChild((HtmlComponent)hiddenEnrollments);
        container.addChild((HtmlComponent)hiddenDegreeModulesToEvaluate);
        container.addChild((HtmlComponent)hiddenExtraCurricularEnrollments);
        this.generateGroup(container, this.getBolonhaStudentEnrollmentBean().getStudentCurricularPlan(), this.getBolonhaStudentEnrollmentBean().getRootStudentCurriculumGroupBean(), this.getBolonhaStudentEnrollmentBean().getExecutionPeriod(), 0);
        HtmlTable groupTable = this.createGroupTable(container, 0);
        HtmlTableRow htmlTableRow = groupTable.createRow();
        htmlTableRow.setClasses(this.getRenderer().getGroupRowClasses());
        htmlTableRow.createCell().setBody((HtmlComponent)new HtmlText("Other Curricular Units", false));
        HtmlTableCell cell = htmlTableRow.createCell();
        cell.setClasses("aright");
        HtmlCheckBox checkBox = new HtmlCheckBox(false);
        String name = "degreeModuleToEnrolCheckBox";
        checkBox.setName("degreeModuleToEnrolCheckBox");
        checkBox.setUserValue("true");
        checkBox.setChecked(true);
        cell.setBody((HtmlComponent)checkBox);
        groupTable = this.createCoursesTable(container, 0);
        NoCourseGroupCurriculumGroup group = this.getBolonhaStudentEnrollmentBean().getStudentCurricularPlan().getNoCourseGroupCurriculumGroup(NoCourseGroupCurriculumGroupType.STANDALONE);
        HashSet<CurricularCourse> set = new HashSet<CurricularCourse>();
        ErasmusBolonhaStudentEnrollmentBean erasmusBolonhaStudentEnrollmentBean = (ErasmusBolonhaStudentEnrollmentBean)this.getBolonhaStudentEnrollmentBean();
        set.addAll(erasmusBolonhaStudentEnrollmentBean.getCandidacy().getCurricularCoursesSet());
        for (Enrolment enrolment : group.getEnrolments()) {
            set.add(enrolment.getCurricularCourse());
        }
        for (CurricularCourse curricularCourse : set) {
            if (erasmusBolonhaStudentEnrollmentBean.getStudentCurricularPlan().getEnrolmentByCurricularCourseAndExecutionPeriod(curricularCourse, erasmusBolonhaStudentEnrollmentBean.getExecutionPeriod()) != null && !group.hasEnrolmentWithEnroledState(curricularCourse, erasmusBolonhaStudentEnrollmentBean.getExecutionPeriod()) || !this.isContextValid(curricularCourse)) continue;
            htmlTableRow = groupTable.createRow();
            HtmlTableCell cellName = htmlTableRow.createCell();
            cellName.setClasses(this.getRenderer().getCurricularCourseToEnrolNameClasses());
            String degreeName = curricularCourse.getName();
            if (this.isAcademicRelationsOfficeMember() && curricularCourse instanceof CurricularCourse) {
                if (!StringUtils.isEmpty((String)curricularCourse.getCode())) {
                    degreeName = curricularCourse.getCode() + " - " + degreeName;
                }
                degreeName = degreeName + " (" + BundleUtil.getString((String)"resources.StudentResources", (String)"label.grade.scale", (String[])new String[0]) + " - " + curricularCourse.getGradeScaleChain().getDescription() + ") ";
            }
            cellName.setBody((HtmlComponent)new HtmlText(degreeName));
            HtmlTableCell yearCell = htmlTableRow.createCell();
            yearCell.setClasses(this.getRenderer().getCurricularCourseToEnrolYearClasses());
            yearCell.setColspan(Integer.valueOf(2));
            yearCell.setBody((HtmlComponent)new HtmlText(this.getBolonhaStudentEnrollmentBean().getExecutionPeriod().getQualifiedName()));
            HtmlTableCell ectsCell = htmlTableRow.createCell();
            ectsCell.setClasses(this.getRenderer().getCurricularCourseToEnrolEctsClasses());
            StringBuilder ects = new StringBuilder();
            ects.append(curricularCourse.getEctsCredits()).append(" ").append(BundleUtil.getString((String)"resources.StudentResources", (String)"label.credits.abbreviation", (String[])new String[0]));
            ectsCell.setBody((HtmlComponent)new HtmlText(ects.toString()));
            HtmlTableCell checkBoxCell = htmlTableRow.createCell();
            checkBoxCell.setClasses(this.getRenderer().getCurricularCourseToEnrolCheckBoxClasses());
            checkBox = new HtmlCheckBox(false);
            checkBox.setName("extraCurricularEnrolments" + ((Object)((Object)curricularCourse)).getClass().getCanonicalName() + ":" + curricularCourse.getExternalId());
            checkBox.setUserValue(((Object)((Object)curricularCourse)).getClass().getCanonicalName() + ":" + curricularCourse.getExternalId());
            checkBoxCell.setBody((HtmlComponent)checkBox);
            this.controller.addCheckBox(checkBox);
            if (!group.hasEnrolmentWithEnroledState(curricularCourse, erasmusBolonhaStudentEnrollmentBean.getExecutionPeriod())) continue;
            cellName.setClasses(this.getRenderer().getEnrolmentNameClasses());
            yearCell.setClasses(this.getRenderer().getEnrolmentYearClasses());
            ectsCell.setClasses(this.getRenderer().getEnrolmentEctsClasses());
            checkBoxCell.setClasses(this.getRenderer().getEnrolmentCheckBoxClasses());
            checkBox.setChecked(true);
        }
        return container;
    }

    private static class ErasmusExtraCurricularEnrolmentConverter
    extends Converter {
        private ErasmusExtraCurricularEnrolmentConverter() {
        }

        public Object convert(Class type, Object value) {
            ArrayList<ErasmusBolonhaStudentEnrollmentBean.ErasmusExtraCurricularEnrolmentBean> list = new ArrayList<ErasmusBolonhaStudentEnrollmentBean.ErasmusExtraCurricularEnrolmentBean>();
            DomainObjectKeyConverter converter = new DomainObjectKeyConverter();
            for (String string : (String[])value) {
                list.add(new ErasmusBolonhaStudentEnrollmentBean.ErasmusExtraCurricularEnrolmentBean((CurricularCourse)((Object)converter.convert(type, (Object)string)), true));
            }
            return list;
        }
    }
}

