/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.predicate;

import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.predicate.AccessControlPredicate;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.bennu.core.security.Authenticate;

public class MarkSheetPredicates {
    public static final AccessControlPredicate<MarkSheet> confirmPredicate = new AccessControlPredicate<MarkSheet>(){

        @Override
        public boolean evaluate(MarkSheet markSheet) {
            return AcademicPredicates.MANAGE_MARKSHEETS.evaluate(null) && (!markSheet.isRectification() || MarkSheetPredicates.checkRectification(markSheet.getCurricularCourse().getDegree()));
        }
    };
    public static final AccessControlPredicate<MarkSheet> editPredicate = new AccessControlPredicate<MarkSheet>(){

        @Override
        public boolean evaluate(MarkSheet markSheet) {
            return MarkSheetPredicates.hasScientificCouncilRole() || MarkSheetPredicates.hasTeacherRole() || AcademicPredicates.MANAGE_MARKSHEETS.evaluate(null) && (!markSheet.isRectification() || MarkSheetPredicates.checkRectification(markSheet.getCurricularCourse().getDegree())) && (!markSheet.isDissertation() || MarkSheetPredicates.checkDissertation(markSheet.getCurricularCourse().getDegree()));
        }
    };
    public static final AccessControlPredicate<MarkSheet> rectifyPredicate = new AccessControlPredicate<MarkSheet>(){

        @Override
        public boolean evaluate(MarkSheet markSheet) {
            return MarkSheetPredicates.checkRectification(markSheet.getCurricularCourse().getDegree()) && (!markSheet.isDissertation() || MarkSheetPredicates.checkDissertation(markSheet.getCurricularCourse().getDegree()));
        }
    };
    public static final AccessControlPredicate<MarkSheet> removeGradesPredicate = new AccessControlPredicate<MarkSheet>(){

        @Override
        public boolean evaluate(MarkSheet markSheet) {
            return AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.REMOVE_GRADES, Authenticate.getUser()).collect(Collectors.toSet()).contains(markSheet.getCurricularCourse().getDegree());
        }
    };

    public static boolean checkRectification(Degree degree) {
        return AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.RECTIFICATION_MARKSHEETS, Authenticate.getUser()).collect(Collectors.toSet()).contains(degree);
    }

    public static boolean checkDissertation(Degree degree) {
        return AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.DISSERTATION_MARKSHEETS, Authenticate.getUser()).collect(Collectors.toSet()).contains(degree);
    }

    private static boolean hasScientificCouncilRole() {
        return RolePredicates.SCIENTIFIC_COUNCIL_PREDICATE.evaluate(null);
    }

    private static boolean hasTeacherRole() {
        return RolePredicates.TEACHER_PREDICATE.evaluate(null);
    }
}

