/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcess;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.dto.student.IRegistrationBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

public class RegistrationConclusionBean
implements Serializable,
IRegistrationBean {
    private static final long serialVersionUID = 5825221957160251388L;
    private Registration registration;
    private ProgramConclusion programConclusion;
    private Boolean hasAccessToRegistrationConclusionProcess = Boolean.TRUE;
    private LocalDate enteredConclusionDate;
    private String enteredFinalAverageGrade;
    private String enteredAverageGrade;
    private String enteredDescriptiveGrade;
    private String observations;

    public RegistrationConclusionBean(Registration registration) {
        this.setRegistration(registration);
    }

    @Deprecated
    public RegistrationConclusionBean(Registration registration, CycleType cycleType) {
        this(registration, (CurriculumGroup)((Object)registration.getLastStudentCurricularPlan().getCycle(cycleType)));
    }

    @Deprecated
    public RegistrationConclusionBean(Registration registration, CurriculumGroup curriculumGroup) {
        this.setRegistration(registration);
        this.setCurriculumGroup(curriculumGroup);
    }

    public RegistrationConclusionBean(Registration registration, ProgramConclusion programConclusion) {
        this.setRegistration(registration);
        this.setProgramConclusion(programConclusion);
    }

    public CurriculumGroup getCurriculumGroup() {
        return this.getProgramConclusion() == null ? null : (CurriculumGroup)this.getProgramConclusion().groupFor(this.getRegistration()).orElse(null);
    }

    public void setCurriculumGroup(CurriculumGroup curriculumGroup) {
        if (curriculumGroup.getDegreeModule().getProgramConclusion() != null) {
            this.setProgramConclusion(curriculumGroup.getDegreeModule().getProgramConclusion());
        } else {
            this.setProgramConclusion(null);
        }
    }

    public ProgramConclusion getProgramConclusion() {
        return this.programConclusion;
    }

    public void setProgramConclusion(ProgramConclusion programConclusion) {
        this.programConclusion = programConclusion;
    }

    public boolean hasCurriculumGroup() {
        return this.getCurriculumGroup() != null;
    }

    @Override
    public Registration getRegistration() {
        return this.registration;
    }

    public void setRegistration(Registration registration) {
        this.registration = registration;
    }

    public ExecutionYear getStartExecutionYear() {
        return this.getRegistration().getStartExecutionYear();
    }

    public Grade getFinalGrade() {
        if (this.isConclusionProcessed()) {
            return this.getCurriculumGroup().getFinalGrade();
        }
        return this.getCalculatedFinalGrade();
    }

    public Grade getCalculatedFinalGrade() {
        return this.getCurriculumGroup().calculateFinalGrade();
    }

    public Grade getRawGrade() {
        if (this.isConclusionProcessed()) {
            return this.getCurriculumGroup().getRawGrade();
        }
        return this.getCalculatedRawGrade();
    }

    public Grade getCalculatedRawGrade() {
        return this.getCurriculumGroup().calculateRawGrade();
    }

    public YearMonthDay getConclusionDate() {
        if (this.isConclusionProcessed()) {
            return this.getCurriculumGroup().getConclusionDate();
        }
        return this.calculateConclusionDate();
    }

    public YearMonthDay calculateConclusionDate() {
        return this.getCurriculumGroup().calculateConclusionDate();
    }

    public YearMonthDay getCalculatedConclusionDate() {
        return this.calculateConclusionDate();
    }

    public Grade getDescriptiveGrade() {
        if (this.isConclusionProcessed()) {
            return this.getCurriculumGroup().getDescriptiveGrade();
        }
        return null;
    }

    public String getDescriptiveGradeExtendedValue() {
        return this.getDescriptiveGrade() == null ? null : this.getDescriptiveGrade().getExtendedValue().getContent();
    }

    public ExecutionYear getIngressionYear() {
        if (this.isConclusionProcessed()) {
            return this.getCurriculumGroup().getIngressionYear();
        }
        return this.calculateIngressionYear();
    }

    public ExecutionYear calculateIngressionYear() {
        return this.getRegistration().calculateIngressionYear();
    }

    public ExecutionYear getConclusionYear() {
        if (this.isConclusionProcessed()) {
            return this.getCurriculumGroup().getConclusionYear();
        }
        return this.calculateConclusionYear();
    }

    public ExecutionYear calculateConclusionYear() {
        return this.getRegistration().calculateConclusionYear();
    }

    public ExecutionYear getCalculatedConclusionYear() {
        return this.calculateConclusionYear();
    }

    public boolean hasDissertationThesis() {
        return this.getRegistration().hasDissertationThesis();
    }

    public String getDissertationThesisTitle() {
        return this.hasDissertationThesis() ? this.getRegistration().getDissertationThesisTitle() : null;
    }

    public LocalDate getDissertationThesisDiscussedDate() {
        return this.hasDissertationThesis() ? this.getRegistration().getDissertationThesisDiscussedDate() : null;
    }

    public double getEctsCredits() {
        if (this.isConclusionProcessed()) {
            return this.getCurriculumGroup().getCreditsConcluded();
        }
        return this.calculateCredits();
    }

    public double calculateCredits() {
        return this.getCurriculumGroup().calculateCreditsConcluded();
    }

    public double getCalculatedEctsCredits() {
        return this.calculateCredits();
    }

    public ICurriculum getCurriculumForConclusion() {
        return this.getCurriculumGroup().getCurriculum();
    }

    public int getCurriculumEntriesSize() {
        return this.getCurriculumForConclusion().getCurriculumEntries().size();
    }

    public String getConclusionDegreeDescription() {
        return this.getRegistration().getDegreeDescription(this.getConclusionYear(), this.getProgramConclusion(), I18N.getLocale());
    }

    public boolean isConcluded() {
        return this.getCurriculumGroup().isConcluded();
    }

    public Collection<CurriculumModule> getCurriculumModulesWithNoConlusionDate() {
        HashSet<CurriculumModule> result = new HashSet<CurriculumModule>();
        if (this.isByGroup()) {
            this.getCurriculumGroup().assertConclusionDate(result);
        } else {
            this.getRegistration().assertConclusionDate(result);
        }
        return result;
    }

    public Collection<CurriculumGroup> getCurriculumGroupsNotVerifyingStructure() {
        if (this.isByGroup()) {
            HashSet<CurriculumGroup> result = new HashSet<CurriculumGroup>();
            if (!this.getCurriculumGroup().isSkipConcluded()) {
                this.getCurriculumGroup().assertCorrectStructure(result, this.getConclusionYear());
            }
            return result;
        }
        return Collections.emptyList();
    }

    public boolean isConclusionProcessed() {
        return this.getCurriculumGroup().isConclusionProcessed();
    }

    public boolean getCanBeConclusionProcessed() {
        return (!this.isConclusionProcessed() || this.isConclusionProcessed() && this.getRegistration().canRepeatConclusionProcess(AccessControl.getPerson())) && this.isConcluded();
    }

    public boolean getCanRepeatConclusionProcess() {
        return this.getRegistration().canRepeatConclusionProcess(AccessControl.getPerson());
    }

    public ConclusionProcess getConclusionProcess() {
        return this.getCurriculumGroup().getConclusionProcess();
    }

    public boolean isByGroup() {
        return this.hasCurriculumGroup();
    }

    public String getConclusionProcessNotes() {
        return this.getCurriculumGroup().getConclusionProcessNotes();
    }

    public Person getConclusionProcessResponsible() {
        return this.getCurriculumGroup().getConclusionProcessResponsible();
    }

    public Person getConclusionProcessLastResponsible() {
        return this.getCurriculumGroup().getConclusionProcessLastResponsible();
    }

    public DateTime getConclusionProcessCreationDateTime() {
        return this.getCurriculumGroup().getConclusionProcessCreationDateTime();
    }

    public DateTime getConclusionProcessLastModificationDateTime() {
        return this.getCurriculumGroup().getConclusionProcessLastModificationDateTime();
    }

    public boolean isSkipValidation() {
        return this.getProgramConclusion() != null && this.getProgramConclusion().isSkipValidation();
    }

    public Boolean getHasAccessToRegistrationConclusionProcess() {
        return this.hasAccessToRegistrationConclusionProcess;
    }

    public void setHasAccessToRegistrationConclusionProcess(Boolean hasAccessToRegistrationConclusionProcess) {
        this.hasAccessToRegistrationConclusionProcess = hasAccessToRegistrationConclusionProcess;
    }

    public LocalDate getEnteredConclusionDate() {
        return this.enteredConclusionDate;
    }

    public boolean hasEnteredConclusionDate() {
        return this.getEnteredConclusionDate() != null;
    }

    public void setEnteredConclusionDate(LocalDate enteredConclusionDate) {
        this.enteredConclusionDate = enteredConclusionDate;
    }

    public String getEnteredFinalAverageGrade() {
        return this.enteredFinalAverageGrade;
    }

    public void setEnteredFinalAverageGrade(String value) {
        this.enteredFinalAverageGrade = value;
    }

    public boolean hasEnteredFinalAverageGrade() {
        return !Strings.isNullOrEmpty((String)this.enteredFinalAverageGrade);
    }

    public String getEnteredAverageGrade() {
        return this.enteredAverageGrade;
    }

    public void setEnteredAverageGrade(String averageGrade) {
        this.enteredAverageGrade = averageGrade;
    }

    public boolean hasEnteredAverageGrade() {
        return !Strings.isNullOrEmpty((String)this.enteredAverageGrade);
    }

    public String getEnteredDescriptiveGrade() {
        return this.enteredDescriptiveGrade;
    }

    public void setEnteredDescriptiveGrade(String enteredDescriptiveGrade) {
        this.enteredDescriptiveGrade = enteredDescriptiveGrade;
    }

    public boolean hasEnteredDescriptiveGrade() {
        return !Strings.isNullOrEmpty((String)this.enteredDescriptiveGrade);
    }

    public String getObservations() {
        return this.observations;
    }

    public void setObservations(String observations) {
        this.observations = observations;
    }
}

