/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.academicAdministration;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;

public class DegreeByExecutionYearBean
implements Serializable,
Comparable<DegreeByExecutionYearBean> {
    private Degree degree;
    private DegreeType degreeType;
    private ExecutionYear executionYear;
    private Set<DegreeType> administratedDegreeTypes;
    private Set<Degree> administratedDegrees;

    public DegreeByExecutionYearBean() {
    }

    public DegreeByExecutionYearBean(Degree degree, ExecutionYear executionYear) {
        this.setDegree(degree);
        this.setDegreeType(degree.getDegreeType());
        this.setExecutionYear(executionYear);
    }

    public DegreeByExecutionYearBean(Set<DegreeType> administratedDegreeTypes, Set<Degree> administratedDegrees) {
        this.administratedDegreeTypes = administratedDegreeTypes;
        this.administratedDegrees = administratedDegrees;
    }

    public Set<DegreeType> getAdministratedDegreeTypes() {
        return this.administratedDegreeTypes;
    }

    public SortedSet<Degree> getAdministratedDegrees() {
        TreeSet<Degree> result = new TreeSet<Degree>(Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID);
        for (Degree degree : this.administratedDegrees) {
            if (this.executionYear != null && degree.getExecutionDegreesForExecutionYear(this.executionYear).isEmpty() || this.degreeType != null && !this.degreeType.equals(degree.getDegreeType())) continue;
            result.add(degree);
        }
        return result;
    }

    public Degree getDegree() {
        return this.degree;
    }

    public void setDegree(Degree degree) {
        this.degree = degree;
    }

    public DegreeType getDegreeType() {
        return this.degreeType;
    }

    public void setDegreeType(DegreeType degreeType) {
        this.degreeType = degreeType;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public String getDegreeName() {
        return this.getDegree().getNameFor(this.getExecutionYear().getAcademicInterval()).getContent();
    }

    public String getDegreePresentationName() {
        return this.getDegree().getPresentationName(this.getExecutionYear());
    }

    public String getKey() {
        return this.getDegree().getExternalId() + ":" + this.getExecutionYear().getExternalId();
    }

    public boolean equals(Object obj) {
        return obj instanceof DegreeByExecutionYearBean ? this.equals((DegreeByExecutionYearBean)obj) : false;
    }

    public boolean equals(DegreeByExecutionYearBean bean) {
        return this.getDegree() == bean.getDegree();
    }

    public int hashCode() {
        Degree degree = this.getDegree();
        if (degree != null) {
            return this.getDegree().hashCode();
        }
        return 0;
    }

    public Collection<DegreeCurricularPlan> getDegreeCurricularPlans() {
        return this.getDegree().getDegreeCurricularPlansSet();
    }

    @Override
    public int compareTo(DegreeByExecutionYearBean other) {
        return other == null ? 1 : Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID.compare(this.getDegree(), other.getDegree());
    }
}

