/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.EctsTableIndex;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.enrolment.DismissalCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.log.DismissalLog;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.domain.studentCurriculum.CreditsDismissal;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal_Base;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.OptionalDismissal;
import org.fenixedu.academic.util.EnrolmentAction;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class Dismissal
extends Dismissal_Base
implements ICurriculumEntry {
    public Dismissal() {
    }

    public Dismissal(Credits credits, CurriculumGroup curriculumGroup, CurricularCourse curricularCourse) {
        this.init(credits, curriculumGroup, curricularCourse);
        this.createCurriculumLineLog(EnrolmentAction.ENROL);
    }

    protected void init(Credits credits, CurriculumGroup curriculumGroup) {
        if (credits == null || curriculumGroup == null) {
            throw new DomainException("error.dismissal.wrong.arguments", new String[0]);
        }
        this.setCredits(credits);
        this.setCurriculumGroup(curriculumGroup);
    }

    protected void init(Credits credits, CurriculumGroup curriculumGroup, CurricularCourse curricularCourse) {
        if (curricularCourse == null) {
            throw new DomainException("error.dismissal.wrong.arguments", new String[0]);
        }
        this.checkCurriculumGroupCurricularCourse(credits, curriculumGroup, curricularCourse);
        this.init(credits, curriculumGroup);
        this.setCurricularCourse(curricularCourse);
    }

    private void checkCurriculumGroupCurricularCourse(Credits credits, CurriculumGroup curriculumGroup, CurricularCourse curricularCourse) {
        if (!(curriculumGroup instanceof NoCourseGroupCurriculumGroup) && !curriculumGroup.getCurricularCoursesToDismissal(credits.getExecutionPeriod()).contains((Object)curricularCourse)) {
            throw new DomainException("error.dismissal.invalid.curricular.course.to.dismissal", curriculumGroup.getName().getContent(), curricularCourse.getName(), credits.getExecutionPeriod().getQualifiedName());
        }
    }

    protected static Dismissal createNewDismissal(Credits credits, StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup, Collection<CurricularCourse> noEnrolCurricularCourses) {
        return new CreditsDismissal(credits, Dismissal.findCurriculumGroupForCourseGroup(studentCurricularPlan, courseGroup), noEnrolCurricularCourses);
    }

    protected static Dismissal createNewDismissal(Credits credits, StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, Collection<CurricularCourse> noEnrolCurricularCourses) {
        return new CreditsDismissal(credits, curriculumGroup, noEnrolCurricularCourses);
    }

    private static CurriculumGroup findCurriculumGroupForCourseGroup(StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup) {
        CurriculumGroup curriculumGroup = studentCurricularPlan.findCurriculumGroupFor(courseGroup);
        if (curriculumGroup != null) {
            return curriculumGroup;
        }
        throw new DomainException("error.studentCurricularPlan.doesnot.have.courseGroup", courseGroup.getName());
    }

    protected static Dismissal createNewDismissal(Credits credits, StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, CurricularCourse curricularCourse) {
        return new Dismissal(credits, curriculumGroup, curricularCourse);
    }

    protected static Dismissal createNewOptionalDismissal(Credits credits, StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, OptionalCurricularCourse optionalCurricularCourse, Double ectsCredits) {
        return new OptionalDismissal(credits, curriculumGroup, optionalCurricularCourse, ectsCredits);
    }

    public StringBuilder print(String tabs) {
        StringBuilder builder = new StringBuilder();
        builder.append(tabs);
        builder.append("[D ").append(this.getDegreeModule() != null ? this.getDegreeModule().getName() : "").append(" ");
        builder.append(this.getEctsCredits()).append(" ects ]\n");
        return builder;
    }

    public boolean isApproved() {
        return true;
    }

    public boolean isValid(ExecutionSemester executionSemester) {
        return this.hasExecutionPeriod() && this.getExecutionPeriod().equals(executionSemester);
    }

    public final ExecutionYear getIEnrolmentsLastExecutionYear() {
        ExecutionYear result = null;
        for (IEnrolment iEnrolment : this.getSourceIEnrolments()) {
            ExecutionYear executionYear = iEnrolment.getExecutionYear();
            if (result != null && !result.isBefore(executionYear)) continue;
            result = executionYear;
        }
        return result;
    }

    public Collection<IEnrolment> getSourceIEnrolments() {
        return this.getCredits().getIEnrolments();
    }

    public final boolean hasSourceIEnrolments(IEnrolment iEnrolment) {
        return this.getCredits().hasIEnrolments(iEnrolment);
    }

    public boolean isApproved(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return (executionSemester == null || !this.hasExecutionPeriod() || this.getExecutionPeriod().isBeforeOrEquals(executionSemester)) && this.hasCurricularCourse(this.getCurricularCourse(), curricularCourse, executionSemester);
    }

    public Double getEctsCredits() {
        return this.getCurricularCourse().isOptionalCurricularCourse() ? this.getEnrolmentsEcts() : this.getCurricularCourse().getEctsCredits(this.getExecutionPeriod());
    }

    @Override
    public final BigDecimal getEctsCreditsForCurriculum() {
        return BigDecimal.valueOf(this.getEctsCredits());
    }

    public double getAccumulatedEctsCredits(ExecutionSemester executionSemester) {
        return this.getEctsCredits();
    }

    protected Double getEnrolmentsEcts() {
        return this.getCredits().getEnrolmentsEcts();
    }

    public Double getAprovedEctsCredits() {
        return this.isExtraCurricular() ? Double.valueOf(0.0) : this.getEctsCredits();
    }

    public Double getEnroledEctsCredits(ExecutionSemester executionSemester) {
        return 0.0;
    }

    public Double getEnroledEctsCredits(ExecutionYear executionYear) {
        return 0.0;
    }

    public void collectDismissals(List<Dismissal> result) {
        result.add(this);
    }

    public boolean isDismissal() {
        return true;
    }

    public boolean isSimilar(Dismissal dismissal) {
        return this.hasSameDegreeModules(dismissal) && this.hasSameSourceIEnrolments(this.getSourceIEnrolments(), dismissal);
    }

    protected boolean hasSameDegreeModules(Dismissal dismissal) {
        return this.getDegreeModule() == dismissal.getDegreeModule() || this.getCurricularCourse().isEquivalent(dismissal.getCurricularCourse());
    }

    protected boolean hasSameSourceIEnrolments(Collection<IEnrolment> ienrolments, Dismissal dismissal) {
        return ienrolments.containsAll(dismissal.getSourceIEnrolments()) && ienrolments.size() == dismissal.getSourceIEnrolments().size();
    }

    public Dismissal getDismissal(CurricularCourse curricularCourse) {
        return this.getCurricularCourse() == curricularCourse ? this : null;
    }

    void deleteFromCredits() {
        this.createCurriculumLineLog(EnrolmentAction.UNENROL);
        this.setCredits(null);
        super.delete();
    }

    public void delete() {
        this.createCurriculumLineLog(EnrolmentAction.UNENROL);
        Credits credits = this.getCredits();
        this.setCredits(null);
        if (credits != null && credits.getDismissalsSet().isEmpty()) {
            credits.delete();
        }
        super.delete();
    }

    public CurriculumModule.ConclusionValue isConcluded(ExecutionYear executionYear) {
        return CurriculumModule.ConclusionValue.create(executionYear == null || !this.hasExecutionPeriod() || this.getExecutionPeriod().getExecutionYear().isBeforeOrEquals(executionYear));
    }

    public Double getCreditsConcluded(ExecutionYear executionYear) {
        return this.isConcluded(executionYear).value() && !this.getCredits().isTemporary() ? this.getEctsCredits() : Double.valueOf(0.0);
    }

    public YearMonthDay calculateConclusionDate() {
        if (this.getCredits().getOfficialDate() != null) {
            return new YearMonthDay((Object)this.getCredits().getOfficialDate());
        }
        TreeSet<IEnrolment> iEnrolments = new TreeSet<IEnrolment>(IEnrolment.COMPARATOR_BY_APPROVEMENT_DATE);
        iEnrolments.addAll(this.getSourceIEnrolments());
        YearMonthDay beginDate = this.getExecutionPeriod().getBeginDateYearMonthDay();
        if (!iEnrolments.isEmpty()) {
            IEnrolment enrolment = (IEnrolment)iEnrolments.last();
            YearMonthDay approvementDate = enrolment.getApprovementDate();
            return approvementDate != null ? approvementDate : beginDate;
        }
        return beginDate;
    }

    public final Curriculum getCurriculum(DateTime when, ExecutionYear year) {
        if (this.wasCreated(when) && (year == null || !this.hasExecutionPeriod() || this.getExecutionYear().isBeforeOrEquals(year))) {
            Collection<ICurriculumEntry> averageEntries = this.getAverageEntries(year);
            if (!averageEntries.isEmpty() || this.getCredits().isCredits()) {
                return new Curriculum((CurriculumModule)((Object)this), year, Collections.EMPTY_SET, averageEntries, Collections.singleton(this));
            }
        } else if (this.getCredits().isInternalSubstitution()) {
            return this.getCredits().getCurriculum(this, when, year);
        }
        return Curriculum.createEmpty((CurriculumModule)((Object)this), year);
    }

    private Collection<ICurriculumEntry> getAverageEntries(ExecutionYear year) {
        if (this.getCredits().isEquivalence() && (year == null || !this.hasExecutionPeriod() || this.getExecutionYear().isBefore(year))) {
            return Collections.singleton(this);
        }
        return this.getCredits().getAverageEntries(year);
    }

    @Override
    public Grade getGrade() {
        return this.getCredits().isEquivalence() ? this.getCredits().getGrade() : Grade.createEmptyGrade();
    }

    @Override
    public String getGradeValue() {
        return this.getGrade().getValue();
    }

    public Double getWeigth() {
        return this.getCredits().isEquivalence() ? this.getEctsCredits() : null;
    }

    @Override
    public final BigDecimal getWeigthForCurriculum() {
        return BigDecimal.valueOf(this.getWeigth());
    }

    @Override
    public String getCode() {
        return this.hasCurricularCourse() ? this.getCurricularCourse().getCode() : null;
    }

    @Override
    public ExecutionSemester getExecutionPeriod() {
        return this.getCredits().getExecutionPeriod();
    }

    public Set<IDegreeModuleToEvaluate> getDegreeModulesToEvaluate(ExecutionSemester executionSemester) {
        if (executionSemester != null && executionSemester != this.getExecutionPeriod()) {
            return Collections.EMPTY_SET;
        }
        HashSet<IDegreeModuleToEvaluate> result = new HashSet<IDegreeModuleToEvaluate>(1);
        result.add(new DismissalCurriculumModuleWrapper(this, executionSemester));
        return result;
    }

    protected void createCurriculumLineLog(EnrolmentAction action) {
        new DismissalLog(action, this.getRegistration(), this.getCurricularCourse(), this.getCredits(), this.getExecutionPeriod(), this.getCurrentUser());
    }

    public Grade getEctsGrade(DateTime processingDate) {
        return EctsTableIndex.convertGradeToEcts(this.getCurricularCourse(), (CurriculumLine)((Object)this), this.getGrade(), processingDate);
    }

    public String getEnrolmentTypeName() {
        if (this.isExtraCurricular()) {
            return "EXTRA_CURRICULAR_ENROLMENT";
        }
        if (this.isOptional()) {
            return "ENROLMENT_IN_OPTIONAL_DEGREE_MODULE";
        }
        return "COMPULSORY_ENROLMENT";
    }

    public boolean isAnual() {
        CurricularCourse curricularCourse = this.getCurricularCourse();
        return curricularCourse != null && curricularCourse.isAnual();
    }

    public String getModuleTypeName() {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)this.getClass().getName(), (String[])new String[0]);
    }
}

