/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituation;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.PartialRegistrationRegimeRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationRegime;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;

public class PartialRegistrationRegimeRequest
extends PartialRegistrationRegimeRequest_Base {
    private PartialRegistrationRegimeRequest() {
    }

    public PartialRegistrationRegimeRequest(RegistrationAcademicServiceRequestCreateBean bean) {
        this();
        super.init(bean);
    }

    protected void checkRulesToChangeState(AcademicServiceRequestSituationType situationType) {
        super.checkRulesToChangeState(situationType);
        if (situationType == AcademicServiceRequestSituationType.PROCESSING) {
            this.checkEctsCredits(this.getRegistration(), this.getExecutionYear());
        }
    }

    private void checkEctsCredits(Registration registration, ExecutionYear executionYear) {
        StudentCurricularPlan studentCurricularPlan = registration.getLastStudentCurricularPlan();
        double enroledEctsCredits = 0.0;
        for (ExecutionSemester semester : executionYear.getExecutionPeriodsSet()) {
            enroledEctsCredits += studentCurricularPlan.getAccumulatedEctsCredits(semester);
        }
        if (enroledEctsCredits > 20.25) {
            throw new DomainException("error.RegistrationRegime.semester.has.more.ects.than.maximum.allowed", String.valueOf(enroledEctsCredits), executionYear.getQualifiedName(), String.valueOf(20.25));
        }
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        if (academicServiceRequestBean.isToConclude()) {
            academicServiceRequestBean.setSituationDate(this.getActiveSituation().getSituationDate().toYearMonthDay());
        }
    }

    protected boolean isPayed() {
        return super.isPayed();
    }

    protected void createAcademicServiceRequestSituations(AcademicServiceRequestBean academicServiceRequestBean) {
        super.createAcademicServiceRequestSituations(academicServiceRequestBean);
        if (academicServiceRequestBean.isToConclude()) {
            AcademicServiceRequestSituation.create((AcademicServiceRequest)((Object)this), new AcademicServiceRequestBean(AcademicServiceRequestSituationType.DELIVERED, academicServiceRequestBean.getResponsible()));
            if (!this.getRegistration().isPartialRegime(this.getExecutionYear())) {
                new RegistrationRegime(this.getRegistration(), this.getExecutionYear(), RegistrationRegimeType.PARTIAL_TIME);
            }
        }
    }

    public boolean isAvailableForTransitedRegistrations() {
        return false;
    }

    public AcademicServiceRequestType getAcademicServiceRequestType() {
        return AcademicServiceRequestType.PARTIAL_REGIME_REQUEST;
    }

    public EventType getEventType() {
        if (this.getExecutionYear().isAfterOrEquals(ExecutionYear.readExecutionYearByName("2010/2011"))) {
            return null;
        }
        return EventType.PARTIAL_REGISTRATION_REGIME_REQUEST;
    }

    public boolean hasPersonalInfo() {
        return false;
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return false;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public boolean isToPrint() {
        return false;
    }
}

