/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.debts;

import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.phd.debts.PhdThesisRequestFee;
import org.fenixedu.academic.domain.phd.debts.PhdThesisRequestFeePR_Base;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class PhdThesisRequestFeePR
extends PhdThesisRequestFeePR_Base {
    private PhdThesisRequestFeePR() {
    }

    public PhdThesisRequestFeePR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount) {
        this();
        super.init(EntryType.PHD_THESIS_REQUEST_FEE, EventType.PHD_THESIS_REQUEST_FEE, startDate, endDate, serviceAgreementTemplate, fixedAmount);
    }

    public PhdThesisRequestFeePR edit(Money fixedAmount, Money penaltyAmount) {
        this.deactivate();
        return new PhdThesisRequestFeePR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), fixedAmount);
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        PhdThesisRequestFee requestEvent = (PhdThesisRequestFee)((Object)event);
        if (requestEvent.hasPhdEventExemption()) {
            amountToPay = amountToPay.subtract(requestEvent.getPhdEventExemption().getValue());
        }
        return amountToPay.isPositive() ? amountToPay : Money.ZERO;
    }
}

