/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.messaging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.accessControl.UnitGroup;
import org.fenixedu.academic.domain.messaging.DepartmentForum_Base;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.groups.UnionGroup;
import org.fenixedu.bennu.core.groups.UserGroup;

public class DepartmentForum
extends DepartmentForum_Base {
    public Group getReadersGroup() {
        return this.getDepartmentForumGroup();
    }

    public Group getWritersGroup() {
        return this.getDepartmentForumGroup();
    }

    public Group getAdminGroup() {
        return UserGroup.of(Person.convertToUsers(this.getDepartmentManagers()));
    }

    public Department getDepartment() {
        for (Department department : Bennu.getInstance().getDepartmentsSet()) {
            if (!this.equals((Object)department.getDepartmentForum())) continue;
            return department;
        }
        return null;
    }

    public Group getDepartmentForumGroup() {
        HashSet<UnitGroup> groups = new HashSet<UnitGroup>();
        Department department = this.getDepartment();
        groups.add(UnitGroup.recursiveWorkers((Unit)((Object)department.getDepartmentUnit())));
        groups.add((UnitGroup)UserGroup.of(Person.convertToUsers(this.getPersonsFromTeachers(department))));
        return UnionGroup.of(groups);
    }

    private Collection<Person> getDepartmentManagers() {
        return Collections.emptySet();
    }

    private List<Person> getPersonsFromTeachers(Department department) {
        ArrayList<Person> persons = new ArrayList<Person>();
        for (Teacher teacher : department.getAllCurrentTeachers()) {
            persons.add(teacher.getPerson());
        }
        return persons;
    }
}

