/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.TreeSet;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;

public enum CycleType {
    FIRST_CYCLE((Integer)1, 180.0),
    SECOND_CYCLE(2, FIRST_CYCLE, 120.0),
    THIRD_CYCLE(3),
    SPECIALIZATION_CYCLE(4),
    SINGLE_CYCLE(5);

    public static final Comparator<CycleType> COMPARATOR_BY_LESS_WEIGHT;
    public static final Comparator<CycleType> COMPARATOR_BY_GREATER_WEIGHT;
    private Integer weight;
    private CycleType sourceCycleAffinity;
    private Double credits;

    private CycleType(Integer weight) {
        this(weight, (CycleType)null);
    }

    private CycleType(Integer weight, CycleType sourceCycleAffinity) {
        this.weight = weight;
        this.sourceCycleAffinity = sourceCycleAffinity;
        this.credits = 0.0;
    }

    private CycleType(Integer weight, Double credits) {
        this(weight, null, credits);
    }

    private CycleType(Integer weight, CycleType sourceCycleAffinity, Double credits) {
        this.weight = weight;
        this.sourceCycleAffinity = sourceCycleAffinity;
        this.credits = credits;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public String getQualifiedName() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name();
    }

    public String getDescription() {
        return this.getDescription(I18N.getLocale());
    }

    public String getDescription(Locale locale) {
        return BundleUtil.getString((String)"resources.EnumerationResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
    }

    public Double getEctsCredits() {
        return this.credits;
    }

    public static final Collection<CycleType> getSortedValues() {
        TreeSet<CycleType> result = new TreeSet<CycleType>(COMPARATOR_BY_LESS_WEIGHT);
        result.addAll(Arrays.asList(CycleType.values()));
        return result;
    }

    public boolean isBeforeOrEquals(CycleType cycleType) {
        return COMPARATOR_BY_LESS_WEIGHT.compare(this, cycleType) <= 0;
    }

    public boolean hasSourceCycleAffinity() {
        return this.sourceCycleAffinity != null;
    }

    public CycleType getSourceCycleAffinity() {
        return this.sourceCycleAffinity;
    }

    public CycleType getNext() {
        Iterator<CycleType> iterator = CycleType.getSortedValues().iterator();
        CycleType cycleType = iterator.next();
        while (iterator.hasNext()) {
            if (cycleType == this) {
                return iterator.next();
            }
            cycleType = iterator.next();
        }
        return null;
    }

    public boolean hasNext() {
        return this.getNext() != null;
    }

    public CycleType getPrevious() {
        ArrayList<CycleType> sortedValues = new ArrayList<CycleType>(CycleType.getSortedValues());
        ListIterator listIterator = sortedValues.listIterator(sortedValues.size());
        CycleType cycleType = (CycleType)((Object)listIterator.previous());
        while (listIterator.hasPrevious()) {
            if (cycleType == this) {
                return (CycleType)((Object)listIterator.previous());
            }
            cycleType = (CycleType)((Object)listIterator.previous());
        }
        return null;
    }

    public boolean hasPrevious() {
        return this.getPrevious() != null;
    }

    public LocalizedString getDescriptionI18N() {
        LocalizedString result = new LocalizedString();
        for (Locale locale : CoreConfiguration.supportedLocales()) {
            result = result.with(locale, this.getDescription(locale));
        }
        return result;
    }

    static {
        COMPARATOR_BY_LESS_WEIGHT = new Comparator<CycleType>(){

            @Override
            public int compare(CycleType o1, CycleType o2) {
                return o1.getWeight().compareTo(o2.getWeight());
            }
        };
        COMPARATOR_BY_GREATER_WEIGHT = new Comparator<CycleType>(){

            @Override
            public int compare(CycleType o1, CycleType o2) {
                return -COMPARATOR_BY_LESS_WEIGHT.compare(o1, o2);
            }
        };
    }
}

