/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CompositeRule;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.Exclusiveness_Base;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.ExclusivenessVerifier;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.GenericPair;

public class Exclusiveness
extends Exclusiveness_Base {
    protected Exclusiveness(DegreeModule toApplyRule, DegreeModule exclusiveDegreeModule, CourseGroup contextCourseGroup, ExecutionSemester begin, ExecutionSemester end) {
        this.checkParameters(toApplyRule, exclusiveDegreeModule);
        this.init(toApplyRule, contextCourseGroup, begin, end, CurricularRuleType.EXCLUSIVENESS);
        this.setExclusiveDegreeModule(exclusiveDegreeModule);
    }

    private void checkParameters(DegreeModule toApplyRule, DegreeModule exclusiveDegreeModule) {
        if (exclusiveDegreeModule == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
        if (toApplyRule == exclusiveDegreeModule) {
            throw new DomainException("curricular.rule.invalid.parameters.degreeModules.must.be.different", new String[0]);
        }
        if (toApplyRule.isLeaf() ? !exclusiveDegreeModule.isLeaf() : exclusiveDegreeModule.isLeaf()) {
            throw new DomainException("curricular.rule.invalid.parameters.degreeModules.must.have.same.type", new String[0]);
        }
    }

    protected void edit(DegreeModule exclusiveDegreeModule, CourseGroup contextCourseGroup) {
        this.checkParameters(this.getDegreeModuleToApplyRule(), exclusiveDegreeModule);
        if (exclusiveDegreeModule != this.getExclusiveDegreeModule()) {
            this.removeRuleFromCurrentExclusiveDegreeModule(this.getExclusiveDegreeModule().getCurricularRulesSet().iterator());
            new Exclusiveness(exclusiveDegreeModule, this.getDegreeModuleToApplyRule(), contextCourseGroup, this.getBegin(), this.getEnd());
        }
        this.setExclusiveDegreeModule(exclusiveDegreeModule);
        this.setContextCourseGroup(contextCourseGroup);
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        ArrayList<GenericPair<Object, Boolean>> labelList = new ArrayList<GenericPair<Object, Boolean>>();
        labelList.add(new GenericPair<String, Boolean>("label.exclusiveness", true));
        labelList.add(new GenericPair<String, Boolean>(" ", false));
        labelList.add(new GenericPair<String, Boolean>("label.between", true));
        labelList.add(new GenericPair<String, Boolean>(" ", false));
        String degreeModuleToApplyRule = this.getDegreeModuleToApplyRule().isLeaf() ? this.getDegreeModuleToApplyRule().getName() : this.getDegreeModuleToApplyRule().getOneFullName();
        String exclusiveDegreeModule = this.getExclusiveDegreeModule().isLeaf() ? this.getExclusiveDegreeModule().getName() : this.getExclusiveDegreeModule().getOneFullName();
        labelList.add(new GenericPair<String, Boolean>(degreeModuleToApplyRule, false));
        labelList.add(new GenericPair<String, Boolean>(" ", false));
        labelList.add(new GenericPair<String, Boolean>("label.and", true));
        labelList.add(new GenericPair<String, Boolean>(" ", false));
        labelList.add(new GenericPair<String, Boolean>(exclusiveDegreeModule, false));
        labelList.add(new GenericPair<String, Boolean>(" ", false));
        if (this.getContextCourseGroup() != null) {
            labelList.add(new GenericPair<String, Boolean>(", ", false));
            labelList.add(new GenericPair<String, Boolean>("label.inGroup", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(this.getContextCourseGroup().getOneFullName(), false));
        }
        return labelList;
    }

    protected void removeOwnParameters() {
        this.removeRuleFromCurrentExclusiveDegreeModule(this.getExclusiveDegreeModule().getCurricularRulesSet().iterator());
        this.setExclusiveDegreeModule(null);
    }

    private void removeRuleFromCurrentExclusiveDegreeModule(Iterator<CurricularRule> curricularRulesIterator) {
        while (curricularRulesIterator.hasNext()) {
            CurricularRule curricularRule = curricularRulesIterator.next();
            if (curricularRule.getCurricularRuleType() == null) {
                CompositeRule compositeRule = (CompositeRule)((Object)curricularRule);
                this.removeRuleFromCurrentExclusiveDegreeModule(compositeRule.getCurricularRulesSet().iterator());
                continue;
            }
            if (curricularRule.getCurricularRuleType() != this.getCurricularRuleType()) continue;
            this.removeExclusivenessRule(curricularRulesIterator, (Exclusiveness)((Object)curricularRule));
        }
    }

    private void removeExclusivenessRule(Iterator<CurricularRule> curricularRulesIterator, Exclusiveness exclusiveness) throws DomainException {
        if (exclusiveness.getExclusiveDegreeModule() == this.getDegreeModuleToApplyRule()) {
            if (exclusiveness.belongsToCompositeRule()) {
                if (this.belongsToCompositeRule()) {
                    new Exclusiveness(exclusiveness.getExclusiveDegreeModule(), exclusiveness.getDegreeModuleToApplyRule(), exclusiveness.getContextCourseGroup(), exclusiveness.getBegin(), exclusiveness.getEnd());
                    return;
                }
                throw new DomainException("error.cannot.delete.rule.because.belongs.to.composite.rule", exclusiveness.getDegreeModuleToApplyRule().getName());
            }
            curricularRulesIterator.remove();
            exclusiveness.setExclusiveDegreeModule(null);
            exclusiveness.removeCommonParameters();
            exclusiveness.deleteDomainObject();
        }
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return new ExclusivenessVerifier();
    }
}

