/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy.degree;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacy.degree.ShiftDistributionEntry;
import org.fenixedu.academic.domain.candidacy.degree.ShiftDistribution_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;

public class ShiftDistribution
extends ShiftDistribution_Base {
    private ShiftDistribution() {
        super.setRootDomainObject(Bennu.getInstance());
    }

    public ShiftDistribution(ExecutionYear executionYear) {
        this();
        this.init(executionYear);
    }

    private void checkParameters(ExecutionYear executionYear) {
        if (executionYear == null) {
            throw new DomainException("error.candidacy.degree.ShiftDistribution.executionYear.cannot.be.null", new String[0]);
        }
    }

    protected void init(ExecutionYear executionYear) {
        this.checkParameters(executionYear);
        if (executionYear.getShiftDistribution() != null) {
            throw new DomainException("error.candidacy.degree.ShiftDistribution.executionYear.already.has.a.shiftDistribution", new String[0]);
        }
        super.setExecutionYear(executionYear);
    }

    public void delete() {
        while (!this.getShiftDistributionEntriesSet().isEmpty()) {
            ((ShiftDistributionEntry)((Object)this.getShiftDistributionEntriesSet().iterator().next())).delete();
        }
        super.setExecutionYear(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public List<ShiftDistributionEntry> getEntriesByStudentNumber(Integer studentNumber) {
        ArrayList<ShiftDistributionEntry> result = new ArrayList<ShiftDistributionEntry>();
        for (ShiftDistributionEntry shiftDistributionEntry : this.getShiftDistributionEntriesSet()) {
            if (!shiftDistributionEntry.getAbstractStudentNumber().equals(studentNumber)) continue;
            result.add(shiftDistributionEntry);
        }
        return result;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        throw new DomainException("error.candidacy.degree.ShiftDistribution.cannot.modify.executionYear", new String[0]);
    }

    public boolean contains(int abstractStudentNumber, ExecutionDegree executionDegree) {
        for (ShiftDistributionEntry distributionEntry : executionDegree.getShiftDistributionEntriesSet()) {
            if (distributionEntry.getAbstractStudentNumber() != abstractStudentNumber) continue;
            return true;
        }
        return false;
    }
}

