/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.gratuity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.DFAGratuityByNumberOfEnrolmentsPR_Base;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class DFAGratuityByNumberOfEnrolmentsPR
extends DFAGratuityByNumberOfEnrolmentsPR_Base {
    private static final int SCALE_FOR_INTERMEDIATE_CALCULATIONS = 8;

    protected DFAGratuityByNumberOfEnrolmentsPR() {
    }

    public DFAGratuityByNumberOfEnrolmentsPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money dfaTotalAmount, BigDecimal partialAcceptedPercentage) {
        this.init(EntryType.GRATUITY_FEE, EventType.GRATUITY, startDate, endDate, serviceAgreementTemplate, dfaTotalAmount, partialAcceptedPercentage);
    }

    protected Money calculateDFAGratuityTotalAmountToPay(Event event) {
        GratuityEvent gratuityEvent = (GratuityEvent)((Object)event);
        BigDecimal numberOfEnrolments = BigDecimal.valueOf(gratuityEvent.getEnrolmentsEctsForRegistration());
        BigDecimal ectsCredits = BigDecimal.valueOf(gratuityEvent.getStudentCurricularPlan().getCycle(CycleType.THIRD_CYCLE).getDefaultEcts(gratuityEvent.getExecutionYear()));
        Money result = this.getDfaTotalAmount().multiply(numberOfEnrolments.divide(ectsCredits, 8, RoundingMode.HALF_EVEN));
        return result.lessOrEqualThan(this.getDfaTotalAmount()) ? result : this.getDfaTotalAmount();
    }

    public DFAGratuityByNumberOfEnrolmentsPR edit(Money dfaTotalAmount, BigDecimal partialAcceptedPercentage) {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        return this.edit(new DateTime(), dfaTotalAmount, partialAcceptedPercentage);
    }

    public DFAGratuityByNumberOfEnrolmentsPR edit(DateTime startDate, Money dfaTotalAmount, BigDecimal partialAcceptedPercentage) {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        this.deactivate(startDate);
        return new DFAGratuityByNumberOfEnrolmentsPR(startDate, null, this.getServiceAgreementTemplate(), dfaTotalAmount, partialAcceptedPercentage);
    }
}

