/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.events.ExemptionJustification;
import org.fenixedu.academic.domain.accounting.events.PenaltyExemptionJustification;
import org.fenixedu.academic.domain.accounting.events.PenaltyExemptionJustificationFactory;
import org.fenixedu.academic.domain.accounting.events.PenaltyExemptionJustificationType;
import org.fenixedu.academic.domain.accounting.events.PenaltyExemption_Base;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public abstract class PenaltyExemption
extends PenaltyExemption_Base {
    protected PenaltyExemption() {
        super.setRootDomainObject(Bennu.getInstance());
    }

    protected PenaltyExemption(PenaltyExemptionJustificationType justificationType, GratuityEvent gratuityEvent, Person responsible, String comments, YearMonthDay dispatchDate) {
        this();
        this.init(justificationType, (Event)((Object)gratuityEvent), responsible, comments, dispatchDate);
    }

    protected void init(PenaltyExemptionJustificationType justificationType, Event event, Person responsible, String reason, YearMonthDay dispatchDate) {
        this.checkParameters(justificationType);
        super.init(responsible, event, (ExemptionJustification)((Object)PenaltyExemptionJustificationFactory.create(this, justificationType, reason, dispatchDate)));
        event.recalculateState(new DateTime());
    }

    private void checkParameters(PenaltyExemptionJustificationType penaltyExemptionType) {
        if (penaltyExemptionType == null) {
            throw new DomainException("error.accounting.events.gratuity.exemption.penalty.PenaltyExemption.penaltyExemptionType.cannot.be.null", new String[0]);
        }
    }

    public PenaltyExemptionJustificationType getJustificationType() {
        return this.getExemptionJustification().getPenaltyExemptionJustificationType();
    }

    public PenaltyExemptionJustification getExemptionJustification() {
        return (PenaltyExemptionJustification)((Object)super.getExemptionJustification());
    }

    public boolean isPenaltyExemption() {
        return true;
    }
}

