/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import jvstm.cps.ConsistencyPredicate;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonInstance_Base;
import org.fenixedu.academic.domain.Summary;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.space.LessonInstanceSpaceOccupation;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.ResourceAllocationRolePredicates;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.DomainObject;

public class LessonInstance
extends LessonInstance_Base {
    public static final Comparator<LessonInstance> COMPARATOR_BY_BEGIN_DATE_TIME = new Comparator<LessonInstance>(){

        @Override
        public int compare(LessonInstance o1, LessonInstance o2) {
            int c = o1.getBeginDateTime().compareTo((ReadableInstant)o2.getBeginDateTime());
            return c == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : c;
        }
    };

    public LessonInstance(Summary summary, Lesson lesson) {
        if (summary == null) {
            throw new DomainException("error.LessonInstance.empty.summary", new String[0]);
        }
        if (lesson == null) {
            throw new DomainException("error.LessonInstance.empty.lesson", new String[0]);
        }
        YearMonthDay day = summary.getSummaryDateYearMonthDay();
        LessonInstance lessonInstance = lesson.getLessonInstanceFor(day);
        if (lessonInstance != null) {
            throw new DomainException("error.lessonInstance.already.exist", new String[0]);
        }
        Space room = lesson.getSala();
        HourMinuteSecond beginTime = lesson.getBeginHourMinuteSecond();
        HourMinuteSecond endTime = lesson.getEndHourMinuteSecond();
        DateTime beginDateTime = new DateTime(day.getYear(), day.getMonthOfYear(), day.getDayOfMonth(), beginTime.getHour(), beginTime.getMinuteOfHour(), beginTime.getSecondOfMinute(), 0);
        DateTime endDateTime = new DateTime(day.getYear(), day.getMonthOfYear(), day.getDayOfMonth(), endTime.getHour(), endTime.getMinuteOfHour(), endTime.getSecondOfMinute(), 0);
        this.setRootDomainObject(Bennu.getInstance());
        this.setBeginDateTime(beginDateTime);
        this.setEndDateTime(endDateTime);
        YearMonthDay nextPossibleDay = this.findNextPossibleDateAfter(day, lesson);
        this.setLesson(lesson);
        this.summaryAndCourseLoadManagement(summary, lesson);
        lesson.refreshPeriodAndInstancesInSummaryCreation(nextPossibleDay);
        this.lessonInstanceSpaceOccupationManagement(room);
    }

    private YearMonthDay findNextPossibleDateAfter(YearMonthDay day, Lesson lesson) {
        for (YearMonthDay lessonDay : lesson.getAllLessonDatesWithoutInstanceDates()) {
            if (!lessonDay.isAfter((ReadablePartial)day)) continue;
            return lessonDay;
        }
        return lesson.isBiWeeklyOffset() ? day.plusDays(8) : day.plusDays(1);
    }

    public LessonInstance(Lesson lesson, YearMonthDay day) {
        if (day == null) {
            throw new DomainException("error.LessonInstance.empty.day", new String[0]);
        }
        if (lesson == null) {
            throw new DomainException("error.LessonInstance.empty.Lesson", new String[0]);
        }
        LessonInstance lessonInstance = lesson.getLessonInstanceFor(day);
        if (lessonInstance != null) {
            throw new DomainException("error.lessonInstance.already.exist", new String[0]);
        }
        Space room = lesson.getSala();
        HourMinuteSecond beginTime = lesson.getBeginHourMinuteSecond();
        HourMinuteSecond endTime = lesson.getEndHourMinuteSecond();
        DateTime beginDateTime = new DateTime(day.getYear(), day.getMonthOfYear(), day.getDayOfMonth(), beginTime.getHour(), beginTime.getMinuteOfHour(), beginTime.getSecondOfMinute(), 0);
        DateTime endDateTime = new DateTime(day.getYear(), day.getMonthOfYear(), day.getDayOfMonth(), endTime.getHour(), endTime.getMinuteOfHour(), endTime.getSecondOfMinute(), 0);
        this.setRootDomainObject(Bennu.getInstance());
        this.setBeginDateTime(beginDateTime);
        this.setEndDateTime(endDateTime);
        this.setLesson(lesson);
        this.lessonInstanceSpaceOccupationManagement(room);
    }

    public void delete() {
        AccessControl.check(this, ResourceAllocationRolePredicates.checkPermissionsToManageLessonInstances);
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        LessonInstanceSpaceOccupation occupation = this.getLessonInstanceSpaceOccupation();
        if (occupation != null) {
            occupation.removeLessonInstances(this);
            occupation.delete();
        }
        super.setCourseLoad(null);
        super.setLesson(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public void summaryAndCourseLoadManagement(Summary summary, Lesson lesson) {
        AccessControl.check(this, ResourceAllocationRolePredicates.checkPermissionsToManageLessonInstancesWithTeacherCheck);
        CourseLoad courseLoad = null;
        if (lesson != null && summary != null) {
            courseLoad = lesson.getExecutionCourse().getCourseLoadByShiftType(summary.getSummaryType());
        }
        this.setSummary(summary);
        this.setCourseLoad(courseLoad);
    }

    private int getUnitMinutes() {
        return Minutes.minutesBetween((ReadablePartial)this.getStartTime(), (ReadablePartial)this.getEndTime()).getMinutes();
    }

    public BigDecimal getInstanceDurationInHours() {
        return BigDecimal.valueOf(this.getUnitMinutes()).divide(BigDecimal.valueOf(Lesson.NUMBER_OF_MINUTES_IN_HOUR), 2, RoundingMode.HALF_UP);
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (this.getSummary() != null) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.LessonInstance.cannot.be.deleted", (String[])new String[0]));
        }
    }

    @ConsistencyPredicate
    protected boolean checkDateTimeInterval() {
        DateTime start = this.getBeginDateTime();
        DateTime end = this.getEndDateTime();
        return start != null && end != null && start.isBefore((ReadableInstant)end);
    }

    private void lessonInstanceSpaceOccupationManagement(Space space) {
        if (space != null) {
            Lesson lesson = this.getLesson();
            LessonInstanceSpaceOccupation instanceSpaceOccupation = (LessonInstanceSpaceOccupation)SpaceUtils.getFirstOccurrenceOfResourceAllocationByClass(space, lesson);
            instanceSpaceOccupation = instanceSpaceOccupation == null ? new LessonInstanceSpaceOccupation(space) : instanceSpaceOccupation;
            instanceSpaceOccupation.edit(this);
        }
    }

    public void setSummary(Summary summary) {
        if (summary == null) {
            throw new DomainException("error.LessonInstance.empty.summary", new String[0]);
        }
        super.setSummary(summary);
    }

    public void setCourseLoad(CourseLoad courseLoad) {
        if (courseLoad == null) {
            throw new DomainException("error.lessonInstance.empty.courseLoad", new String[0]);
        }
        super.setCourseLoad(courseLoad);
    }

    public void setLesson(Lesson lesson) {
        if (lesson == null) {
            throw new DomainException("error.lessonInstance.empty.lesson", new String[0]);
        }
        super.setLesson(lesson);
    }

    public YearMonthDay getDay() {
        return this.getBeginDateTime().toYearMonthDay();
    }

    public HourMinuteSecond getStartTime() {
        return new HourMinuteSecond(this.getBeginDateTime().getHourOfDay(), this.getBeginDateTime().getMinuteOfHour(), this.getBeginDateTime().getSecondOfMinute());
    }

    public HourMinuteSecond getEndTime() {
        return new HourMinuteSecond(this.getEndDateTime().getHourOfDay(), this.getEndDateTime().getMinuteOfHour(), this.getEndDateTime().getSecondOfMinute());
    }

    public Space getRoom() {
        return this.getLessonInstanceSpaceOccupation() != null ? this.getLessonInstanceSpaceOccupation().getRoom() : null;
    }

    public DiaSemana getDayOfweek() {
        return new DiaSemana(DiaSemana.getDiaSemana(this.getDay()));
    }

    public String prettyPrint() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDayOfweek().getDiaSemanaString()).append(" (");
        result.append(this.getStartTime().toString("HH:mm")).append(" - ");
        result.append(this.getEndDateTime().toString("HH:mm")).append(") ");
        result.append(this.getRoom() != null ? this.getRoom().getName() : "");
        return result.toString();
    }

    @Deprecated
    public Date getBegin() {
        DateTime dt = this.getBeginDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setBegin(Date date) {
        if (date == null) {
            this.setBeginDateTime(null);
        } else {
            this.setBeginDateTime(new DateTime(date.getTime()));
        }
    }

    @Deprecated
    public Date getEnd() {
        DateTime dt = this.getEndDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setEnd(Date date) {
        if (date == null) {
            this.setEndDateTime(null);
        } else {
            this.setEndDateTime(new DateTime(date.getTime()));
        }
    }

    public Interval getInterval() {
        return new Interval((ReadableInstant)this.getBeginDateTime(), (ReadableInstant)this.getEndDateTime());
    }
}

