/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.math.BigDecimal;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.EducationArea;
import org.fenixedu.academic.domain.FormationType;
import org.fenixedu.academic.domain.Formation_Base;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.QualificationType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionType;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionUnit;
import org.fenixedu.academic.domain.organizationalStructure.CountryUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.dto.alumni.formation.AlumniFormation;
import org.joda.time.DateTime;

public class Formation
extends Formation_Base {
    public static final Comparator<Formation> COMPARATOR_BY_BEGIN_YEAR = new Comparator<Formation>(){

        @Override
        public int compare(Formation f1, Formation f2) {
            if (f1.getBeginYear() != null && f2.getBeginYear() != null) {
                return f1.getBeginYear().compareTo(f2.getBeginYear());
            }
            return f1.getBeginYear() != null ? 1 : -1;
        }
    };

    public Formation() {
    }

    public Formation(Person person, FormationType formationType, QualificationType degree, EducationArea educationArea, String beginYear, String endYear, BigDecimal ectsCredits, Integer formationHours, AcademicalInstitutionUnit institution, AcademicalInstitutionUnit baseInstitution, AcademicalInstitutionType institutionType, CountryUnit countryUnit) {
        this();
        this.checkParameters(person, formationType, degree, educationArea, beginYear, endYear, ectsCredits, formationHours, baseInstitution, institutionType);
        this.setPerson(person);
        this.setFormationType(formationType);
        if (degree != null) {
            this.setDegree(degree.getName());
        }
        this.setType(degree);
        this.setEducationArea(educationArea);
        this.setBeginYear(beginYear);
        this.setYear(endYear);
        this.setInstitution((Unit)((Object)institution));
        this.setBaseInstitution((Unit)((Object)baseInstitution));
        this.setInstitutionType(institutionType);
        this.setEctsCredits(ectsCredits);
        this.setFormationHours(formationHours);
        this.setCountryUnit(countryUnit);
    }

    private void checkParameters(Person person, FormationType formationType, QualificationType degree, EducationArea educationArea, String beginYear, String endYear, BigDecimal ectsCredits, Integer formationHours, AcademicalInstitutionUnit institution, AcademicalInstitutionType institutionType) {
        if (person == null) {
            throw new DomainException("formation.creation.person.null", new String[0]);
        }
        if (formationType == null && degree == null && educationArea == null && StringUtils.isEmpty((String)beginYear) && StringUtils.isEmpty((String)endYear) && ectsCredits == null && institutionType == null && institution == null) {
            throw new DomainException("formation.creation.allFields.null", new String[0]);
        }
        if (!StringUtils.isEmpty((String)beginYear) && !StringUtils.isEmpty((String)endYear) && Integer.parseInt(beginYear) > Integer.parseInt(endYear)) {
            throw new DomainException("formation.creation.beginDate.after.endDate", new String[0]);
        }
    }

    public void delete() {
        this.setEducationArea(null);
        this.setInstitution(null);
        this.setBaseInstitution(null);
        this.setCountryUnit(null);
        this.setCreator(null);
        super.delete();
    }

    public void edit(AlumniFormation formation, AcademicalInstitutionUnit academicalInstitutionUnit) {
        this.checkParameters(formation.getAssociatedFormation().getPerson(), formation.getFormationType(), formation.getFormationDegree(), formation.getEducationArea(), formation.getFormationBeginYear(), formation.getFormationEndYear(), formation.getFormationCredits(), formation.getFormationHours(), formation.getParentInstitution(), formation.getInstitutionType());
        this.setFormationType(formation.getFormationType());
        if (formation.getFormationDegree() != null) {
            this.setDegree(formation.getFormationDegree().getName());
        } else {
            this.setDegree(null);
        }
        this.setType(formation.getFormationDegree());
        this.setEducationArea(formation.getEducationArea());
        this.setBeginYear(formation.getFormationBeginYear());
        this.setYear(formation.getFormationEndYear());
        this.setEctsCredits(formation.getFormationCredits());
        this.setFormationHours(formation.getFormationHours());
        this.setInstitutionType(formation.getInstitutionType());
        this.setInstitution((Unit)((Object)academicalInstitutionUnit));
        this.setBaseInstitution((Unit)((Object)formation.getParentInstitution()));
        this.setCountryUnit(formation.getCountryUnit());
        this.setLastModificationDateDateTime(new DateTime());
    }
}

