/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Collection;
import java.util.UUID;
import org.fenixedu.academic.domain.Alumni;
import org.fenixedu.academic.domain.Installation;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;

public class AlumniManager {
    public Alumni checkAlumniIdentity(String documentIdNumber, String email) {
        Person person = this.getPerson(documentIdNumber);
        if (person == null) {
            throw new DomainException("error.alumni.person.does.not.exist", documentIdNumber);
        }
        if (person.getStudent() == null) {
            throw new DomainException("error.alumni.person.does.not.have.student.info", documentIdNumber);
        }
        this.checkRulesToRegisterAlumni(person.getStudent().getNumber(), documentIdNumber);
        Alumni alumni = this.getAlumni(person.getStudent().getNumber());
        if (alumni.isRegistered()) {
            throw new DomainException("error.alumni.already.registered", new String[0]);
        }
        alumni.addIfNotExistsEmail(email);
        return alumni;
    }

    private Person getPerson(String documentIdNumber) {
        Collection<Person> personList = Person.readByDocumentIdNumber(documentIdNumber);
        if (personList.size() > 0) {
            return personList.iterator().next();
        }
        return null;
    }

    public Alumni registerAlumni(Student student) {
        Alumni alumni = new Alumni(student);
        return alumni;
    }

    public Alumni registerAlumni(Integer studentNumber, String documentIdNumber, String email) {
        this.checkRulesToRegisterAlumni(studentNumber, documentIdNumber);
        Alumni alumni = this.getAlumni(studentNumber);
        if (alumni.isRegistered()) {
            throw new DomainException("error.alumni.already.registered", new String[0]);
        }
        alumni.setUrlRequestToken(UUID.randomUUID());
        alumni.addIfNotExistsEmail(email);
        return alumni;
    }

    private void checkRulesToRegisterAlumni(Integer studentNumber, String documentIdNumber) {
        Student student = Student.readStudentByNumber(studentNumber);
        if (student == null) {
            if (Person.findPersonByDocumentID(documentIdNumber).isEmpty()) {
                throw new DomainException("error.person.document.number", Unit.getInstitutionAcronym());
            }
            throw new DomainException("error.person.no.student", Unit.getInstitutionAcronym());
        }
        if (!student.getPerson().getDocumentIdNumber().equals(documentIdNumber.trim())) {
            throw new DomainException("error.document.number.student.number.mismatch", new String[0]);
        }
        if (!this.checkAlumni(student)) {
            if (!student.getRegistrationsSet().isEmpty()) {
                for (Registration registration : student.getRegistrationsSet()) {
                    if (!registration.isConcluded()) continue;
                    return;
                }
                throw new DomainException("error.no.concluded.registrations", new String[0]);
            }
            throw new DomainException("error.no.registrations", Unit.getInstitutionAcronym(), Installation.getInstance().getInstituitionalEmailAddress("alumni"));
        }
    }

    private boolean checkAlumni(Student alumniStudent) {
        return alumniStudent.getAlumni() != null || RoleType.ALUMNI.isMember(alumniStudent.getPerson().getUser());
    }

    private Alumni getAlumni(Integer studentNumber) {
        Student student = Student.readStudentByNumber(studentNumber);
        return student.getAlumni() != null ? student.getAlumni() : new Alumni(student);
    }
}

