/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.thesis.teacher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.ui.struts.action.phd.PhdDocumentsZip;
import org.fenixedu.academic.ui.struts.action.phd.teacher.PhdIndividualProgramProcessDA;
import org.fenixedu.academic.ui.struts.action.phd.thesis.CommonPhdThesisProcessDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/phdThesisProcess", module="teacher", functionality=PhdIndividualProgramProcessDA.class)
@Forwards(value={@Forward(name="manageThesisDocuments", path="/phd/thesis/teacher/manageThesisDocuments.jsp"), @Forward(name="juryReporterFeedbackUpload", path="/phd/thesis/teacher/juryReporterFeedbackUpload.jsp"), @Forward(name="scheduleThesisMeeting", path="/phd/thesis/teacher/scheduleThesisMeeting.jsp")})
public class PhdThesisProcessDA
extends CommonPhdThesisProcessDA {
    private static final List<PhdIndividualProgramDocumentType> AVAILABLE_DOCUMENTS_TO_TEACHER = Arrays.asList(PhdIndividualProgramDocumentType.DISSERTATION_OR_FINAL_WORK_DOCUMENT, PhdIndividualProgramDocumentType.FINAL_THESIS, PhdIndividualProgramDocumentType.JURY_PRESIDENT_ELEMENT, PhdIndividualProgramDocumentType.JURY_REPORT_FEEDBACK, PhdIndividualProgramDocumentType.MAXIMUM_GRADE_GUIDER_PROPOSAL, PhdIndividualProgramDocumentType.PROVISIONAL_THESIS, PhdIndividualProgramDocumentType.PUBLIC_PRESENTATION_SEMINAR_REPORT, PhdIndividualProgramDocumentType.THESIS_ABSTRACT);

    @Override
    public ActionForward manageThesisDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ArrayList<PhdProgramProcessDocument> sharedDocuments = new ArrayList<PhdProgramProcessDocument>();
        PhdThesisProcess thesisProcess = this.getProcess(request);
        Set latestDocumentVersions = thesisProcess.getLatestDocumentVersions();
        for (PhdProgramProcessDocument phdProgramProcessDocument : latestDocumentVersions) {
            if (!AVAILABLE_DOCUMENTS_TO_TEACHER.contains((Object)phdProgramProcessDocument.getDocumentType())) continue;
            sharedDocuments.add(phdProgramProcessDocument);
        }
        request.setAttribute("sharedDocuments", sharedDocuments);
        return super.manageThesisDocuments(mapping, actionForm, request, response);
    }

    @Override
    public ActionForward downloadThesisDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.writeFile(response, this.getThesisDocumentsFilename(request), PhdDocumentsZip.ZIP_MIME_TYPE, this.createThesisZip(request));
        return null;
    }

    protected byte[] createThesisZip(HttpServletRequest request) throws IOException {
        PhdThesisProcess thesisProcess = this.getProcess(request);
        ArrayList<PhdProgramProcessDocument> sharedDocuments = new ArrayList<PhdProgramProcessDocument>();
        Set latestDocumentVersions = thesisProcess.getLatestDocumentVersions();
        for (PhdProgramProcessDocument phdProgramProcessDocument : latestDocumentVersions) {
            if (!AVAILABLE_DOCUMENTS_TO_TEACHER.contains((Object)phdProgramProcessDocument.getDocumentType())) continue;
            sharedDocuments.add(phdProgramProcessDocument);
        }
        return PhdDocumentsZip.zip(sharedDocuments);
    }
}

